/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.job;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonAlias;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;

public final class JobSubmitRequestBody
implements RequestBody {
    public static final String FIELD_NAME_JOB_GRAPH = "jobGraphFileName";
    public static final String FIELD_NAME_EXECUTION_PLAN = "executionPlanFileName";
    private static final String FIELD_NAME_JOB_JARS = "jobJarFileNames";
    private static final String FIELD_NAME_JOB_ARTIFACTS = "jobArtifactFileNames";
    @JsonProperty(value="executionPlanFileName")
    @JsonAlias(value={"jobGraphFileName"})
    @Nullable
    public final String executionPlanFileName;
    @JsonProperty(value="jobJarFileNames")
    @Nonnull
    public final Collection<String> jarFileNames;
    @JsonProperty(value="jobArtifactFileNames")
    @Nonnull
    public final Collection<DistributedCacheFile> artifactFileNames;

    @JsonCreator
    public JobSubmitRequestBody(@Nullable @JsonProperty(value="executionPlanFileName") String executionPlanFileName, @Nullable @JsonProperty(value="jobJarFileNames") Collection<String> jarFileNames, @Nullable @JsonProperty(value="jobArtifactFileNames") Collection<DistributedCacheFile> artifactFileNames) {
        this.executionPlanFileName = executionPlanFileName;
        this.jarFileNames = jarFileNames == null ? Collections.emptyList() : jarFileNames;
        this.artifactFileNames = artifactFileNames == null ? Collections.emptyList() : artifactFileNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobSubmitRequestBody that = (JobSubmitRequestBody)o;
        return Objects.equals(this.executionPlanFileName, that.executionPlanFileName) && Objects.equals(this.jarFileNames, that.jarFileNames) && Objects.equals(this.artifactFileNames, that.artifactFileNames);
    }

    public int hashCode() {
        return Objects.hash(this.executionPlanFileName, this.jarFileNames, this.artifactFileNames);
    }

    public String toString() {
        return "JobSubmitRequestBody{executionPlanFileName='" + this.executionPlanFileName + "', jarFileNames=" + this.jarFileNames + ", artifactFileNames=" + this.artifactFileNames + "}";
    }

    public static class DistributedCacheFile {
        private static final String FIELD_NAME_ENTRY_NAME = "entryName";
        private static final String FIELD_NAME_FILE_NAME = "fileName";
        @JsonProperty(value="entryName")
        public final String entryName;
        @JsonProperty(value="fileName")
        public final String fileName;

        @JsonCreator
        public DistributedCacheFile(@JsonProperty(value="entryName") String entryName, @JsonProperty(value="fileName") String fileName) {
            this.entryName = entryName;
            this.fileName = fileName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DistributedCacheFile that = (DistributedCacheFile)o;
            return Objects.equals(this.entryName, that.entryName) && Objects.equals(this.fileName, that.fileName);
        }

        public int hashCode() {
            return Objects.hash(this.entryName, this.fileName);
        }

        public String toString() {
            return "DistributedCacheFile{entryName='" + this.entryName + "', fileName='" + this.fileName + "'}";
        }
    }
}

