/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufAllocator;

public abstract class AbstractCompositeBuffer
implements Buffer {
    protected final Buffer.DataType dataType;
    protected final int length;
    protected final boolean isCompressed;
    protected final List<Buffer> partialBuffers = new ArrayList<Buffer>();
    protected int currentLength;
    protected ByteBufAllocator allocator;

    protected AbstractCompositeBuffer(Buffer.DataType dataType, int length, boolean isCompressed) {
        this.dataType = dataType;
        this.length = length;
        this.isCompressed = isCompressed;
    }

    @Override
    public boolean isBuffer() {
        return this.dataType.isBuffer();
    }

    @Override
    public void recycleBuffer() {
        for (Buffer partialBuffer : this.partialBuffers) {
            partialBuffer.recycleBuffer();
        }
    }

    @Override
    public Buffer retainBuffer() {
        for (Buffer partialBuffer : this.partialBuffers) {
            partialBuffer.retainBuffer();
        }
        return this;
    }

    @Override
    public int getSize() {
        return this.currentLength;
    }

    @Override
    public int readableBytes() {
        return this.currentLength;
    }

    @Override
    public void setAllocator(ByteBufAllocator allocator) {
        this.allocator = allocator;
    }

    @Override
    public boolean isCompressed() {
        return this.isCompressed;
    }

    @Override
    public Buffer.DataType getDataType() {
        return this.dataType;
    }

    public abstract void addPartialBuffer(Buffer var1);

    public List<Buffer> getPartialBuffers() {
        return Collections.unmodifiableList(this.partialBuffers);
    }

    public int missingLength() {
        return this.length - this.currentLength;
    }

    @Override
    public MemorySegment getMemorySegment() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMemorySegmentOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BufferRecycler getRecycler() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRecycler(BufferRecycler bufferRecycler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isRecycled() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Buffer readOnlySlice() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Buffer readOnlySlice(int index, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxCapacity() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getReaderIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setReaderIndex(int readerIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSize(int writerIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer getNioBufferReadable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer getNioBuffer(int index, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCompressed(boolean isCompressed) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDataType(Buffer.DataType dataType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int refCnt() {
        throw new UnsupportedOperationException();
    }
}

