/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.v2.adaptor;

import java.util.List;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.api.common.state.v2.StateIterator;
import org.apache.flink.core.state.StateFutureUtils;
import org.apache.flink.runtime.state.internal.InternalListState;
import org.apache.flink.runtime.state.v2.adaptor.CompleteStateIterator;
import org.apache.flink.runtime.state.v2.adaptor.StateAdaptor;

public class ListStateAdaptor<K, N, V>
extends StateAdaptor<K, N, InternalListState<K, N, V>>
implements org.apache.flink.runtime.state.v2.internal.InternalListState<K, N, V> {
    public ListStateAdaptor(InternalListState<K, N, V> listState) {
        super(listState);
    }

    public StateFuture<Void> asyncUpdate(List<V> values) {
        try {
            ((InternalListState)this.delegatedState).update(values);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while updating values to raw ListState", e);
        }
        return StateFutureUtils.completedVoidFuture();
    }

    public void update(List<V> values) {
        try {
            ((InternalListState)this.delegatedState).update(values);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while updating values to raw ListState", e);
        }
    }

    public StateFuture<Void> asyncAddAll(List<V> values) {
        try {
            ((InternalListState)this.delegatedState).addAll(values);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while adding values to raw ListState", e);
        }
        return StateFutureUtils.completedVoidFuture();
    }

    public void addAll(List<V> values) {
        try {
            ((InternalListState)this.delegatedState).addAll(values);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while adding values to raw ListState", e);
        }
    }

    public StateFuture<StateIterator<V>> asyncGet() {
        try {
            return StateFutureUtils.completedFuture(new CompleteStateIterator((Iterable)((InternalListState)this.delegatedState).get()));
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting values from raw ListState", e);
        }
    }

    public Iterable<V> get() {
        try {
            return (Iterable)((InternalListState)this.delegatedState).get();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting values from raw ListState", e);
        }
    }

    public StateFuture<Void> asyncAdd(V value) {
        try {
            ((InternalListState)this.delegatedState).add(value);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while adding value to raw ListState", e);
        }
        return StateFutureUtils.completedVoidFuture();
    }

    public void add(V value) {
        try {
            ((InternalListState)this.delegatedState).add(value);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while adding value to raw ListState", e);
        }
    }
}

