/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.v2;

import javax.annotation.Nonnull;
import org.apache.flink.api.common.state.v2.AggregatingState;
import org.apache.flink.api.common.state.v2.ListState;
import org.apache.flink.api.common.state.v2.MapState;
import org.apache.flink.api.common.state.v2.ReducingState;
import org.apache.flink.api.common.state.v2.ValueState;
import org.apache.flink.runtime.state.AsyncKeyedStateBackend;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.runtime.state.v2.AggregatingStateDescriptor;
import org.apache.flink.runtime.state.v2.KeyedStateStoreV2;
import org.apache.flink.runtime.state.v2.ListStateDescriptor;
import org.apache.flink.runtime.state.v2.MapStateDescriptor;
import org.apache.flink.runtime.state.v2.ReducingStateDescriptor;
import org.apache.flink.runtime.state.v2.ValueStateDescriptor;
import org.apache.flink.util.Preconditions;

public class DefaultKeyedStateStoreV2
implements KeyedStateStoreV2 {
    private final AsyncKeyedStateBackend<?> asyncKeyedStateBackend;

    public DefaultKeyedStateStoreV2(@Nonnull AsyncKeyedStateBackend asyncKeyedStateBackend) {
        this.asyncKeyedStateBackend = (AsyncKeyedStateBackend)Preconditions.checkNotNull((Object)asyncKeyedStateBackend);
    }

    @Override
    public <T> ValueState<T> getValueState(@Nonnull ValueStateDescriptor<T> stateProperties) {
        Preconditions.checkNotNull(stateProperties, (String)"The state properties must not be null");
        try {
            return (ValueState)this.asyncKeyedStateBackend.createState(VoidNamespace.INSTANCE, VoidNamespaceSerializer.INSTANCE, stateProperties);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting state", e);
        }
    }

    @Override
    public <T> ListState<T> getListState(@Nonnull ListStateDescriptor<T> stateProperties) {
        Preconditions.checkNotNull(stateProperties, (String)"The state properties must not be null");
        try {
            return (ListState)this.asyncKeyedStateBackend.createState(VoidNamespace.INSTANCE, VoidNamespaceSerializer.INSTANCE, stateProperties);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting state", e);
        }
    }

    @Override
    public <UK, UV> MapState<UK, UV> getMapState(@Nonnull MapStateDescriptor<UK, UV> stateProperties) {
        Preconditions.checkNotNull(stateProperties, (String)"The state properties must not be null");
        try {
            return (MapState)this.asyncKeyedStateBackend.createState(VoidNamespace.INSTANCE, VoidNamespaceSerializer.INSTANCE, stateProperties);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting state", e);
        }
    }

    @Override
    public <T> ReducingState<T> getReducingState(@Nonnull ReducingStateDescriptor<T> stateProperties) {
        Preconditions.checkNotNull(stateProperties, (String)"The state properties must not be null");
        try {
            return (ReducingState)this.asyncKeyedStateBackend.createState(VoidNamespace.INSTANCE, VoidNamespaceSerializer.INSTANCE, stateProperties);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting state", e);
        }
    }

    @Override
    public <IN, ACC, OUT> AggregatingState<IN, OUT> getAggregatingState(@Nonnull AggregatingStateDescriptor<IN, ACC, OUT> stateProperties) {
        Preconditions.checkNotNull(stateProperties, (String)"The state properties must not be null");
        try {
            return (AggregatingState)this.asyncKeyedStateBackend.createState(VoidNamespace.INSTANCE, VoidNamespaceSerializer.INSTANCE, stateProperties);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting state", e);
        }
    }
}

