/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.v2;

import java.util.List;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.api.common.state.v2.StateIterator;
import org.apache.flink.runtime.asyncprocessing.StateRequestHandler;
import org.apache.flink.runtime.asyncprocessing.StateRequestType;
import org.apache.flink.runtime.state.v2.AbstractKeyedState;
import org.apache.flink.runtime.state.v2.ListStateDescriptor;
import org.apache.flink.runtime.state.v2.SyncIteratorWrapper;
import org.apache.flink.runtime.state.v2.internal.InternalListState;

public class AbstractListState<K, N, V>
extends AbstractKeyedState<K, N, V>
implements InternalListState<K, N, V> {
    public AbstractListState(StateRequestHandler stateRequestHandler, ListStateDescriptor<V> stateDescriptor) {
        super(stateRequestHandler, stateDescriptor);
    }

    public StateFuture<StateIterator<V>> asyncGet() {
        return this.handleRequest(StateRequestType.LIST_GET, null);
    }

    public StateFuture<Void> asyncAdd(V value) {
        return this.handleRequest(StateRequestType.LIST_ADD, value);
    }

    public StateFuture<Void> asyncUpdate(List<V> values) {
        return this.handleRequest(StateRequestType.LIST_UPDATE, values);
    }

    public StateFuture<Void> asyncAddAll(List<V> values) {
        return this.handleRequest(StateRequestType.LIST_ADD_ALL, values);
    }

    public Iterable<V> get() {
        return () -> {
            StateIterator stateIterator = (StateIterator)this.handleRequestSync(StateRequestType.LIST_GET, null);
            return new SyncIteratorWrapper(stateIterator);
        };
    }

    public void add(V value) {
        this.handleRequestSync(StateRequestType.LIST_ADD, value);
    }

    public void update(List<V> values) {
        this.handleRequestSync(StateRequestType.LIST_UPDATE, values);
    }

    public void addAll(List<V> values) {
        this.handleRequestSync(StateRequestType.LIST_ADD_ALL, values);
    }
}

