/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.util.Preconditions;

public class KeyGroupRangeOffsets
implements Iterable<Tuple2<Integer, Long>>,
Serializable {
    private static final long serialVersionUID = 6595415219136429696L;
    private final KeyGroupRange keyGroupRange;
    private final long[] offsets;

    public static IllegalArgumentException newIllegalKeyGroupException(int keyGroup, KeyGroupRange keyGroupRange) {
        return new IllegalArgumentException(String.format("Key group %d is not in %s. Unless you're directly using low level state access APIs, this is most likely caused by non-deterministic shuffle key (hashCode and equals implementation).", keyGroup, keyGroupRange));
    }

    public KeyGroupRangeOffsets(KeyGroupRange keyGroupRange, long[] offsets) {
        this.keyGroupRange = (KeyGroupRange)Preconditions.checkNotNull((Object)keyGroupRange);
        this.offsets = (long[])Preconditions.checkNotNull((Object)offsets);
        Preconditions.checkArgument((offsets.length == keyGroupRange.getNumberOfKeyGroups() ? 1 : 0) != 0);
    }

    public KeyGroupRangeOffsets(int rangeStart, int rangeEnd, long[] offsets) {
        this(KeyGroupRange.of(rangeStart, rangeEnd), offsets);
    }

    public KeyGroupRangeOffsets(int rangeStart, int rangeEnd) {
        this(KeyGroupRange.of(rangeStart, rangeEnd));
    }

    public KeyGroupRangeOffsets(KeyGroupRange keyGroupRange) {
        this(keyGroupRange, new long[keyGroupRange.getNumberOfKeyGroups()]);
    }

    public long getKeyGroupOffset(int keyGroup) {
        return this.offsets[this.computeKeyGroupIndex(keyGroup)];
    }

    public void setKeyGroupOffset(int keyGroup, long offset) {
        this.offsets[this.computeKeyGroupIndex((int)keyGroup)] = offset;
    }

    public KeyGroupRangeOffsets getIntersection(KeyGroupRange keyGroupRange) {
        Preconditions.checkNotNull((Object)keyGroupRange);
        KeyGroupRange intersection = this.keyGroupRange.getIntersection(keyGroupRange);
        long[] subOffsets = new long[intersection.getNumberOfKeyGroups()];
        if (subOffsets.length > 0) {
            System.arraycopy(this.offsets, this.computeKeyGroupIndex(intersection.getStartKeyGroup()), subOffsets, 0, subOffsets.length);
        }
        return new KeyGroupRangeOffsets(intersection, subOffsets);
    }

    public KeyGroupRange getKeyGroupRange() {
        return this.keyGroupRange;
    }

    @Override
    public Iterator<Tuple2<Integer, Long>> iterator() {
        return new KeyGroupOffsetsIterator();
    }

    private int computeKeyGroupIndex(int keyGroup) {
        int idx = keyGroup - this.keyGroupRange.getStartKeyGroup();
        if (idx < 0 || idx >= this.offsets.length) {
            throw KeyGroupRangeOffsets.newIllegalKeyGroupException(keyGroup, this.keyGroupRange);
        }
        return idx;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyGroupRangeOffsets)) {
            return false;
        }
        KeyGroupRangeOffsets that = (KeyGroupRangeOffsets)o;
        if (this.keyGroupRange != null ? !this.keyGroupRange.equals(that.keyGroupRange) : that.keyGroupRange != null) {
            return false;
        }
        return Arrays.equals(this.offsets, that.offsets);
    }

    public int hashCode() {
        int result = this.keyGroupRange != null ? this.keyGroupRange.hashCode() : 0;
        result = 31 * result + Arrays.hashCode(this.offsets);
        return result;
    }

    public String toString() {
        return "KeyGroupRangeOffsets{keyGroupRange=" + this.keyGroupRange + (String)(this.offsets.length > 10 ? "" : ", offsets=" + Arrays.toString(this.offsets)) + "}";
    }

    private final class KeyGroupOffsetsIterator
    implements Iterator<Tuple2<Integer, Long>> {
        private final Iterator<Integer> keyGroupIterator;

        public KeyGroupOffsetsIterator() {
            this.keyGroupIterator = KeyGroupRangeOffsets.this.keyGroupRange.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.keyGroupIterator.hasNext();
        }

        @Override
        public Tuple2<Integer, Long> next() {
            Integer currentKeyGroup = this.keyGroupIterator.next();
            Tuple2 result = new Tuple2((Object)currentKeyGroup, (Object)KeyGroupRangeOffsets.this.offsets[currentKeyGroup - KeyGroupRangeOffsets.this.keyGroupRange.getStartKeyGroup()]);
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unsupported by this iterator!");
        }
    }
}

