/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import org.apache.flink.runtime.scheduler.adaptive.FailureResult;
import org.apache.flink.runtime.scheduler.adaptive.StateTransitions;
import org.apache.flink.runtime.scheduler.adaptive.StateWithExecutionGraph;

public class FailureResultUtil {
    public static <T extends StateTransitions.ToRestarting & StateTransitions.ToFailing> void restartOrFail(FailureResult failureResult, T context, StateWithExecutionGraph sweg) {
        if (failureResult.canRestart()) {
            sweg.getLogger().info("Restarting job.", failureResult.getFailureCause());
            context.goToRestarting(sweg.getExecutionGraph(), sweg.getExecutionGraphHandler(), sweg.getOperatorCoordinatorHandler(), failureResult.getBackoffTime(), false, sweg.getFailures());
        } else {
            sweg.getLogger().info("Failing job.", failureResult.getFailureCause());
            ((StateTransitions.ToFailing)context).goToFailing(sweg.getExecutionGraph(), sweg.getExecutionGraphHandler(), sweg.getOperatorCoordinatorHandler(), failureResult.getFailureCause(), sweg.getFailures());
        }
    }
}

