/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.Collections;
import java.util.Map;
import org.apache.flink.runtime.executiongraph.JobVertexInputInfo;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.util.Preconditions;

public class ParallelismAndInputInfos {
    private final int parallelism;
    private final Map<IntermediateDataSetID, JobVertexInputInfo> jobVertexInputInfos;

    public ParallelismAndInputInfos(int parallelism, Map<IntermediateDataSetID, JobVertexInputInfo> jobVertexInputInfos) {
        Preconditions.checkArgument((parallelism > 0 ? 1 : 0) != 0);
        jobVertexInputInfos.values().forEach(jobVertexInputInfo -> Preconditions.checkArgument((jobVertexInputInfo.getExecutionVertexInputInfos().size() == parallelism ? 1 : 0) != 0));
        this.parallelism = parallelism;
        this.jobVertexInputInfos = (Map)Preconditions.checkNotNull(jobVertexInputInfos);
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public Map<IntermediateDataSetID, JobVertexInputInfo> getJobVertexInputInfos() {
        return Collections.unmodifiableMap(this.jobVertexInputInfos);
    }
}

