/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.api.common.resources.ExternalResource;
import org.apache.flink.api.common.resources.Resource;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.externalresource.ExternalResourceUtils;
import org.apache.flink.runtime.util.config.memory.CommonProcessMemorySpec;
import org.apache.flink.runtime.util.config.memory.JvmMetaspaceAndOverhead;
import org.apache.flink.runtime.util.config.memory.taskmanager.TaskExecutorFlinkMemory;
import org.apache.flink.util.Preconditions;

public class TaskExecutorProcessSpec
extends CommonProcessMemorySpec<TaskExecutorFlinkMemory> {
    private static final long serialVersionUID = 1L;
    private final CPUResource cpuCores;
    private final int numSlots;
    private final Map<String, ExternalResource> extendedResources;

    @VisibleForTesting
    public TaskExecutorProcessSpec(CPUResource cpuCores, MemorySize frameworkHeapSize, MemorySize frameworkOffHeapSize, MemorySize taskHeapSize, MemorySize taskOffHeapSize, MemorySize networkMemSize, MemorySize managedMemorySize, MemorySize jvmMetaspaceSize, MemorySize jvmOverheadSize, Collection<ExternalResource> extendedResources) {
        this(cpuCores, new TaskExecutorFlinkMemory(frameworkHeapSize, frameworkOffHeapSize, taskHeapSize, taskOffHeapSize, networkMemSize, managedMemorySize), new JvmMetaspaceAndOverhead(jvmMetaspaceSize, jvmOverheadSize), 1, extendedResources);
    }

    protected TaskExecutorProcessSpec(CPUResource cpuCores, TaskExecutorFlinkMemory flinkMemory, JvmMetaspaceAndOverhead jvmMetaspaceAndOverhead, int numSlots, Collection<ExternalResource> extendedResources) {
        super(flinkMemory, jvmMetaspaceAndOverhead);
        this.cpuCores = cpuCores;
        this.numSlots = numSlots;
        this.extendedResources = ((Collection)Preconditions.checkNotNull(extendedResources)).stream().filter(resource -> !resource.isZero()).collect(Collectors.toMap(Resource::getName, Function.identity()));
        Preconditions.checkArgument((this.extendedResources.size() == extendedResources.size() ? 1 : 0) != 0, (Object)"Duplicate resource name encountered in external resources.");
    }

    public CPUResource getCpuCores() {
        return this.cpuCores;
    }

    MemorySize getFrameworkHeapSize() {
        return ((TaskExecutorFlinkMemory)this.getFlinkMemory()).getFrameworkHeap();
    }

    MemorySize getFrameworkOffHeapMemorySize() {
        return ((TaskExecutorFlinkMemory)this.getFlinkMemory()).getFrameworkOffHeap();
    }

    public MemorySize getTaskHeapSize() {
        return ((TaskExecutorFlinkMemory)this.getFlinkMemory()).getTaskHeap();
    }

    public MemorySize getTaskOffHeapSize() {
        return ((TaskExecutorFlinkMemory)this.getFlinkMemory()).getTaskOffHeap();
    }

    public MemorySize getNetworkMemSize() {
        return ((TaskExecutorFlinkMemory)this.getFlinkMemory()).getNetwork();
    }

    public MemorySize getManagedMemorySize() {
        return ((TaskExecutorFlinkMemory)this.getFlinkMemory()).getManaged();
    }

    public int getNumSlots() {
        return this.numSlots;
    }

    public Map<String, ExternalResource> getExtendedResources() {
        return Collections.unmodifiableMap(this.extendedResources);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TaskExecutorProcessSpec) {
            TaskExecutorProcessSpec that = (TaskExecutorProcessSpec)obj;
            return Objects.equals(this.cpuCores, that.cpuCores) && Objects.equals(this.getJvmMetaspaceAndOverhead(), that.getJvmMetaspaceAndOverhead()) && Objects.equals(this.getFlinkMemory(), that.getFlinkMemory()) && Objects.equals(this.numSlots, that.numSlots) && Objects.equals(this.getExtendedResources(), that.getExtendedResources());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getJvmMetaspaceAndOverhead(), this.getFlinkMemory(), this.cpuCores, this.numSlots, this.extendedResources);
    }

    public String toString() {
        return "TaskExecutorProcessSpec {cpuCores=" + this.cpuCores.getValue().doubleValue() + ", frameworkHeapSize=" + this.getFrameworkHeapSize().toHumanReadableString() + ", frameworkOffHeapSize=" + this.getFrameworkOffHeapMemorySize().toHumanReadableString() + ", taskHeapSize=" + this.getTaskHeapSize().toHumanReadableString() + ", taskOffHeapSize=" + this.getTaskOffHeapSize().toHumanReadableString() + ", networkMemSize=" + this.getNetworkMemSize().toHumanReadableString() + ", managedMemorySize=" + this.getManagedMemorySize().toHumanReadableString() + ", jvmMetaspaceSize=" + this.getJvmMetaspaceSize().toHumanReadableString() + ", jvmOverheadSize=" + this.getJvmOverheadSize().toHumanReadableString() + ", numSlots=" + this.numSlots + (String)(this.extendedResources.isEmpty() ? "" : ", " + ExternalResourceUtils.generateExternalResourcesString(this.extendedResources.values())) + "}";
    }
}

