/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing.operators;

import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.state.v2.State;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.runtime.asyncprocessing.AsyncExecutionController;
import org.apache.flink.runtime.asyncprocessing.AsyncStateException;
import org.apache.flink.runtime.asyncprocessing.RecordContext;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.state.AsyncKeyedStateBackend;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.v2.StateDescriptor;
import org.apache.flink.runtime.state.v2.adaptor.AsyncKeyedStateBackendAdaptor;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorV2;
import org.apache.flink.streaming.api.operators.InternalTimeServiceManager;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.OperatorSnapshotFutures;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.operators.StreamTaskStateInitializer;
import org.apache.flink.streaming.api.operators.Triggerable;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.operators.asyncprocessing.AsyncStateProcessingOperator;
import org.apache.flink.streaming.runtime.operators.asyncprocessing.ElementOrder;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.ThrowingConsumer;
import org.apache.flink.util.function.ThrowingRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class AbstractAsyncStateStreamOperatorV2<OUT>
extends AbstractStreamOperatorV2<OUT>
implements AsyncStateProcessingOperator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAsyncStateStreamOperatorV2.class);
    private final Environment environment;
    private AsyncExecutionController asyncExecutionController;
    private RecordContext currentProcessingContext;

    public AbstractAsyncStateStreamOperatorV2(StreamOperatorParameters<OUT> parameters, int numberOfInputs) {
        super(parameters, numberOfInputs);
        this.environment = parameters.getContainingTask().getEnvironment();
    }

    @Override
    public final void initializeState(StreamTaskStateInitializer streamTaskStateManager) throws Exception {
        super.initializeState(streamTaskStateManager);
        this.getRuntimeContext().setKeyedStateStoreV2(this.stateHandler.getKeyedStateStoreV2().orElse(null));
        int inFlightRecordsLimit = this.getExecutionConfig().getAsyncInflightRecordsLimit();
        int asyncBufferSize = this.getExecutionConfig().getAsyncStateBufferSize();
        long asyncBufferTimeout = this.getExecutionConfig().getAsyncStateBufferTimeout();
        int maxParallelism = this.getExecutionConfig().getMaxParallelism();
        AsyncKeyedStateBackend asyncKeyedStateBackend = this.stateHandler.getAsyncKeyedStateBackend();
        if (asyncKeyedStateBackend != null) {
            this.asyncExecutionController = new AsyncExecutionController(this.environment.getMainMailboxExecutor(), this::handleAsyncStateException, asyncKeyedStateBackend.createStateExecutor(), maxParallelism, asyncBufferSize, asyncBufferTimeout, inFlightRecordsLimit, asyncKeyedStateBackend);
            asyncKeyedStateBackend.setup(this.asyncExecutionController);
            if (asyncKeyedStateBackend instanceof AsyncKeyedStateBackendAdaptor) {
                LOG.warn("A normal KeyedStateBackend({}) is used when enabling the async state processing. Parallel asynchronous processing does not work. All state access will be processed synchronously.", this.stateHandler.getKeyedStateBackend());
            }
        } else if (this.stateHandler.getKeyedStateBackend() != null) {
            throw new UnsupportedOperationException("Current State Backend doesn't support async access, AsyncExecutionController could not work");
        }
    }

    private void handleAsyncStateException(String message, Throwable exception) {
        this.environment.failExternally(new AsyncStateException(message, exception));
    }

    @Override
    public boolean isAsyncStateProcessingEnabled() {
        return true;
    }

    @Override
    public ElementOrder getElementOrder() {
        return ElementOrder.RECORD_ORDER;
    }

    @Override
    public final <T> void setAsyncKeyedContextElement(StreamRecord<T> record, KeySelector<T, ?> keySelector) throws Exception {
        this.currentProcessingContext = this.asyncExecutionController.buildContext(record.getValue(), keySelector.getKey(record.getValue()));
        this.currentProcessingContext.retain();
        this.asyncExecutionController.setCurrentContext(this.currentProcessingContext);
    }

    @Override
    public final void postProcessElement() {
        this.currentProcessingContext.release();
    }

    @Override
    public final void preserveRecordOrderAndProcess(ThrowingRunnable<Exception> processing) {
        this.asyncExecutionController.syncPointRequestWithCallback(processing);
    }

    @Override
    public <K> void asyncProcessWithKey(K key, ThrowingRunnable<Exception> processing) {
        RecordContext previousContext = this.currentProcessingContext;
        this.currentProcessingContext = this.asyncExecutionController.buildContext(null, key);
        this.currentProcessingContext.retain();
        this.asyncExecutionController.setCurrentContext(this.currentProcessingContext);
        this.preserveRecordOrderAndProcess(processing);
        this.postProcessElement();
        this.asyncExecutionController.setCurrentContext(previousContext);
        this.currentProcessingContext = previousContext;
    }

    @Override
    public final <T> ThrowingConsumer<StreamRecord<T>, Exception> getRecordProcessor(int inputId) {
        throw new UnsupportedOperationException("Never getRecordProcessor from AbstractAsyncStateStreamOperatorV2, since this part is handled by the Input.");
    }

    protected <N, S extends State, T> S getOrCreateKeyedState(@Nonnull N defaultNamespace, @Nonnull TypeSerializer<N> namespaceSerializer, @Nonnull StateDescriptor<T> stateDescriptor) throws Exception {
        return this.stateHandler.getOrCreateKeyedState(defaultNamespace, namespaceSerializer, stateDescriptor);
    }

    @Override
    public void prepareSnapshotPreBarrier(long checkpointId) throws Exception {
        if (this.isAsyncStateProcessingEnabled()) {
            this.asyncExecutionController.drainInflightRecords(0);
        }
    }

    @Override
    public OperatorSnapshotFutures snapshotState(long checkpointId, long timestamp, CheckpointOptions checkpointOptions, CheckpointStreamFactory factory) throws Exception {
        return this.stateHandler.snapshotState(this, Optional.ofNullable(this.timeServiceManager), this.getOperatorName(), checkpointId, timestamp, checkpointOptions, factory, this.isUsingCustomRawKeyedState(), true);
    }

    @Override
    public <K, N> InternalTimerService<N> getInternalTimerService(String name, TypeSerializer<N> namespaceSerializer, Triggerable<K, N> triggerable) {
        if (this.timeServiceManager == null) {
            throw new RuntimeException("The timer service has not been initialized.");
        }
        if (!this.isAsyncStateProcessingEnabled()) {
            return super.getInternalTimerService(name, namespaceSerializer, triggerable);
        }
        InternalTimeServiceManager keyedTimeServiceHandler = this.timeServiceManager;
        KeyedStateBackend keyedStateBackend = this.getKeyedStateBackend();
        Preconditions.checkState((keyedStateBackend != null ? 1 : 0) != 0, (Object)"Timers can only be used on keyed operators.");
        return keyedTimeServiceHandler.getAsyncInternalTimerService(name, keyedStateBackend.getKeySerializer(), namespaceSerializer, triggerable, this.asyncExecutionController);
    }

    @Override
    public void processWatermark(Watermark mark) throws Exception {
        if (!this.isAsyncStateProcessingEnabled()) {
            super.processWatermark(mark);
            return;
        }
        this.asyncExecutionController.processNonRecord((ThrowingRunnable<Exception>)((ThrowingRunnable)() -> super.processWatermark(mark)));
    }

    @Override
    public void processWatermarkStatus(WatermarkStatus watermarkStatus, int inputId) throws Exception {
        if (!this.isAsyncStateProcessingEnabled()) {
            super.processWatermarkStatus(watermarkStatus, inputId);
            return;
        }
        this.asyncExecutionController.processNonRecord((ThrowingRunnable<Exception>)((ThrowingRunnable)() -> {
            boolean wasIdle = this.combinedWatermark.isIdle();
            if (this.combinedWatermark.updateStatus(inputId - 1, watermarkStatus.isIdle())) {
                super.processWatermark(new Watermark(this.combinedWatermark.getCombinedWatermark()));
            }
            if (wasIdle != this.combinedWatermark.isIdle()) {
                this.output.emitWatermarkStatus(watermarkStatus);
            }
        }));
    }

    @VisibleForTesting
    public AsyncExecutionController<?> getAsyncExecutionController() {
        return this.asyncExecutionController;
    }

    @VisibleForTesting
    public RecordContext getCurrentProcessingContext() {
        return this.currentProcessingContext;
    }

    @Override
    public void finish() throws Exception {
        super.finish();
        this.asyncExecutionController.drainInflightRecords(0);
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.asyncExecutionController.close();
    }
}

