/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.memory;

import java.io.IOException;
import java.util.UUID;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.runtime.state.CheckpointMetadataOutputStream;
import org.apache.flink.runtime.state.CheckpointStorageLocation;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.apache.flink.runtime.state.memory.MemCheckpointStreamFactory;

public class NonPersistentMetadataCheckpointStorageLocation
extends MemCheckpointStreamFactory
implements CheckpointStorageLocation {
    public static final String EXTERNAL_POINTER = "<checkpoint-not-externally-addressable>";

    public NonPersistentMetadataCheckpointStorageLocation(int maxStateSize) {
        super(maxStateSize);
    }

    @Override
    public CheckpointMetadataOutputStream createMetadataOutputStream() throws IOException {
        return new MetadataOutputStream();
    }

    @Override
    public void disposeOnFailure() {
    }

    @Override
    public CheckpointStorageLocationReference getLocationReference() {
        return CheckpointStorageLocationReference.getDefault();
    }

    private static class MetadataOutputStream
    extends CheckpointMetadataOutputStream {
        private final ByteArrayOutputStreamWithPos os = new ByteArrayOutputStreamWithPos();
        private boolean closed;

        private MetadataOutputStream() {
        }

        public void write(int b) throws IOException {
            this.os.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.os.write(b, off, len);
        }

        public void flush() throws IOException {
            this.os.flush();
        }

        public long getPos() throws IOException {
            return this.os.getPosition();
        }

        public void sync() throws IOException {
        }

        @Override
        public CompletedCheckpointStorageLocation closeAndFinalizeCheckpoint() throws IOException {
            MetadataOutputStream metadataOutputStream = this;
            synchronized (metadataOutputStream) {
                if (!this.closed) {
                    this.closed = true;
                    byte[] bytes = this.os.toByteArray();
                    ByteStreamStateHandle handle = new ByteStreamStateHandle(UUID.randomUUID().toString(), bytes);
                    return new NonPersistentCompletedCheckpointStorageLocation(handle);
                }
                throw new IOException("Already closed");
            }
        }

        @Override
        public void close() {
            if (!this.closed) {
                this.closed = true;
                this.os.reset();
            }
        }
    }

    private static class NonPersistentCompletedCheckpointStorageLocation
    implements CompletedCheckpointStorageLocation {
        private static final long serialVersionUID = 1L;
        private final ByteStreamStateHandle metaDataHandle;

        NonPersistentCompletedCheckpointStorageLocation(ByteStreamStateHandle metaDataHandle) {
            this.metaDataHandle = metaDataHandle;
        }

        @Override
        public String getExternalPointer() {
            return NonPersistentMetadataCheckpointStorageLocation.EXTERNAL_POINTER;
        }

        @Override
        public StreamStateHandle getMetadataHandle() {
            return this.metaDataHandle;
        }

        @Override
        public void disposeStorageLocation() {
        }
    }
}

