/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.metrics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.job.AbstractJobVertexHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.JobVertexMessageParameters;
import org.apache.flink.runtime.rest.messages.job.metrics.JobVertexWatermarksHeaders;
import org.apache.flink.runtime.rest.messages.job.metrics.Metric;
import org.apache.flink.runtime.rest.messages.job.metrics.MetricCollectionResponseBody;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class JobVertexWatermarksHandler
extends AbstractJobVertexHandler<MetricCollectionResponseBody, JobVertexMessageParameters> {
    private final MetricFetcher metricFetcher;

    public JobVertexWatermarksHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MetricFetcher metricFetcher, ExecutionGraphCache executionGraphCache, Executor executor) {
        super(leaderRetriever, timeout, responseHeaders, JobVertexWatermarksHeaders.INSTANCE, executionGraphCache, executor);
        this.metricFetcher = metricFetcher;
    }

    @Override
    protected MetricCollectionResponseBody handleRequest(HandlerRequest<EmptyRequestBody> request, AccessExecutionJobVertex jobVertex) throws RestHandlerException {
        String jobID = ((JobID)request.getPathParameter(JobIDPathParameter.class)).toString();
        String taskID = jobVertex.getJobVertexId().toString();
        this.metricFetcher.update();
        MetricStore.TaskMetricStore taskMetricStore = this.metricFetcher.getMetricStore().getTaskMetricStore(jobID, taskID);
        if (taskMetricStore == null) {
            return new MetricCollectionResponseBody(Collections.emptyList());
        }
        AccessExecutionVertex[] taskVertices = jobVertex.getTaskVertices();
        ArrayList<Metric> metrics = new ArrayList<Metric>(taskVertices.length);
        for (AccessExecutionVertex taskVertex : taskVertices) {
            String id = taskVertex.getParallelSubtaskIndex() + "." + "currentInputWatermark";
            String watermarkValue = taskMetricStore.getMetric(id);
            if (watermarkValue == null) continue;
            metrics.add(new Metric(id, watermarkValue));
        }
        return new MetricCollectionResponseBody(metrics);
    }
}

