/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.types.Either;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface BlobWriter {
    public static final Logger LOG = LoggerFactory.getLogger(BlobWriter.class);

    public PermanentBlobKey putPermanent(JobID var1, byte[] var2) throws IOException;

    public PermanentBlobKey putPermanent(JobID var1, InputStream var2) throws IOException;

    public boolean deletePermanent(JobID var1, PermanentBlobKey var2);

    public int getMinOffloadingSize();

    public static <T> Either<SerializedValue<T>, PermanentBlobKey> serializeAndTryOffload(T value, JobID jobId, BlobWriter blobWriter) throws IOException {
        Preconditions.checkNotNull(value);
        SerializedValue serializedValue = new SerializedValue(value);
        return BlobWriter.tryOffload(serializedValue, jobId, blobWriter);
    }

    public static <T> Either<SerializedValue<T>, PermanentBlobKey> tryOffload(SerializedValue<T> serializedValue, JobID jobId, BlobWriter blobWriter) {
        Preconditions.checkNotNull(serializedValue);
        Preconditions.checkNotNull((Object)jobId);
        Preconditions.checkNotNull((Object)blobWriter);
        if (serializedValue.getByteArray().length < blobWriter.getMinOffloadingSize()) {
            return Either.Left(serializedValue);
        }
        return BlobWriter.offloadWithException(serializedValue, jobId, blobWriter);
    }

    public static <T> Either<SerializedValue<T>, PermanentBlobKey> offloadWithException(SerializedValue<T> serializedValue, JobID jobId, BlobWriter blobWriter) {
        Preconditions.checkNotNull(serializedValue);
        Preconditions.checkNotNull((Object)jobId);
        Preconditions.checkNotNull((Object)blobWriter);
        try {
            PermanentBlobKey permanentBlobKey = blobWriter.putPermanent(jobId, serializedValue.getByteArray());
            return Either.Right((Object)permanentBlobKey);
        }
        catch (IOException e) {
            LOG.warn("Failed to offload value for job {} to BLOB store.", (Object)jobId, (Object)e);
            return Either.Left(serializedValue);
        }
    }
}

