/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util.bash;

import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.util.bash.BashJavaUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class BashJavaUtilsTest {
    BashJavaUtilsTest() {
    }

    @Test
    void testJmLegacyHeapOptionSetsNewJvmHeap() {
        Configuration configuration = new Configuration();
        MemorySize heapSize = MemorySize.ofMebiBytes((long)10L);
        configuration.set(JobManagerOptions.JOB_MANAGER_HEAP_MEMORY, (Object)heapSize);
        String jvmArgsLine = (String)BashJavaUtils.getJmResourceParams((Configuration)configuration).get(0);
        Map jvmArgs = ConfigurationUtils.parseJvmArgString((String)jvmArgsLine);
        String heapSizeStr = Long.toString(heapSize.getBytes());
        Assertions.assertThat((String)((String)jvmArgs.get("-Xmx"))).isEqualTo(heapSizeStr);
        Assertions.assertThat((String)((String)jvmArgs.get("-Xms"))).isEqualTo(heapSizeStr);
    }
}

