/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import java.util.Random;
import java.util.UUID;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.core.fs.EntropyInjector;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.OutputStreamAndPath;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.filesystem.FsSegmentDataInputStream;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FsSegmentDataInputStreamTest {
    @Rule
    public final TemporaryFolder tmp = new TemporaryFolder();
    private static final CloseableRegistry closeableRegistry = new CloseableRegistry();
    private static final Random random = new Random();

    @Test
    public void testReadFromFileSegments() throws IOException {
        Path dirPath = new Path(this.tmp.getRoot().getPath());
        Path filePath = new Path(dirPath, UUID.randomUUID().toString());
        byte[] fileContent = this.prepareFileToRead(filePath, 512);
        int startPos = 0;
        int segmentSize = 512;
        FsSegmentDataInputStream inputStream = this.openSegment(filePath, startPos, segmentSize);
        closeableRegistry.registerCloseable((AutoCloseable)inputStream);
        byte[] readResult = new byte[segmentSize];
        int readLen = inputStream.read(readResult);
        Assertions.assertThat((int)readLen).isEqualTo(segmentSize);
        this.assertBytesContentEqual(fileContent, startPos, segmentSize, readResult);
        Assertions.assertThat((int)inputStream.read()).isEqualTo(-1);
        startPos = 26;
        segmentSize = 483;
        inputStream = this.openSegment(filePath, startPos, segmentSize);
        readResult = new byte[segmentSize];
        readLen = inputStream.read(readResult);
        Assertions.assertThat((int)readLen).isEqualTo(segmentSize);
        this.assertBytesContentEqual(fileContent, startPos, segmentSize, readResult);
        Assertions.assertThat((int)inputStream.read()).isEqualTo(-1);
        startPos = 56;
        segmentSize = 123;
        inputStream = this.openSegment(filePath, startPos, segmentSize);
        int readBufferSize = 32;
        readResult = new byte[readBufferSize];
        int seekPos = 74;
        inputStream.seek((long)seekPos);
        Assertions.assertThat((long)inputStream.getPos()).isEqualTo((long)seekPos);
        readLen = inputStream.read(readResult);
        Assertions.assertThat((int)readLen).isEqualTo(readBufferSize);
        this.assertBytesContentEqual(fileContent, startPos + seekPos, readLen, readResult);
        Assertions.assertThat((long)inputStream.getPos()).isEqualTo((long)(seekPos + readBufferSize));
        Assertions.assertThat((int)inputStream.read(readResult)).isEqualTo(segmentSize - seekPos - readBufferSize);
        Assertions.assertThat((int)inputStream.read()).isEqualTo(-1);
        Assertions.assertThat((int)inputStream.read(new byte[10])).isEqualTo(-1);
        Assertions.assertThat((int)inputStream.read(new byte[10], 0, 1)).isEqualTo(-1);
    }

    private byte[] prepareFileToRead(Path filePath, int fileSize) throws IOException {
        OutputStreamAndPath streamAndPath = EntropyInjector.createEntropyAware((FileSystem)filePath.getFileSystem(), (Path)filePath, (FileSystem.WriteMode)FileSystem.WriteMode.NO_OVERWRITE);
        FSDataOutputStream outputStream = streamAndPath.stream();
        byte[] fileContent = this.randomBytes(fileSize);
        outputStream.write(fileContent);
        outputStream.close();
        return fileContent;
    }

    private FsSegmentDataInputStream openSegment(Path filePath, long startPosition, long segmentSize) throws IOException {
        FSDataInputStream inputStream = filePath.getFileSystem().open(filePath);
        return new FsSegmentDataInputStream(inputStream, startPosition, segmentSize);
    }

    private byte[] randomBytes(int len) {
        byte[] bytes = new byte[len];
        random.nextBytes(bytes);
        return bytes;
    }

    private void assertBytesContentEqual(byte[] expected, int startPosInExpected, int sizeInExpected, byte[] actual) {
        Assertions.assertThat((int)actual.length).isEqualTo(sizeInExpected);
        byte[] expectedSegment = new byte[sizeInExpected];
        System.arraycopy(expected, startPosInExpected, expectedSegment, 0, sizeInExpected);
        Assertions.assertThat((byte[])actual).isEqualTo((Object)expectedSegment);
    }
}

