/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.metrics;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.metrics.dump.MetricDump;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.job.metrics.AbstractMetricsHandler;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.job.metrics.Metric;
import org.apache.flink.runtime.rest.messages.job.metrics.MetricCollectionResponseBody;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.TestingDispatcherGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

abstract class MetricsHandlerTestBase<T extends AbstractMetricsHandler> {
    private static final String TEST_METRIC_NAME = "test_counter";
    private static final int TEST_METRIC_VALUE = 1000;
    static final Time TIMEOUT = Time.milliseconds((long)50L);
    static final Map<String, String> TEST_HEADERS = Collections.emptyMap();
    MetricFetcher mockMetricFetcher;
    GatewayRetriever<DispatcherGateway> leaderRetriever;
    private final DispatcherGateway mockDispatcherGateway = new TestingDispatcherGateway();
    private T metricsHandler;
    private Map<String, String> pathParameters;

    MetricsHandlerTestBase() {
    }

    @BeforeEach
    void setUp() {
        final MetricStore metricStore = new MetricStore();
        metricStore.add((MetricDump)new MetricDump.CounterDump(this.getQueryScopeInfo(), TEST_METRIC_NAME, 1000L));
        this.mockMetricFetcher = new MetricFetcher(){

            public MetricStore getMetricStore() {
                return metricStore;
            }

            public void update() {
            }

            public long getLastUpdateTime() {
                return 0L;
            }
        };
        this.leaderRetriever = () -> CompletableFuture.completedFuture(this.mockDispatcherGateway);
        this.pathParameters = this.getPathParameters();
        this.metricsHandler = this.getMetricsHandler();
    }

    @Test
    void testGetMetric() throws Exception {
        CompletableFuture completableFuture = this.metricsHandler.handleRequest(HandlerRequest.resolveParametersAndCreate((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)this.metricsHandler.getMessageHeaders().getUnresolvedMessageParameters(), this.pathParameters, Collections.emptyMap(), Collections.emptyList()), (RestfulGateway)this.mockDispatcherGateway);
        Assertions.assertThat((CompletableFuture)completableFuture).isDone();
        MetricCollectionResponseBody metricCollectionResponseBody = (MetricCollectionResponseBody)completableFuture.get();
        Assertions.assertThat((Collection)metricCollectionResponseBody.getMetrics()).hasSize(1);
        Metric metric = (Metric)metricCollectionResponseBody.getMetrics().iterator().next();
        Assertions.assertThat((String)metric.getId()).isEqualTo(this.getExpectedIdForMetricName(TEST_METRIC_NAME));
    }

    abstract T getMetricsHandler();

    abstract QueryScopeInfo getQueryScopeInfo();

    abstract Map<String, String> getPathParameters();

    String getExpectedIdForMetricName(String metricName) {
        return metricName;
    }
}

