/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.Collections;
import java.util.HashMap;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ArchivedExecution;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionVertex;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.ExecutionHistory;
import org.apache.flink.runtime.executiongraph.IOMetrics;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerConfiguration;
import org.apache.flink.runtime.rest.handler.job.SubtaskExecutionAttemptDetailsHandler;
import org.apache.flink.runtime.rest.handler.legacy.DefaultExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcherImpl;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.job.SubtaskAttemptMessageParameters;
import org.apache.flink.runtime.rest.messages.job.SubtaskExecutionAttemptDetailsHeaders;
import org.apache.flink.runtime.rest.messages.job.SubtaskExecutionAttemptDetailsInfo;
import org.apache.flink.runtime.rest.messages.job.metrics.IOMetricsInfo;
import org.apache.flink.util.concurrent.Executors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SubtaskExecutionAttemptDetailsHandlerTest {
    SubtaskExecutionAttemptDetailsHandlerTest() {
    }

    @Test
    void testHandleRequest() throws Exception {
        JobID jobID = new JobID();
        JobVertexID jobVertexId = new JobVertexID();
        boolean subtaskIndex = true;
        ExecutionState expectedState = ExecutionState.FINISHED;
        boolean attempt = false;
        StringifiedAccumulatorResult[] emptyAccumulators = new StringifiedAccumulatorResult[]{};
        long bytesIn = 1L;
        long bytesOut = 10L;
        long recordsIn = 20L;
        long recordsOut = 30L;
        long accumulateIdleTime = 40L;
        long accumulateBusyTime = 50L;
        long accumulateBackPressuredTime = 60L;
        IOMetrics ioMetrics = new IOMetrics(1L, 10L, 20L, 30L, 40L, 50.0, 60L);
        ArchivedExecutionJobVertex archivedExecutionJobVertex = new ArchivedExecutionJobVertex(new ArchivedExecutionVertex[]{null, new ArchivedExecutionVertex(1, "test task", new ArchivedExecution(emptyAccumulators, ioMetrics, ExecutionGraphTestUtils.createExecutionAttemptId(jobVertexId, 1, 0), expectedState, null, null, null, new long[ExecutionState.values().length], new long[ExecutionState.values().length]), new ExecutionHistory(0))}, jobVertexId, "test", 1, 1, new SlotSharingGroup(), ResourceProfile.UNKNOWN, emptyAccumulators);
        MetricFetcherImpl metricFetcher = new MetricFetcherImpl(() -> null, address -> null, Executors.directExecutor(), Time.milliseconds((long)1000L), ((Long)MetricOptions.METRIC_FETCHER_UPDATE_INTERVAL.defaultValue()).longValue());
        RestHandlerConfiguration restHandlerConfiguration = RestHandlerConfiguration.fromConfiguration((Configuration)new Configuration());
        SubtaskExecutionAttemptDetailsHandler handler = new SubtaskExecutionAttemptDetailsHandler(() -> null, Time.milliseconds((long)100L), Collections.emptyMap(), (MessageHeaders)SubtaskExecutionAttemptDetailsHeaders.getInstance(), (ExecutionGraphCache)new DefaultExecutionGraphCache(restHandlerConfiguration.getTimeout(), Time.milliseconds((long)restHandlerConfiguration.getRefreshInterval())), Executors.directExecutor(), (MetricFetcher)metricFetcher);
        HashMap<String, String> receivedPathParameters = new HashMap<String, String>(4);
        receivedPathParameters.put("jobid", jobID.toString());
        receivedPathParameters.put("vertexid", jobVertexId.toString());
        receivedPathParameters.put("subtaskindex", Integer.toString(1));
        receivedPathParameters.put("attempt", Integer.toString(0));
        HandlerRequest request = HandlerRequest.resolveParametersAndCreate((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new SubtaskAttemptMessageParameters(), receivedPathParameters, Collections.emptyMap(), Collections.emptyList());
        SubtaskExecutionAttemptDetailsInfo detailsInfo = (SubtaskExecutionAttemptDetailsInfo)handler.handleRequest(request, (AccessExecutionJobVertex)archivedExecutionJobVertex);
        IOMetricsInfo ioMetricsInfo = new IOMetricsInfo(1L, true, 10L, true, 20L, true, 30L, true, 60L, 40L, 50.0);
        HashMap<ExecutionState, Long> statusDuration = new HashMap<ExecutionState, Long>();
        statusDuration.put(ExecutionState.CREATED, -1L);
        statusDuration.put(ExecutionState.SCHEDULED, -1L);
        statusDuration.put(ExecutionState.DEPLOYING, -1L);
        statusDuration.put(ExecutionState.INITIALIZING, -1L);
        statusDuration.put(ExecutionState.RUNNING, -1L);
        SubtaskExecutionAttemptDetailsInfo expectedDetailsInfo = new SubtaskExecutionAttemptDetailsInfo(1, expectedState, 0, "(unassigned)", "(unassigned)", -1L, 0L, -1L, ioMetricsInfo, "(unassigned)", statusDuration, null);
        Assertions.assertThat((Object)detailsInfo).isEqualTo((Object)expectedDetailsInfo);
    }
}

