/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.MetricRegistryTestUtils;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.TaskManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.util.DummyCharacterFilter;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TaskManagerJobGroupTest {
    private MetricRegistryImpl registry;

    TaskManagerJobGroupTest() {
    }

    @BeforeEach
    void setup() {
        this.registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration());
    }

    @AfterEach
    void teardown() throws Exception {
        if (this.registry != null) {
            this.registry.closeAsync().get();
        }
    }

    @Test
    void testGenerateScopeDefault() {
        TaskManagerMetricGroup tmGroup = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)this.registry, (String)"theHostName", (ResourceID)new ResourceID("test-tm-id"));
        TaskManagerJobMetricGroup jmGroup = new TaskManagerJobMetricGroup((MetricRegistry)this.registry, tmGroup, new JobID(), "myJobName");
        Assertions.assertThat((Object[])jmGroup.getScopeComponents()).containsExactly((Object[])new String[]{"theHostName", "taskmanager", "test-tm-id", "myJobName"});
        Assertions.assertThat((String)jmGroup.getMetricIdentifier("name")).isEqualTo("theHostName.taskmanager.test-tm-id.myJobName.name");
    }

    @Test
    void testGenerateScopeCustom() throws Exception {
        Configuration cfg = new Configuration();
        cfg.set(MetricOptions.SCOPE_NAMING_TM, (Object)"abc");
        cfg.set(MetricOptions.SCOPE_NAMING_TM_JOB, (Object)"some-constant.<job_name>");
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.fromConfiguration(cfg));
        JobID jid = new JobID();
        TaskManagerMetricGroup tmGroup = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)registry, (String)"theHostName", (ResourceID)new ResourceID("test-tm-id"));
        TaskManagerJobMetricGroup jmGroup = new TaskManagerJobMetricGroup((MetricRegistry)registry, tmGroup, jid, "myJobName");
        Assertions.assertThat((Object[])jmGroup.getScopeComponents()).containsExactly((Object[])new String[]{"some-constant", "myJobName"});
        Assertions.assertThat((String)jmGroup.getMetricIdentifier("name")).isEqualTo("some-constant.myJobName.name");
        registry.closeAsync().get();
    }

    @Test
    void testGenerateScopeCustomWildcard() throws Exception {
        Configuration cfg = new Configuration();
        cfg.set(MetricOptions.SCOPE_NAMING_TM, (Object)"peter.<tm_id>");
        cfg.set(MetricOptions.SCOPE_NAMING_TM_JOB, (Object)"*.some-constant.<job_id>");
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.fromConfiguration(cfg));
        JobID jid = new JobID();
        TaskManagerMetricGroup tmGroup = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)registry, (String)"theHostName", (ResourceID)new ResourceID("test-tm-id"));
        TaskManagerJobMetricGroup jmGroup = new TaskManagerJobMetricGroup((MetricRegistry)registry, tmGroup, jid, "myJobName");
        Assertions.assertThat((Object[])jmGroup.getScopeComponents()).containsExactly((Object[])new String[]{"peter", "test-tm-id", "some-constant", jid.toString()});
        Assertions.assertThat((String)jmGroup.getMetricIdentifier("name")).isEqualTo("peter.test-tm-id.some-constant." + jid + ".name");
        registry.closeAsync().get();
    }

    @Test
    void testCreateQueryServiceMetricInfo() {
        JobID jid = new JobID();
        TaskManagerMetricGroup tm = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)this.registry, (String)"host", (ResourceID)new ResourceID("id"));
        TaskManagerJobMetricGroup job = new TaskManagerJobMetricGroup((MetricRegistry)this.registry, tm, jid, "jobname");
        QueryScopeInfo.JobQueryScopeInfo info = job.createQueryServiceMetricInfo((CharacterFilter)new DummyCharacterFilter());
        Assertions.assertThat((String)info.scope).isEmpty();
        Assertions.assertThat((String)info.jobID).isEqualTo(jid.toString());
    }
}

