/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.groups.InternalOperatorCoordinatorMetricGroup;
import org.apache.flink.runtime.metrics.groups.JobManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.JobManagerOperatorMetricGroup;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.runtime.metrics.util.TestingMetricRegistry;
import org.apache.flink.util.AbstractID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class InternalOperatorCoordinatorGroupTest {
    private static final MetricRegistry registry = TestingMetricRegistry.builder().build();

    InternalOperatorCoordinatorGroupTest() {
    }

    @Test
    void testGenerateScopeDefault() {
        JobID jobId = new JobID();
        JobVertexID jobVertexId = new JobVertexID();
        OperatorID operatorId = new OperatorID();
        JobManagerOperatorMetricGroup jmJobGroup = JobManagerMetricGroup.createJobManagerMetricGroup((MetricRegistry)registry, (String)"localhost").addJob(jobId, "myJobName").getOrAddOperator((AbstractID)jobVertexId, "taskName", operatorId, "opName");
        InternalOperatorCoordinatorMetricGroup operatorCoordinatorMetricGroup = new InternalOperatorCoordinatorMetricGroup((MetricGroup)jmJobGroup);
        Assertions.assertThat((Object[])operatorCoordinatorMetricGroup.getScopeComponents()).containsExactly((Object[])new String[]{"localhost", "jobmanager", "myJobName", "opName", "coordinator"});
        Assertions.assertThat((String)operatorCoordinatorMetricGroup.getMetricIdentifier("name")).isEqualTo("localhost.jobmanager.myJobName.opName.coordinator.name");
    }

    @Test
    void testVariables() {
        JobID jobId = new JobID();
        JobVertexID jobVertexId = new JobVertexID();
        OperatorID operatorId = new OperatorID();
        JobManagerOperatorMetricGroup jmJobGroup = JobManagerMetricGroup.createJobManagerMetricGroup((MetricRegistry)registry, (String)"host").addJob(jobId, "myJobName").getOrAddOperator((AbstractID)jobVertexId, "taskName", operatorId, "opName");
        InternalOperatorCoordinatorMetricGroup operatorCoordinatorMetricGroup = new InternalOperatorCoordinatorMetricGroup((MetricGroup)jmJobGroup);
        Map variables = operatorCoordinatorMetricGroup.getAllVariables();
        InternalOperatorCoordinatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_HOST, "host");
        InternalOperatorCoordinatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_JOB_ID, jobId.toString());
        InternalOperatorCoordinatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_JOB_NAME, "myJobName");
        InternalOperatorCoordinatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_TASK_VERTEX_ID, jobVertexId.toString());
        InternalOperatorCoordinatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_TASK_NAME, "taskName");
        InternalOperatorCoordinatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_OPERATOR_ID, operatorId.toString());
        InternalOperatorCoordinatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_OPERATOR_NAME, "opName");
    }

    private static void testVariable(Map<String, String> variables, String key, String expectedValue) {
        String actualValue = variables.get(key);
        Assertions.assertThat((String)actualValue).isNotNull();
        Assertions.assertThat((String)actualValue).isEqualTo(expectedValue);
    }
}

