/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.UnpooledBufferPool;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionBuilder;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.util.function.SupplierWithException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PipelinedResultPartitionReleaseOnConsumptionTest {
    PipelinedResultPartitionReleaseOnConsumptionTest() {
    }

    @Test
    void testConsumptionBasedPartitionRelease() throws IOException {
        ResultPartitionManager manager = new ResultPartitionManager();
        ResultPartition partition = new ResultPartitionBuilder().setResultPartitionType(ResultPartitionType.PIPELINED).setNumberOfSubpartitions(2).setResultPartitionManager(manager).build();
        manager.registerResultPartition(partition);
        partition.onConsumedSubpartition(0);
        Assertions.assertThat((boolean)partition.isReleased()).isFalse();
        partition.onConsumedSubpartition(1);
        partition.close();
        Assertions.assertThat((boolean)partition.isReleased()).isTrue();
    }

    @Test
    void testConsumptionBeforePartitionClose() throws IOException {
        ResultPartition partition = new ResultPartitionBuilder().setResultPartitionType(ResultPartitionType.PIPELINED).setNumberOfSubpartitions(1).setBufferPoolFactory((SupplierWithException<BufferPool, IOException>)((SupplierWithException)UnpooledBufferPool::new)).build();
        partition.setup();
        partition.emitRecord(ByteBuffer.allocate(16), 0);
        partition.onConsumedSubpartition(0);
        Assertions.assertThat((boolean)partition.isReleased()).isFalse();
        partition.emitRecord(ByteBuffer.allocate(16), 0);
        partition.close();
        Assertions.assertThat((boolean)partition.isReleased()).isTrue();
    }

    @Test
    void testMultipleReleaseCallsAreIdempotent() throws IOException {
        ResultPartitionManager manager = new ResultPartitionManager();
        ResultPartition partition = new ResultPartitionBuilder().setResultPartitionType(ResultPartitionType.PIPELINED).setNumberOfSubpartitions(2).setResultPartitionManager(manager).build();
        manager.registerResultPartition(partition);
        partition.onConsumedSubpartition(0);
        partition.onConsumedSubpartition(0);
        Assertions.assertThat((boolean)partition.isReleased()).isFalse();
    }

    @Test
    void testReleaseAfterIdempotentCalls() throws IOException {
        ResultPartitionManager manager = new ResultPartitionManager();
        ResultPartition partition = new ResultPartitionBuilder().setResultPartitionType(ResultPartitionType.PIPELINED).setNumberOfSubpartitions(2).setResultPartitionManager(manager).build();
        manager.registerResultPartition(partition);
        partition.onConsumedSubpartition(0);
        partition.onConsumedSubpartition(0);
        partition.onConsumedSubpartition(1);
        partition.close();
        Assertions.assertThat((boolean)partition.isReleased()).isTrue();
    }
}

