/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.AvailabilityProvider;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferListener;
import org.apache.flink.runtime.io.network.buffer.BufferPool;

public class TestingBufferPool
implements BufferPool {
    public static final TestingBufferPool NO_OP = TestingBufferPool.builder().build();
    private Consumer<Integer> reserveSegmentsConsumer;
    private Runnable lazyDestroyRunnable;
    private Supplier<Buffer> requestBufferSupplier;
    private Supplier<BufferBuilder> requestBufferBuilderSupplier;
    private Supplier<BufferBuilder> requestBufferBuilderBlockingSupplier;
    private Function<Integer, BufferBuilder> requestBufferBuilderFunction;
    private Function<Integer, BufferBuilder> requestBufferBuilderBlockingFunction;
    private Function<BufferListener, Boolean> addBufferListenerFunction;
    private Supplier<Boolean> isDestroyedSupplier;
    private Supplier<MemorySegment> requestMemorySegmentSupplier;
    private Supplier<MemorySegment> requestMemorySegmentBlockingSupplier;
    private Supplier<Integer> getExpectedNumberOfMemorySegmentsSupplier;
    private Supplier<Integer> getMinNumberOfMemorySegmentsSupplier;
    private Supplier<Integer> getMaxNumberOfMemorySegmentsSupplier;
    private Supplier<Integer> getNumBuffersSupplier;
    private Consumer<Integer> setNumBuffersConsumer;
    private Consumer<Integer> setMaxOverdraftBuffersPerGateConsumer;
    private Supplier<Integer> getMaxOverdraftBuffersPerGateSupplier;
    private Supplier<Integer> getNumberOfAvailableMemorySegmentsSupplier;
    private Supplier<Integer> bestEffortGetNumOfUsedBuffersSupplier;
    private Consumer<MemorySegment> recycleConsumer;
    private Supplier<CompletableFuture<?>> getAvailableFutureSupplier;

    private TestingBufferPool(Consumer<Integer> reserveSegmentsConsumer, Runnable lazyDestroyRunnable, Supplier<Buffer> requestBufferSupplier, Supplier<BufferBuilder> requestBufferBuilderSupplier, Supplier<BufferBuilder> requestBufferBuilderBlockingSupplier, Function<Integer, BufferBuilder> requestBufferBuilderFunction, Function<Integer, BufferBuilder> requestBufferBuilderBlockingFunction, Function<BufferListener, Boolean> addBufferListenerFunction, Supplier<Boolean> isDestroyedSupplier, Supplier<MemorySegment> requestMemorySegmentSupplier, Supplier<MemorySegment> requestMemorySegmentBlockingSupplier, Supplier<Integer> getExpectedNumberOfMemorySegmentsSupplier, Supplier<Integer> getMinNumberOfMemorySegmentsSupplier, Supplier<Integer> getMaxNumberOfMemorySegmentsSupplier, Supplier<Integer> getNumBuffersSupplier, Consumer<Integer> setNumBuffersConsumer, Consumer<Integer> setMaxOverdraftBuffersPerGateConsumer, Supplier<Integer> getMaxOverdraftBuffersPerGateSupplier, Supplier<Integer> getNumberOfAvailableMemorySegmentsSupplier, Supplier<Integer> bestEffortGetNumOfUsedBuffersSupplier, Consumer<MemorySegment> recycleConsumer, Supplier<CompletableFuture<?>> getAvailableFutureSupplier) {
        this.reserveSegmentsConsumer = reserveSegmentsConsumer;
        this.lazyDestroyRunnable = lazyDestroyRunnable;
        this.requestBufferSupplier = requestBufferSupplier;
        this.requestBufferBuilderSupplier = requestBufferBuilderSupplier;
        this.requestBufferBuilderBlockingSupplier = requestBufferBuilderBlockingSupplier;
        this.requestBufferBuilderFunction = requestBufferBuilderFunction;
        this.requestBufferBuilderBlockingFunction = requestBufferBuilderBlockingFunction;
        this.addBufferListenerFunction = addBufferListenerFunction;
        this.isDestroyedSupplier = isDestroyedSupplier;
        this.requestMemorySegmentSupplier = requestMemorySegmentSupplier;
        this.requestMemorySegmentBlockingSupplier = requestMemorySegmentBlockingSupplier;
        this.getExpectedNumberOfMemorySegmentsSupplier = getExpectedNumberOfMemorySegmentsSupplier;
        this.getMinNumberOfMemorySegmentsSupplier = getMinNumberOfMemorySegmentsSupplier;
        this.getMaxNumberOfMemorySegmentsSupplier = getMaxNumberOfMemorySegmentsSupplier;
        this.getNumBuffersSupplier = getNumBuffersSupplier;
        this.setNumBuffersConsumer = setNumBuffersConsumer;
        this.setMaxOverdraftBuffersPerGateConsumer = setMaxOverdraftBuffersPerGateConsumer;
        this.getMaxOverdraftBuffersPerGateSupplier = getMaxOverdraftBuffersPerGateSupplier;
        this.getNumberOfAvailableMemorySegmentsSupplier = getNumberOfAvailableMemorySegmentsSupplier;
        this.bestEffortGetNumOfUsedBuffersSupplier = bestEffortGetNumOfUsedBuffersSupplier;
        this.recycleConsumer = recycleConsumer;
        this.getAvailableFutureSupplier = getAvailableFutureSupplier;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void reserveSegments(int numberOfSegmentsToReserve) throws IOException {
        this.reserveSegmentsConsumer.accept(numberOfSegmentsToReserve);
    }

    public void lazyDestroy() {
        this.lazyDestroyRunnable.run();
    }

    @Nullable
    public Buffer requestBuffer() {
        return this.requestBufferSupplier.get();
    }

    @Nullable
    public BufferBuilder requestBufferBuilder() {
        return this.requestBufferBuilderSupplier.get();
    }

    @Nullable
    public BufferBuilder requestBufferBuilder(int targetChannel) {
        return this.requestBufferBuilderFunction.apply(targetChannel);
    }

    public BufferBuilder requestBufferBuilderBlocking() throws InterruptedException {
        return this.requestBufferBuilderBlockingSupplier.get();
    }

    public BufferBuilder requestBufferBuilderBlocking(int targetChannel) throws InterruptedException {
        return this.requestBufferBuilderBlockingFunction.apply(targetChannel);
    }

    public boolean addBufferListener(BufferListener listener) {
        return this.addBufferListenerFunction.apply(listener);
    }

    public boolean isDestroyed() {
        return this.isDestroyedSupplier.get();
    }

    @Nullable
    public MemorySegment requestMemorySegment() {
        return this.requestMemorySegmentSupplier.get();
    }

    public MemorySegment requestMemorySegmentBlocking() throws InterruptedException {
        return this.requestMemorySegmentBlockingSupplier.get();
    }

    public int getExpectedNumberOfMemorySegments() {
        return this.getExpectedNumberOfMemorySegmentsSupplier.get();
    }

    public int getMinNumberOfMemorySegments() {
        return this.getMinNumberOfMemorySegmentsSupplier.get();
    }

    public int getMaxNumberOfMemorySegments() {
        return this.getMaxNumberOfMemorySegmentsSupplier.get();
    }

    public int getNumBuffers() {
        return this.getNumBuffersSupplier.get();
    }

    public void setNumBuffers(int numBuffers) {
        this.setNumBuffersConsumer.accept(numBuffers);
    }

    public void setMaxOverdraftBuffersPerGate(int maxOverdraftBuffersPerGate) {
        this.setMaxOverdraftBuffersPerGateConsumer.accept(maxOverdraftBuffersPerGate);
    }

    public int getMaxOverdraftBuffersPerGate() {
        return this.getMaxOverdraftBuffersPerGateSupplier.get();
    }

    public int getNumberOfAvailableMemorySegments() {
        return this.getNumberOfAvailableMemorySegmentsSupplier.get();
    }

    public int bestEffortGetNumOfUsedBuffers() {
        return this.bestEffortGetNumOfUsedBuffersSupplier.get();
    }

    public void recycle(MemorySegment memorySegment) {
        this.recycleConsumer.accept(memorySegment);
    }

    public CompletableFuture<?> getAvailableFuture() {
        return this.getAvailableFutureSupplier.get();
    }

    public static class Builder {
        private Consumer<Integer> reserveSegmentsConsumer = ignore -> {};
        private Runnable lazyDestroyRunnable = () -> {};
        private Supplier<Buffer> requestBufferSupplier = () -> {
            throw new UnsupportedOperationException();
        };
        private Supplier<BufferBuilder> requestBufferBuilderSupplier = () -> {
            throw new UnsupportedOperationException();
        };
        private Supplier<BufferBuilder> requestBufferBuilderBlockingSupplier = () -> {
            throw new UnsupportedOperationException();
        };
        private Function<Integer, BufferBuilder> requestBufferBuilderFunction = ignore -> {
            throw new UnsupportedOperationException();
        };
        private Function<Integer, BufferBuilder> requestBufferBuilderBlockingFunction = ignore -> {
            throw new UnsupportedOperationException();
        };
        private Function<BufferListener, Boolean> addBufferListenerFunction = ignore -> {
            throw new UnsupportedOperationException();
        };
        private Supplier<Boolean> isDestroyedSupplier = () -> {
            throw new UnsupportedOperationException();
        };
        private Supplier<MemorySegment> requestMemorySegmentSupplier = () -> {
            throw new UnsupportedOperationException();
        };
        private Supplier<MemorySegment> requestMemorySegmentBlockingSupplier = () -> {
            throw new UnsupportedOperationException();
        };
        private Supplier<Integer> getExpectedNumberOfMemorySegmentsSupplier = () -> {
            throw new UnsupportedOperationException();
        };
        private Supplier<Integer> getMinNumberOfMemorySegmentsSupplier = () -> {
            throw new UnsupportedOperationException();
        };
        private Supplier<Integer> getMaxNumberOfMemorySegmentsSupplier = () -> {
            throw new UnsupportedOperationException();
        };
        private Supplier<Integer> getNumBuffersSupplier = () -> 0;
        private Consumer<Integer> setNumBuffersConsumer = ignore -> {
            throw new UnsupportedOperationException();
        };
        private Consumer<Integer> setMaxOverdraftBuffersPerGateConsumer = ignore -> {
            throw new UnsupportedOperationException();
        };
        private Supplier<Integer> getMaxOverdraftBuffersPerGateSupplier = () -> {
            throw new UnsupportedOperationException();
        };
        private Supplier<Integer> getNumberOfAvailableMemorySegmentsSupplier = () -> {
            throw new UnsupportedOperationException();
        };
        private Supplier<Integer> bestEffortGetNumOfUsedBuffersSupplier = () -> {
            throw new UnsupportedOperationException();
        };
        private Consumer<MemorySegment> recycleConsumer = ignore -> {
            throw new UnsupportedOperationException();
        };
        private Supplier<CompletableFuture<?>> getAvailableFutureSupplier = () -> AvailabilityProvider.AVAILABLE;

        private Builder() {
        }

        public TestingBufferPool build() {
            return new TestingBufferPool(this.reserveSegmentsConsumer, this.lazyDestroyRunnable, this.requestBufferSupplier, this.requestBufferBuilderSupplier, this.requestBufferBuilderBlockingSupplier, this.requestBufferBuilderFunction, this.requestBufferBuilderBlockingFunction, this.addBufferListenerFunction, this.isDestroyedSupplier, this.requestMemorySegmentSupplier, this.requestMemorySegmentBlockingSupplier, this.getExpectedNumberOfMemorySegmentsSupplier, this.getMinNumberOfMemorySegmentsSupplier, this.getMaxNumberOfMemorySegmentsSupplier, this.getNumBuffersSupplier, this.setNumBuffersConsumer, this.setMaxOverdraftBuffersPerGateConsumer, this.getMaxOverdraftBuffersPerGateSupplier, this.getNumberOfAvailableMemorySegmentsSupplier, this.bestEffortGetNumOfUsedBuffersSupplier, this.recycleConsumer, this.getAvailableFutureSupplier);
        }

        public Builder setReserveSegmentsConsumer(Consumer<Integer> reserveSegmentsConsumer) {
            this.reserveSegmentsConsumer = reserveSegmentsConsumer;
            return this;
        }

        public Builder setLazyDestroyRunnable(Runnable lazyDestroyRunnable) {
            this.lazyDestroyRunnable = lazyDestroyRunnable;
            return this;
        }

        public Builder setRequestBufferSupplier(Supplier<Buffer> requestBufferSupplier) {
            this.requestBufferSupplier = requestBufferSupplier;
            return this;
        }

        public Builder setRequestBufferBuilderSupplier(Supplier<BufferBuilder> requestBufferBuilderSupplier) {
            this.requestBufferBuilderSupplier = requestBufferBuilderSupplier;
            return this;
        }

        public Builder setRequestBufferBuilderBlockingSupplier(Supplier<BufferBuilder> requestBufferBuilderBlockingSupplier) {
            this.requestBufferBuilderBlockingSupplier = requestBufferBuilderBlockingSupplier;
            return this;
        }

        public Builder setRequestBufferBuilderFunction(Function<Integer, BufferBuilder> requestBufferBuilderFunction) {
            this.requestBufferBuilderFunction = requestBufferBuilderFunction;
            return this;
        }

        public Builder setRequestBufferBuilderBlockingFunction(Function<Integer, BufferBuilder> requestBufferBuilderBlockingFunction) {
            this.requestBufferBuilderBlockingFunction = requestBufferBuilderBlockingFunction;
            return this;
        }

        public Builder setAddBufferListenerFunction(Function<BufferListener, Boolean> addBufferListenerFunction) {
            this.addBufferListenerFunction = addBufferListenerFunction;
            return this;
        }

        public Builder setIsDestroyedSupplier(Supplier<Boolean> isDestroyedSupplier) {
            this.isDestroyedSupplier = isDestroyedSupplier;
            return this;
        }

        public Builder setRequestMemorySegmentSupplier(Supplier<MemorySegment> requestMemorySegmentSupplier) {
            this.requestMemorySegmentSupplier = requestMemorySegmentSupplier;
            return this;
        }

        public Builder setRequestMemorySegmentBlockingSupplier(Supplier<MemorySegment> requestMemorySegmentBlockingSupplier) {
            this.requestMemorySegmentBlockingSupplier = requestMemorySegmentBlockingSupplier;
            return this;
        }

        public Builder setGetExpectedNumberOfMemorySegmentsSupplier(Supplier<Integer> getExpectedNumberOfMemorySegmentsSupplier) {
            this.getExpectedNumberOfMemorySegmentsSupplier = getExpectedNumberOfMemorySegmentsSupplier;
            return this;
        }

        public Builder setGetMinNumberOfMemorySegmentsSupplier(Supplier<Integer> getMinNumberOfMemorySegmentsSupplier) {
            this.getMinNumberOfMemorySegmentsSupplier = getMinNumberOfMemorySegmentsSupplier;
            return this;
        }

        public Builder setGetMaxNumberOfMemorySegmentsSupplier(Supplier<Integer> getMaxNumberOfMemorySegmentsSupplier) {
            this.getMaxNumberOfMemorySegmentsSupplier = getMaxNumberOfMemorySegmentsSupplier;
            return this;
        }

        public Builder setGetNumBuffersSupplier(Supplier<Integer> getNumBuffersSupplier) {
            this.getNumBuffersSupplier = getNumBuffersSupplier;
            return this;
        }

        public Builder setSetNumBuffersConsumer(Consumer<Integer> setNumBuffersConsumer) {
            this.setNumBuffersConsumer = setNumBuffersConsumer;
            return this;
        }

        public Builder setSetMaxOverdraftBuffersPerGateConsumer(Consumer<Integer> setMaxOverdraftBuffersPerGateConsumer) {
            this.setMaxOverdraftBuffersPerGateConsumer = setMaxOverdraftBuffersPerGateConsumer;
            return this;
        }

        public Builder setGetMaxOverdraftBuffersPerGateSupplier(Supplier<Integer> getMaxOverdraftBuffersPerGateSupplier) {
            this.getMaxOverdraftBuffersPerGateSupplier = getMaxOverdraftBuffersPerGateSupplier;
            return this;
        }

        public Builder setGetNumberOfAvailableMemorySegmentsSupplier(Supplier<Integer> getNumberOfAvailableMemorySegmentsSupplier) {
            this.getNumberOfAvailableMemorySegmentsSupplier = getNumberOfAvailableMemorySegmentsSupplier;
            return this;
        }

        public Builder setBestEffortGetNumOfUsedBuffersSupplier(Supplier<Integer> bestEffortGetNumOfUsedBuffersSupplier) {
            this.bestEffortGetNumOfUsedBuffersSupplier = bestEffortGetNumOfUsedBuffersSupplier;
            return this;
        }

        public Builder setRecycleConsumer(Consumer<MemorySegment> recycleConsumer) {
            this.recycleConsumer = recycleConsumer;
            return this;
        }

        public Builder setGetAvailableFutureSupplier(Supplier<CompletableFuture<?>> getAvailableFutureSupplier) {
            this.getAvailableFutureSupplier = getAvailableFutureSupplier;
            return this;
        }
    }
}

