/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.flink.api.common.state.v2.StateFuture;
import org.apache.flink.core.state.StateFutureUtils;
import org.apache.flink.runtime.asyncprocessing.ContextStateFutureImpl;
import org.apache.flink.runtime.asyncprocessing.RecordContext;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ContextStateFutureImplTest {
    @Test
    public void testThenApply() {
        SingleStepRunner runner = new SingleStepRunner();
        RecordContext recordContext = new RecordContext((Object)"a", (Object)"b", e -> {});
        ContextStateFutureImpl future = new ContextStateFutureImpl(runner::submit, recordContext);
        Assertions.assertThat((int)recordContext.getReferenceCount()).isEqualTo(1);
        future.thenApply(v -> 1L);
        future.complete(null);
        Assertions.assertThat((boolean)runner.runThrough()).isTrue();
        Assertions.assertThat((int)recordContext.getReferenceCount()).isEqualTo(0);
        future = new ContextStateFutureImpl(runner::submit, recordContext);
        Assertions.assertThat((int)recordContext.getReferenceCount()).isEqualTo(1);
        future.complete(null);
        Assertions.assertThat((int)recordContext.getReferenceCount()).isEqualTo(0);
        future.thenApply(v -> 1L);
        Assertions.assertThat((int)recordContext.getReferenceCount()).isEqualTo(0);
        Assertions.assertThat((boolean)runner.runThrough()).isFalse();
    }

    @Test
    public void testThenAccept() {
        SingleStepRunner runner = new SingleStepRunner();
        RecordContext recordContext = new RecordContext((Object)"a", (Object)"b", e -> {});
        ContextStateFutureImpl future = new ContextStateFutureImpl(runner::submit, recordContext);
        Assertions.assertThat((int)recordContext.getReferenceCount()).isEqualTo(1);
        future.thenAccept(v -> {});
        future.complete(null);
        Assertions.assertThat((boolean)runner.runThrough()).isTrue();
        Assertions.assertThat((int)recordContext.getReferenceCount()).isEqualTo(0);
        future = new ContextStateFutureImpl(runner::submit, recordContext);
        Assertions.assertThat((int)recordContext.getReferenceCount()).isEqualTo(1);
        future.complete(null);
        Assertions.assertThat((int)recordContext.getReferenceCount()).isEqualTo(0);
        future.thenAccept(v -> {});
        Assertions.assertThat((int)recordContext.getReferenceCount()).isEqualTo(0);
        Assertions.assertThat((boolean)runner.runThrough()).isFalse();
    }

    @Test
    public void testThenCompose() {
        SingleStepRunner runner = new SingleStepRunner();
        RecordContext recordContext = new RecordContext((Object)"a", (Object)"b", e -> {});
        ContextStateFutureImpl future = new ContextStateFutureImpl(runner::submit, recordContext);
        Assertions.assertThat((int)recordContext.getReferenceCount()).isEqualTo(1);
        future.thenCompose(v -> StateFutureUtils.completedFuture((Object)1L));
        future.complete(null);
        Assertions.assertThat((boolean)runner.runThrough()).isTrue();
        Assertions.assertThat((int)recordContext.getReferenceCount()).isEqualTo(0);
        future = new ContextStateFutureImpl(runner::submit, recordContext);
        Assertions.assertThat((int)recordContext.getReferenceCount()).isEqualTo(1);
        future.complete(null);
        Assertions.assertThat((int)recordContext.getReferenceCount()).isEqualTo(0);
        future.thenCompose(v -> StateFutureUtils.completedFuture((Object)1L));
        Assertions.assertThat((int)recordContext.getReferenceCount()).isEqualTo(0);
        Assertions.assertThat((boolean)runner.runThrough()).isFalse();
    }

    @Test
    public void testThenCombine() {
        SingleStepRunner runner = new SingleStepRunner();
        RecordContext recordContext = new RecordContext((Object)"a", (Object)"b", e -> {});
        ContextStateFutureImpl future1 = new ContextStateFutureImpl(runner::submit, recordContext);
        ContextStateFutureImpl future2 = new ContextStateFutureImpl(runner::submit, recordContext);
        Assertions.assertThat((int)recordContext.getReferenceCount()).isEqualTo(2);
        future1.thenCombine((StateFuture)future2, (v1, v2) -> 1L);
        future1.complete(null);
        future2.complete(null);
        Assertions.assertThat((boolean)runner.runThrough()).isTrue();
        Assertions.assertThat((int)recordContext.getReferenceCount()).isEqualTo(0);
        future1 = new ContextStateFutureImpl(runner::submit, recordContext);
        future2 = new ContextStateFutureImpl(runner::submit, recordContext);
        Assertions.assertThat((int)recordContext.getReferenceCount()).isEqualTo(2);
        future1.complete(null);
        future1.thenCombine((StateFuture)future2, (v1, v2) -> 1L);
        Assertions.assertThat((int)recordContext.getReferenceCount()).isGreaterThan(1);
        future2.complete(null);
        Assertions.assertThat((boolean)runner.runThrough()).isTrue();
        Assertions.assertThat((int)recordContext.getReferenceCount()).isEqualTo(0);
        future1 = new ContextStateFutureImpl(runner::submit, recordContext);
        future2 = new ContextStateFutureImpl(runner::submit, recordContext);
        Assertions.assertThat((int)recordContext.getReferenceCount()).isEqualTo(2);
        future2.complete(null);
        future1.thenCombine((StateFuture)future2, (v1, v2) -> 1L);
        Assertions.assertThat((int)recordContext.getReferenceCount()).isGreaterThan(1);
        future1.complete(null);
        Assertions.assertThat((boolean)runner.runThrough()).isTrue();
        Assertions.assertThat((int)recordContext.getReferenceCount()).isEqualTo(0);
        future1 = new ContextStateFutureImpl(runner::submit, recordContext);
        future2 = new ContextStateFutureImpl(runner::submit, recordContext);
        Assertions.assertThat((int)recordContext.getReferenceCount()).isEqualTo(2);
        future1.complete(null);
        future2.complete(null);
        future1.thenCombine((StateFuture)future2, (v1, v2) -> 1L);
        Assertions.assertThat((boolean)runner.runThrough()).isFalse();
        Assertions.assertThat((int)recordContext.getReferenceCount()).isEqualTo(0);
    }

    @Test
    public void testComplex() {
        SingleStepRunner runner = new SingleStepRunner();
        RecordContext recordContext = new RecordContext((Object)"a", (Object)"b", e -> {});
        for (int i = 0; i < 32; ++i) {
            int j;
            ArrayList<ContextStateFutureImpl> futures = new ArrayList<ContextStateFutureImpl>(6);
            for (j = 0; j < 5; ++j) {
                ContextStateFutureImpl future = new ContextStateFutureImpl(runner::submit, recordContext);
                futures.add(future);
                if ((i >>> j & 1) != 1) continue;
                future.complete(null);
            }
            StateFutureUtils.combineAll(Arrays.asList((ContextStateFutureImpl)futures.get(0), (ContextStateFutureImpl)futures.get(1), (ContextStateFutureImpl)futures.get(2))).thenCombine((StateFuture)futures.get(3), (a, b) -> 1L).thenCompose(a -> (StateFuture)futures.get(4)).thenApply(e -> 2L).thenAccept(b -> {});
            for (j = 0; j < 5; ++j) {
                if ((i >>> j & 1) != 0) continue;
                ((ContextStateFutureImpl)futures.get(j)).complete(null);
            }
            if (i == 31) {
                ((AbstractIntegerAssert)Assertions.assertThat((int)recordContext.getReferenceCount()).withFailMessage("The reference counted tests fail for profile id %d", new Object[]{i})).isEqualTo(0);
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)runner.runThrough()).withFailMessage("The reference counted tests fail for profile id %d", new Object[]{i})).isFalse();
                continue;
            }
            ((AbstractIntegerAssert)Assertions.assertThat((int)recordContext.getReferenceCount()).withFailMessage("The reference counted tests fail for profile id %d", new Object[]{i})).isGreaterThan(0);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)runner.runThrough()).withFailMessage("The reference counted tests fail for profile id %d", new Object[]{i})).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((int)recordContext.getReferenceCount()).withFailMessage("The reference counted tests fail for profile id %d", new Object[]{i})).isEqualTo(0);
        }
    }

    public static class SingleStepRunner {
        private final LinkedList<Runnable> runnables = new LinkedList();

        public void submit(Runnable runnable) {
            this.runnables.add(runnable);
        }

        public boolean runThrough() {
            boolean run = false;
            while (!this.runnables.isEmpty()) {
                this.runnables.poll().run();
                run = true;
            }
            return run;
        }
    }
}

