/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.checkpoint.filemerging.FileMergingSnapshotManager;
import org.apache.flink.runtime.state.CheckpointedStateScope;
import org.apache.flink.runtime.state.TaskExecutorFileMergingManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TaskExecutorFileMergingManagerTest {
    @Test
    public void testCheckpointScope(@TempDir java.nio.file.Path testBaseDir) throws IOException {
        TaskExecutorFileMergingManager taskExecutorFileMergingManager = new TaskExecutorFileMergingManager();
        JobID job1 = new JobID(1234L, 4321L);
        JobID job2 = new JobID(1234L, 5678L);
        FileMergingSnapshotManager.SubtaskKey key1 = new FileMergingSnapshotManager.SubtaskKey("test-op1", 0, 128);
        FileMergingSnapshotManager.SubtaskKey key2 = new FileMergingSnapshotManager.SubtaskKey("test-op2", 1, 128);
        Path checkpointDir1 = new Path(testBaseDir.toString(), "job1");
        Path checkpointDir2 = new Path(testBaseDir.toString(), "job2");
        int writeBufferSize = 4096;
        Configuration jobConfig = new Configuration();
        jobConfig.setBoolean(CheckpointingOptions.FILE_MERGING_ENABLED, true);
        Configuration clusterConfig = new Configuration();
        FileMergingSnapshotManager manager1 = taskExecutorFileMergingManager.fileMergingSnapshotManagerForJob(job1, clusterConfig, jobConfig);
        manager1.initFileSystem(checkpointDir1.getFileSystem(), checkpointDir1, new Path(checkpointDir1, "shared"), new Path(checkpointDir1, "taskowned"), writeBufferSize);
        FileMergingSnapshotManager manager2 = taskExecutorFileMergingManager.fileMergingSnapshotManagerForJob(job1, clusterConfig, jobConfig);
        manager2.initFileSystem(checkpointDir1.getFileSystem(), checkpointDir1, new Path(checkpointDir1, "shared"), new Path(checkpointDir1, "taskowned"), writeBufferSize);
        FileMergingSnapshotManager manager3 = taskExecutorFileMergingManager.fileMergingSnapshotManagerForJob(job2, clusterConfig, jobConfig);
        manager3.initFileSystem(checkpointDir2.getFileSystem(), checkpointDir2, new Path(checkpointDir2, "shared"), new Path(checkpointDir2, "taskowned"), writeBufferSize);
        Assertions.assertThat((Object)manager1).isEqualTo((Object)manager2);
        Assertions.assertThat((Object)manager1).isNotEqualTo((Object)manager3);
        Assertions.assertThat((Object)manager1.getManagedDir(key1, CheckpointedStateScope.EXCLUSIVE)).isEqualTo((Object)manager2.getManagedDir(key2, CheckpointedStateScope.EXCLUSIVE));
        Assertions.assertThat((Object)manager1.getManagedDir(key1, CheckpointedStateScope.EXCLUSIVE)).isNotEqualTo((Object)manager3.getManagedDir(key2, CheckpointedStateScope.EXCLUSIVE));
        manager1.registerSubtaskForSharedStates(key1);
        manager1.registerSubtaskForSharedStates(key2);
        manager3.registerSubtaskForSharedStates(key1);
        manager3.registerSubtaskForSharedStates(key2);
        Assertions.assertThat((Object)manager1.getManagedDir(key1, CheckpointedStateScope.SHARED)).isNotEqualTo((Object)manager1.getManagedDir(key2, CheckpointedStateScope.SHARED));
        Assertions.assertThat((Object)manager1.getManagedDir(key1, CheckpointedStateScope.SHARED)).isNotEqualTo((Object)manager3.getManagedDir(key1, CheckpointedStateScope.SHARED));
    }
}

