/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.ConfigurableStateBackend;
import org.apache.flink.runtime.state.StateBackendTestBase;
import org.apache.flink.runtime.state.hashmap.HashMapStateBackend;
import org.apache.flink.runtime.state.storage.FileSystemCheckpointStorage;
import org.apache.flink.runtime.state.storage.JobManagerCheckpointStorage;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameter;
import org.apache.flink.testutils.junit.extensions.parameterized.ParameterizedTestExtension;
import org.apache.flink.testutils.junit.extensions.parameterized.Parameters;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.util.function.SupplierWithException;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={ParameterizedTestExtension.class})
public class HashMapStateBackendTest
extends StateBackendTestBase<HashMapStateBackend> {
    @TempDir
    private static java.nio.file.Path tempFolder;
    @Parameter
    public SupplierWithException<CheckpointStorage, IOException> storageSupplier;

    @Parameters
    public static List<Object[]> modes() {
        return Arrays.asList({JobManagerCheckpointStorage::new}, {() -> {
            String checkpointPath = TempDirUtils.newFolder((java.nio.file.Path)tempFolder).toURI().toString();
            return new FileSystemCheckpointStorage(new Path(checkpointPath), 0, -1);
        }});
    }

    @Override
    protected ConfigurableStateBackend getStateBackend() {
        return new HashMapStateBackend();
    }

    @Override
    protected CheckpointStorage getCheckpointStorage() throws Exception {
        return (CheckpointStorage)this.storageSupplier.get();
    }

    @Override
    protected boolean supportsAsynchronousSnapshots() {
        return true;
    }

    @Override
    protected boolean isSerializerPresenceRequiredOnRestore() {
        return true;
    }

    @Override
    @TestTemplate
    void testValueStateRestoreWithWrongSerializers() {
    }

    @Override
    @TestTemplate
    void testListStateRestoreWithWrongSerializers() {
    }

    @Override
    @TestTemplate
    void testReducingStateRestoreWithWrongSerializers() {
    }

    @Override
    @TestTemplate
    void testMapStateRestoreWithWrongSerializers() {
    }

    @Override
    @Disabled
    @TestTemplate
    void testConcurrentMapIfQueryable() throws Exception {
        super.testConcurrentMapIfQueryable();
    }
}

