/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.query;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.apache.flink.api.common.JobID;
import org.apache.flink.queryablestate.KvStateID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.query.KvStateLocation;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class KvStateLocationTest {
    KvStateLocationTest() {
    }

    @Test
    void testRegisterAndLookup() throws Exception {
        int keyGroup;
        KeyGroupRange keyGroupRange;
        int rangeIdx;
        JobID jobId = new JobID();
        JobVertexID jobVertexId = new JobVertexID();
        int numKeyGroups = 123;
        int numRanges = 10;
        int fract = numKeyGroups / numRanges;
        int remain = numKeyGroups % numRanges;
        ArrayList<KeyGroupRange> keyGroupRanges = new ArrayList<KeyGroupRange>(numRanges);
        int start = 0;
        for (int i = 0; i < numRanges; ++i) {
            int end = start + fract - 1;
            if (remain > 0) {
                --remain;
                ++end;
            }
            KeyGroupRange range = new KeyGroupRange(start, end);
            keyGroupRanges.add(range);
            start = end + 1;
        }
        String registrationName = "asdasdasdasd";
        KvStateLocation location = new KvStateLocation(jobId, jobVertexId, numKeyGroups, registrationName);
        KvStateID[] kvStateIds = new KvStateID[numRanges];
        InetSocketAddress[] serverAddresses = new InetSocketAddress[numRanges];
        InetAddress host = InetAddress.getLocalHost();
        int registeredCount = 0;
        for (rangeIdx = 0; rangeIdx < numRanges; ++rangeIdx) {
            kvStateIds[rangeIdx] = new KvStateID();
            serverAddresses[rangeIdx] = new InetSocketAddress(host, 1024 + rangeIdx);
            keyGroupRange = (KeyGroupRange)keyGroupRanges.get(rangeIdx);
            location.registerKvState(keyGroupRange, kvStateIds[rangeIdx], serverAddresses[rangeIdx]);
            Assertions.assertThat((int)location.getNumRegisteredKeyGroups()).isEqualTo(registeredCount += keyGroupRange.getNumberOfKeyGroups());
        }
        for (rangeIdx = 0; rangeIdx < numRanges; ++rangeIdx) {
            keyGroupRange = (KeyGroupRange)keyGroupRanges.get(rangeIdx);
            for (keyGroup = keyGroupRange.getStartKeyGroup(); keyGroup <= keyGroupRange.getEndKeyGroup(); ++keyGroup) {
                Assertions.assertThat((Comparable)location.getKvStateID(keyGroup)).isEqualTo((Object)kvStateIds[rangeIdx]);
                Assertions.assertThat((Object)location.getKvStateServerAddress(keyGroup)).isEqualTo((Object)serverAddresses[rangeIdx]);
            }
        }
        for (rangeIdx = 0; rangeIdx < numRanges; ++rangeIdx) {
            kvStateIds[rangeIdx] = new KvStateID();
            serverAddresses[rangeIdx] = new InetSocketAddress(host, 1024 + rangeIdx);
            location.registerKvState((KeyGroupRange)keyGroupRanges.get(rangeIdx), kvStateIds[rangeIdx], serverAddresses[rangeIdx]);
            Assertions.assertThat((int)location.getNumRegisteredKeyGroups()).isEqualTo(registeredCount);
        }
        for (rangeIdx = 0; rangeIdx < numRanges; ++rangeIdx) {
            keyGroupRange = (KeyGroupRange)keyGroupRanges.get(rangeIdx);
            for (keyGroup = keyGroupRange.getStartKeyGroup(); keyGroup <= keyGroupRange.getEndKeyGroup(); ++keyGroup) {
                Assertions.assertThat((Comparable)location.getKvStateID(keyGroup)).isEqualTo((Object)kvStateIds[rangeIdx]);
                Assertions.assertThat((Object)location.getKvStateServerAddress(keyGroup)).isEqualTo((Object)serverAddresses[rangeIdx]);
            }
        }
        for (rangeIdx = 0; rangeIdx < numRanges; ++rangeIdx) {
            keyGroupRange = (KeyGroupRange)keyGroupRanges.get(rangeIdx);
            location.unregisterKvState(keyGroupRange);
            Assertions.assertThat((int)location.getNumRegisteredKeyGroups()).isEqualTo(registeredCount -= keyGroupRange.getNumberOfKeyGroups());
        }
        for (rangeIdx = 0; rangeIdx < numRanges; ++rangeIdx) {
            keyGroupRange = (KeyGroupRange)keyGroupRanges.get(rangeIdx);
            for (keyGroup = keyGroupRange.getStartKeyGroup(); keyGroup <= keyGroupRange.getEndKeyGroup(); ++keyGroup) {
                Assertions.assertThat((Comparable)location.getKvStateID(keyGroup)).isNull();
                Assertions.assertThat((Object)location.getKvStateServerAddress(keyGroup)).isNull();
            }
        }
        Assertions.assertThat((int)location.getNumRegisteredKeyGroups()).isZero();
    }
}

