/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmanager.slots.TestingSlotOwner;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.SlotOwner;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.AllocatedSlot;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.jobmaster.slotpool.SingleLogicalSlot;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;

public class PhysicalSlotTestUtils {
    public static PhysicalSlot createPhysicalSlot() {
        return PhysicalSlotTestUtils.createPhysicalSlot(ResourceProfile.ANY);
    }

    public static PhysicalSlot createPhysicalSlot(ResourceProfile resourceProfile) {
        return new AllocatedSlot(new AllocationID(), (TaskManagerLocation)new LocalTaskManagerLocation(), 0, resourceProfile, (TaskManagerGateway)new SimpleAckingTaskManagerGateway());
    }

    public static LogicalSlot occupyPhysicalSlot(PhysicalSlot physicalSlot, boolean slotWillBeOccupiedIndefinitely) {
        return SingleLogicalSlot.allocateFromPhysicalSlot((SlotRequestId)new SlotRequestId(), (PhysicalSlot)physicalSlot, (Locality)Locality.UNKNOWN, (SlotOwner)new TestingSlotOwner(), (boolean)slotWillBeOccupiedIndefinitely);
    }

    private PhysicalSlotTestUtils() {
    }
}

