/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.runtime.io.network.buffer.BufferBuilderTestUtils;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.TestingTieredStorageMemoryManager;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageIdMappingUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.PartitionFileWriter;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.TestingPartitionFileWriter;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemoryManager;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote.RemoteCacheManager;
import org.apache.flink.util.concurrent.FutureUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class RemoteCacheManagerTest {
    RemoteCacheManagerTest() {
    }

    @Test
    void testStartAndFinishSegment() {
        TieredStoragePartitionId partitionId = TieredStorageIdMappingUtils.convertId((ResultPartitionID)new ResultPartitionID());
        int subpartitionId = 0;
        int segmentId = 0;
        AtomicInteger numReceivedBuffers = new AtomicInteger(0);
        TestingPartitionFileWriter partitionFileWriter = new TestingPartitionFileWriter.Builder().setWriteFunction((ignoredPartitionId, bufferContexts) -> {
            numReceivedBuffers.addAndGet(((PartitionFileWriter.SegmentBufferContext)((PartitionFileWriter.SubpartitionBufferContext)bufferContexts.get(subpartitionId)).getSegmentBufferContexts().get(segmentId)).getBufferAndIndexes().size());
            return FutureUtils.completedVoidFuture();
        }).build();
        RemoteCacheManager cacheManager = new RemoteCacheManager(partitionId, 1, (TieredStorageMemoryManager)new TestingTieredStorageMemoryManager.Builder().build(), (PartitionFileWriter)partitionFileWriter);
        cacheManager.startSegment(subpartitionId, segmentId);
        cacheManager.appendBuffer(BufferBuilderTestUtils.buildSomeBuffer(), subpartitionId);
        cacheManager.finishSegment(subpartitionId);
        Assertions.assertThat((AtomicInteger)numReceivedBuffers).hasValue(1);
    }

    @Test
    void testRelease() {
        TieredStoragePartitionId partitionId = TieredStorageIdMappingUtils.convertId((ResultPartitionID)new ResultPartitionID());
        AtomicBoolean isReleased = new AtomicBoolean(false);
        TestingPartitionFileWriter partitionFileWriter = new TestingPartitionFileWriter.Builder().setReleaseRunnable(() -> isReleased.set(true)).build();
        RemoteCacheManager cacheManager = new RemoteCacheManager(partitionId, 1, (TieredStorageMemoryManager)new TestingTieredStorageMemoryManager.Builder().build(), (PartitionFileWriter)partitionFileWriter);
        cacheManager.release();
        Assertions.assertThat((AtomicBoolean)isReleased).isTrue();
    }
}

