/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty;

import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.NettyConnectionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.NettyConnectionWriter;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.NettyPayload;

public class TestingNettyConnectionWriter
implements NettyConnectionWriter {
    private final Function<NettyPayload, Void> writeBufferFunction;
    private final Supplier<NettyConnectionId> nettyConnectionIdSupplier;
    private final Supplier<Integer> numQueuedPayloadsSupplier;
    private final Supplier<Integer> numQueuedBufferPayloadsSupplier;
    private final Runnable availableNotifier;
    private final Function<Throwable, Void> closeFunction;

    private TestingNettyConnectionWriter(Function<NettyPayload, Void> writeBufferFunction, Supplier<NettyConnectionId> nettyConnectionIdSupplier, Supplier<Integer> numQueuedPayloadsSupplier, Supplier<Integer> numQueuedBufferPayloadsSupplier, Function<Throwable, Void> closeFunction, Runnable availableNotifier) {
        this.writeBufferFunction = writeBufferFunction;
        this.nettyConnectionIdSupplier = nettyConnectionIdSupplier;
        this.numQueuedPayloadsSupplier = numQueuedPayloadsSupplier;
        this.numQueuedBufferPayloadsSupplier = numQueuedBufferPayloadsSupplier;
        this.closeFunction = closeFunction;
        this.availableNotifier = availableNotifier;
    }

    public void writeNettyPayload(NettyPayload nettyPayload) {
        this.writeBufferFunction.apply(nettyPayload);
    }

    public NettyConnectionId getNettyConnectionId() {
        return this.nettyConnectionIdSupplier.get();
    }

    public int numQueuedPayloads() {
        return this.numQueuedPayloadsSupplier.get();
    }

    public int numQueuedBufferPayloads() {
        return this.numQueuedBufferPayloadsSupplier.get();
    }

    public void notifyAvailable() {
        this.availableNotifier.run();
    }

    public void close(@Nullable Throwable error) {
        this.closeFunction.apply(error);
    }

    public static class Builder {
        private Function<NettyPayload, Void> writeBufferFunction = buffer -> null;
        private Supplier<NettyConnectionId> nettyConnectionIdSupplier = NettyConnectionId::newId;
        private Supplier<Integer> numQueuedNettyPayloadsSupplier = () -> 0;
        private Supplier<Integer> numQueuedBufferPayloadsSupplier = () -> 0;
        private Function<Throwable, Void> closeFunction = throwable -> null;
        private Runnable availableNotifier = () -> {};

        public Builder setWriteBufferFunction(Function<NettyPayload, Void> writeBufferFunction) {
            this.writeBufferFunction = writeBufferFunction;
            return this;
        }

        public Builder setNettyConnectionIdSupplier(Supplier<NettyConnectionId> nettyConnectionIdSupplier) {
            this.nettyConnectionIdSupplier = nettyConnectionIdSupplier;
            return this;
        }

        public Builder setNumQueuedNettyPayloadsSupplier(Supplier<Integer> numQueuedNettyPayloadsSupplier) {
            this.numQueuedNettyPayloadsSupplier = numQueuedNettyPayloadsSupplier;
            return this;
        }

        public Builder setNumQueuedBufferPayloadsSupplier(Supplier<Integer> numQueuedBufferPayloadsSupplier) {
            this.numQueuedBufferPayloadsSupplier = numQueuedBufferPayloadsSupplier;
            return this;
        }

        public Builder setCloseFunction(Function<Throwable, Void> closeFunction) {
            this.closeFunction = closeFunction;
            return this;
        }

        public Builder setAvailableNotifier(Runnable availableNotifier) {
            this.availableNotifier = availableNotifier;
            return this;
        }

        public TestingNettyConnectionWriter build() {
            return new TestingNettyConnectionWriter(this.writeBufferFunction, this.nettyConnectionIdSupplier, this.numQueuedNettyPayloadsSupplier, this.numQueuedBufferPayloadsSupplier, this.closeFunction, this.availableNotifier);
        }
    }
}

