/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.consumer.GateBuffersSpec;
import org.apache.flink.runtime.io.network.partition.consumer.InputGateSpecUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageConfiguration;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class GateBuffersSpecTest {
    GateBuffersSpecTest() {
    }

    private static ResultPartitionType[] parameters() {
        return ResultPartitionType.values();
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void testCalculationWithSufficientRequiredBuffers(ResultPartitionType partitionType) {
        int numInputChannels = 499;
        GateBuffersSpec gateBuffersSpec = GateBuffersSpecTest.createGateBuffersSpec(numInputChannels, partitionType);
        int numExclusivePerChannel = 2;
        int expectedBuffersPerGate = 999;
        int maxBuffersPerGate = 1006;
        GateBuffersSpecTest.checkBuffersInGate(gateBuffersSpec, numExclusivePerChannel, expectedBuffersPerGate, expectedBuffersPerGate, maxBuffersPerGate);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void testCalculationWithOneExclusiveBuffer(ResultPartitionType partitionType) {
        int numInputChannels = 500;
        GateBuffersSpec gateBuffersSpec = GateBuffersSpecTest.createGateBuffersSpec(numInputChannels, partitionType);
        boolean isPipeline = GateBuffersSpecTest.isPipelinedOrHybridResultPartition(partitionType);
        int numExclusivePerChannel = GateBuffersSpecTest.isPipelinedOrHybridResultPartition(partitionType) ? 2 : 1;
        int expectedBuffersPerGate = isPipeline ? 1001 : 1000;
        int maxBuffersPerGate = 1008;
        GateBuffersSpecTest.checkBuffersInGate(gateBuffersSpec, numExclusivePerChannel, expectedBuffersPerGate, expectedBuffersPerGate, maxBuffersPerGate);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void testUpperBoundaryCalculationWithOneExclusiveBuffer(ResultPartitionType partitionType) {
        int numInputChannels = 999;
        GateBuffersSpec gateBuffersSpec = GateBuffersSpecTest.createGateBuffersSpec(numInputChannels, partitionType);
        int numExclusivePerChannel = GateBuffersSpecTest.isPipelinedOrHybridResultPartition(partitionType) ? 2 : 1;
        int expectedBuffersPerGate = GateBuffersSpecTest.isPipelinedOrHybridResultPartition(partitionType) ? 1999 : 1000;
        int maxBuffersPerGate = 2006;
        GateBuffersSpecTest.checkBuffersInGate(gateBuffersSpec, numExclusivePerChannel, expectedBuffersPerGate, expectedBuffersPerGate, maxBuffersPerGate);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void testBoundaryCalculationWithoutExclusiveBuffer(ResultPartitionType partitionType) {
        int numInputChannels = 1000;
        GateBuffersSpec gateBuffersSpec = GateBuffersSpecTest.createGateBuffersSpec(numInputChannels, partitionType);
        boolean isPipeline = GateBuffersSpecTest.isPipelinedOrHybridResultPartition(partitionType);
        int numExclusivePerChannel = isPipeline ? 2 : 0;
        int expectedBuffersPerGate = isPipeline ? 2001 : 1000;
        int maxBuffersPerGate = 2008;
        GateBuffersSpecTest.checkBuffersInGate(gateBuffersSpec, numExclusivePerChannel, expectedBuffersPerGate, expectedBuffersPerGate, maxBuffersPerGate);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void testCalculationWithConfiguredZeroExclusiveBuffer(ResultPartitionType partitionType) {
        int numInputChannels = 1001;
        int numExclusiveBuffersPerChannel = 0;
        GateBuffersSpec gateBuffersSpec = GateBuffersSpecTest.createGateBuffersSpec(numInputChannels, partitionType, numExclusiveBuffersPerChannel);
        int numExclusivePerChannel = 0;
        int minBuffersPerGate = 1;
        int maxBuffersPerGate = 8;
        GateBuffersSpecTest.checkBuffersInGate(gateBuffersSpec, numExclusivePerChannel, minBuffersPerGate, minBuffersPerGate, maxBuffersPerGate);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void testConfiguredMaxRequiredBuffersPerGate(ResultPartitionType partitionType) {
        boolean enabledTieredStorage = false;
        Optional<Integer> configuredMaxRequiredBuffers = Optional.of(100);
        int effectiveMaxRequiredBuffers = InputGateSpecUtils.getEffectiveMaxRequiredBuffersPerGate((ResultPartitionType)partitionType, configuredMaxRequiredBuffers, (boolean)enabledTieredStorage);
        Assertions.assertThat((int)effectiveMaxRequiredBuffers).isEqualTo((Object)configuredMaxRequiredBuffers.get());
        enabledTieredStorage = true;
        effectiveMaxRequiredBuffers = InputGateSpecUtils.getEffectiveMaxRequiredBuffersPerGate((ResultPartitionType)partitionType, configuredMaxRequiredBuffers, (boolean)enabledTieredStorage);
        Assertions.assertThat((int)effectiveMaxRequiredBuffers).isEqualTo((Object)configuredMaxRequiredBuffers.get());
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void testDefaultMaxRequiredBuffersPerGate(ResultPartitionType partitionType) {
        Optional emptyConfig = Optional.empty();
        boolean enabledTieredStorage = false;
        int effectiveMaxRequiredBuffers = InputGateSpecUtils.getEffectiveMaxRequiredBuffersPerGate((ResultPartitionType)partitionType, emptyConfig, (boolean)enabledTieredStorage);
        int expectEffectiveMaxRequiredBuffers = GateBuffersSpecTest.isPipelinedOrHybridResultPartitionNewMode(partitionType, enabledTieredStorage) ? Integer.MAX_VALUE : 1000;
        Assertions.assertThat((int)effectiveMaxRequiredBuffers).isEqualTo(expectEffectiveMaxRequiredBuffers);
        enabledTieredStorage = true;
        expectEffectiveMaxRequiredBuffers = GateBuffersSpecTest.isPipelinedOrHybridResultPartitionNewMode(partitionType, enabledTieredStorage) ? Integer.MAX_VALUE : 1000;
        effectiveMaxRequiredBuffers = InputGateSpecUtils.getEffectiveMaxRequiredBuffersPerGate((ResultPartitionType)partitionType, emptyConfig, (boolean)enabledTieredStorage);
        Assertions.assertThat((int)effectiveMaxRequiredBuffers).isEqualTo(expectEffectiveMaxRequiredBuffers);
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void testDefaultMinBuffersPerGate(ResultPartitionType partitionType) {
        int numInputChannels = 499;
        int numExclusiveBuffers = 2;
        GateBuffersSpec gateBuffersSpec = GateBuffersSpecTest.createGateBuffersSpec(numInputChannels, partitionType, numExclusiveBuffers, null);
        int expectedBuffersPerGate = 999;
        int maxBuffersPerGate = 1006;
        GateBuffersSpecTest.checkBuffersInGate(gateBuffersSpec, numExclusiveBuffers, expectedBuffersPerGate, expectedBuffersPerGate, maxBuffersPerGate);
        TieredStorageConfiguration config = new TieredStorageConfiguration.Builder().setMemoryDecouplingEnabled(true).build();
        gateBuffersSpec = GateBuffersSpecTest.createGateBuffersSpec(numInputChannels, partitionType, numExclusiveBuffers, config);
        int minBuffersPerGate = partitionType.isHybridResultPartition() ? 2 : 999;
        GateBuffersSpecTest.checkBuffersInGate(gateBuffersSpec, numExclusiveBuffers, expectedBuffersPerGate, minBuffersPerGate, maxBuffersPerGate);
    }

    private static void checkBuffersInGate(GateBuffersSpec gateBuffersSpec, int numExclusivePerChannel, int expectedBuffersPerGate, int minBuffersPerGate, int maxBuffersPerGate) {
        Assertions.assertThat((int)gateBuffersSpec.getEffectiveExclusiveBuffersPerChannel()).isEqualTo(numExclusivePerChannel);
        Assertions.assertThat((int)gateBuffersSpec.getExpectedBuffersPerGate()).isEqualTo(expectedBuffersPerGate);
        Assertions.assertThat((int)gateBuffersSpec.getMinBuffersPerGate()).isEqualTo(minBuffersPerGate);
        Assertions.assertThat((int)gateBuffersSpec.getMaxBuffersPerGate()).isEqualTo(maxBuffersPerGate);
    }

    private static GateBuffersSpec createGateBuffersSpec(int numInputChannels, ResultPartitionType partitionType) {
        return GateBuffersSpecTest.createGateBuffersSpec(numInputChannels, partitionType, 2);
    }

    private static GateBuffersSpec createGateBuffersSpec(int numInputChannels, ResultPartitionType partitionType, int numExclusiveBuffersPerChannel) {
        return InputGateSpecUtils.createGateBuffersSpec(GateBuffersSpecTest.getMaxRequiredBuffersPerGate(partitionType), (int)numExclusiveBuffersPerChannel, (int)8, (ResultPartitionType)partitionType, (int)numInputChannels, null);
    }

    private static GateBuffersSpec createGateBuffersSpec(int numInputChannels, ResultPartitionType partitionType, int numExclusiveBuffersPerChannel, @Nullable TieredStorageConfiguration config) {
        return InputGateSpecUtils.createGateBuffersSpec(GateBuffersSpecTest.getMaxRequiredBuffersPerGate(partitionType), (int)numExclusiveBuffersPerChannel, (int)8, (ResultPartitionType)partitionType, (int)numInputChannels, (TieredStorageConfiguration)config);
    }

    private static Optional<Integer> getMaxRequiredBuffersPerGate(ResultPartitionType partitionType) {
        return GateBuffersSpecTest.isPipelinedOrHybridResultPartition(partitionType) ? Optional.of(Integer.MAX_VALUE) : Optional.of(1000);
    }

    private static boolean isPipelinedOrHybridResultPartition(ResultPartitionType partitionType) {
        return partitionType.isPipelinedOrPipelinedBoundedResultPartition() || partitionType.isHybridResultPartition();
    }

    private static boolean isPipelinedOrHybridResultPartitionNewMode(ResultPartitionType partitionType, Boolean enabledTieredStorage) {
        return partitionType.isPipelinedOrPipelinedBoundedResultPartition() || partitionType.isHybridResultPartition() && enabledTieredStorage == false;
    }
}

