/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.Iterator;
import java.util.function.Consumer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.io.network.NetworkSequenceViewReader;
import org.apache.flink.runtime.io.network.partition.PartitionRequestListener;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionProvider;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionIndexSet;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;
import org.apache.flink.util.Preconditions;
import org.jetbrains.annotations.Nullable;

public class TestingSubpartitionCreatedViewReader
implements NetworkSequenceViewReader {
    private final InputChannelID receiverId;
    private final Consumer<PartitionRequestListener> partitionRequestListenerTimeoutConsumer;
    private final Consumer<Tuple2<ResultPartition, Integer>> notifySubpartitionCreatedConsumer;

    private TestingSubpartitionCreatedViewReader(InputChannelID receiverId, Consumer<PartitionRequestListener> partitionRequestListenerTimeoutConsumer, Consumer<Tuple2<ResultPartition, Integer>> notifySubpartitionCreatedConsumer) {
        this.receiverId = receiverId;
        this.partitionRequestListenerTimeoutConsumer = partitionRequestListenerTimeoutConsumer;
        this.notifySubpartitionCreatedConsumer = notifySubpartitionCreatedConsumer;
    }

    public void notifySubpartitionsCreated(ResultPartition partition, ResultSubpartitionIndexSet subpartitionIndexSet) throws IOException {
        Iterator iterator = subpartitionIndexSet.values().iterator();
        int subpartitionIndex = (Integer)iterator.next();
        Preconditions.checkArgument((!iterator.hasNext() ? 1 : 0) != 0);
        this.notifySubpartitionCreatedConsumer.accept((Tuple2<ResultPartition, Integer>)Tuple2.of((Object)partition, (Object)subpartitionIndex));
    }

    public int peekNextBufferSubpartitionId() {
        throw new UnsupportedOperationException();
    }

    public void requestSubpartitionViewOrRegisterListener(ResultPartitionProvider partitionProvider, ResultPartitionID resultPartitionId, ResultSubpartitionIndexSet subPartitionIndexRange) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public InputChannel.BufferAndAvailability getNextBuffer() throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean needAnnounceBacklog() {
        throw new UnsupportedOperationException();
    }

    public void addCredit(int creditDeltas) {
        throw new UnsupportedOperationException();
    }

    public void notifyRequiredSegmentId(int subpartitionId, int segmentId) {
        throw new UnsupportedOperationException();
    }

    public void resumeConsumption() {
        throw new UnsupportedOperationException();
    }

    public void acknowledgeAllRecordsProcessed() {
        throw new UnsupportedOperationException();
    }

    public ResultSubpartitionView.AvailabilityWithBacklog getAvailabilityAndBacklog() {
        throw new UnsupportedOperationException();
    }

    public boolean isRegisteredAsAvailable() {
        throw new UnsupportedOperationException();
    }

    public void setRegisteredAsAvailable(boolean isRegisteredAvailable) {
        throw new UnsupportedOperationException();
    }

    public boolean isReleased() {
        throw new UnsupportedOperationException();
    }

    public void releaseAllResources() throws IOException {
        throw new UnsupportedOperationException();
    }

    public Throwable getFailureCause() {
        throw new UnsupportedOperationException();
    }

    public InputChannelID getReceiverId() {
        return this.receiverId;
    }

    public void notifyNewBufferSize(int newBufferSize) {
        throw new UnsupportedOperationException();
    }

    public void notifyPartitionRequestTimeout(PartitionRequestListener partitionRequestListener) {
        this.partitionRequestListenerTimeoutConsumer.accept(partitionRequestListener);
    }

    public static TestingSubpartitionCreatedViewReaderBuilder newBuilder() {
        return new TestingSubpartitionCreatedViewReaderBuilder();
    }

    public static class TestingSubpartitionCreatedViewReaderBuilder {
        private InputChannelID receiverId;
        private Consumer<PartitionRequestListener> partitionRequestListenerTimeoutConsumer = listener -> {};
        private Consumer<Tuple2<ResultPartition, Integer>> notifySubpartitionCreatedConsumer = tuple -> {};

        public TestingSubpartitionCreatedViewReaderBuilder setReceiverId(InputChannelID receiverId) {
            this.receiverId = receiverId;
            return this;
        }

        public TestingSubpartitionCreatedViewReaderBuilder setPartitionRequestListenerTimeoutConsumer(Consumer<PartitionRequestListener> partitionRequestListenerTimeoutConsumer) {
            this.partitionRequestListenerTimeoutConsumer = partitionRequestListenerTimeoutConsumer;
            return this;
        }

        public TestingSubpartitionCreatedViewReaderBuilder setNotifySubpartitionCreatedConsumer(Consumer<Tuple2<ResultPartition, Integer>> notifySubpartitionCreatedConsumer) {
            this.notifySubpartitionCreatedConsumer = notifySubpartitionCreatedConsumer;
            return this;
        }

        public TestingSubpartitionCreatedViewReader build() {
            return new TestingSubpartitionCreatedViewReader(this.receiverId, this.partitionRequestListenerTimeoutConsumer, this.notifySubpartitionCreatedConsumer);
        }
    }
}

