/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.heartbeat;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.heartbeat.HeartbeatListener;
import org.apache.flink.runtime.heartbeat.HeartbeatManager;
import org.apache.flink.runtime.heartbeat.HeartbeatManagerImpl;
import org.apache.flink.runtime.heartbeat.HeartbeatManagerSenderImpl;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.heartbeat.HeartbeatTarget;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.slf4j.Logger;

public final class RecordingHeartbeatServices
implements HeartbeatServices {
    private final BlockingQueue<ResourceID> unmonitoredTargets;
    private final BlockingQueue<ResourceID> monitoredTargets;
    private final long heartbeatInterval;
    private final long heartbeatTimeout;

    public RecordingHeartbeatServices(long heartbeatInterval, long heartbeatTimeout) {
        this.heartbeatInterval = heartbeatInterval;
        this.heartbeatTimeout = heartbeatTimeout;
        this.unmonitoredTargets = new ArrayBlockingQueue<ResourceID>(1);
        this.monitoredTargets = new ArrayBlockingQueue<ResourceID>(1);
    }

    public <I, O> HeartbeatManager<I, O> createHeartbeatManager(ResourceID resourceId, HeartbeatListener<I, O> heartbeatListener, ScheduledExecutor mainThreadExecutor, Logger log) {
        return new RecordingHeartbeatManagerImpl<I, O>(this.heartbeatTimeout, -1, resourceId, heartbeatListener, mainThreadExecutor, log, this.unmonitoredTargets, this.monitoredTargets);
    }

    public <I, O> HeartbeatManager<I, O> createHeartbeatManagerSender(ResourceID resourceId, HeartbeatListener<I, O> heartbeatListener, ScheduledExecutor mainThreadExecutor, Logger log) {
        return new HeartbeatManagerSenderImpl(this.heartbeatInterval, this.heartbeatTimeout, -1, resourceId, heartbeatListener, mainThreadExecutor, log);
    }

    public BlockingQueue<ResourceID> getUnmonitoredTargets() {
        return this.unmonitoredTargets;
    }

    public BlockingQueue<ResourceID> getMonitoredTargets() {
        return this.monitoredTargets;
    }

    private static final class RecordingHeartbeatManagerImpl<I, O>
    extends HeartbeatManagerImpl<I, O> {
        private final BlockingQueue<ResourceID> unmonitoredTargets;
        private final BlockingQueue<ResourceID> monitoredTargets;

        public RecordingHeartbeatManagerImpl(long heartbeatTimeoutIntervalMs, int failedRpcRequestsUntilUnreachable, ResourceID ownResourceID, HeartbeatListener<I, O> heartbeatListener, ScheduledExecutor mainThreadExecutor, Logger log, BlockingQueue<ResourceID> unmonitoredTargets, BlockingQueue<ResourceID> monitoredTargets) {
            super(heartbeatTimeoutIntervalMs, failedRpcRequestsUntilUnreachable, ownResourceID, heartbeatListener, mainThreadExecutor, log);
            this.unmonitoredTargets = unmonitoredTargets;
            this.monitoredTargets = monitoredTargets;
        }

        public void unmonitorTarget(ResourceID resourceID) {
            super.unmonitorTarget(resourceID);
            this.unmonitoredTargets.offer(resourceID);
        }

        public void monitorTarget(ResourceID resourceID, HeartbeatTarget<O> heartbeatTarget) {
            super.monitorTarget(resourceID, heartbeatTarget);
            this.monitoredTargets.offer(resourceID);
        }
    }
}

