/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.entrypoint;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.flink.runtime.entrypoint.WorkingDirectory;
import org.apache.flink.util.TestLoggerExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={TestLoggerExtension.class})
public class WorkingDirectoryTest {
    @Test
    public void testTmpDirectoryIsCleanedUp(@TempDir File directory) throws IOException {
        WorkingDirectory workingDirectory = WorkingDirectory.create((File)directory);
        File tmpDirectory = workingDirectory.getTmpDirectory();
        Assertions.assertThat((File)tmpDirectory).isEmptyDirectory();
        File tmpFile = new File(tmpDirectory, "foobar");
        Files.createFile(tmpFile.toPath(), new FileAttribute[0]);
        Assertions.assertThat((File)tmpFile).exists();
        WorkingDirectory newWorkingDirectory = WorkingDirectory.create((File)directory);
        tmpDirectory = newWorkingDirectory.getTmpDirectory();
        Assertions.assertThat((Object[])tmpDirectory.list()).isEmpty();
    }
}

