/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.dispatcher.ExecutionGraphInfoStoreTestUtils;
import org.apache.flink.runtime.dispatcher.MemoryExecutionGraphInfoStore;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.messages.webmonitor.JobDetails;
import org.apache.flink.runtime.messages.webmonitor.JobsOverview;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedExecutionGraphBuilder;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;
import org.apache.flink.runtime.util.ManualTicker;
import org.apache.flink.shaded.guava31.com.google.common.base.Ticker;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.testutils.executor.TestExecutorResource;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.ManuallyTriggeredScheduledExecutor;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.apache.flink.util.concurrent.ScheduledExecutorServiceAdapter;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class MemoryExecutionGraphInfoStoreTest
extends TestLogger {
    @ClassRule
    public static final TestExecutorResource<ScheduledExecutorService> EXECUTOR_RESOURCE = TestingUtils.defaultExecutorResource();

    @Test
    public void testPut() throws IOException {
        this.assertPutJobGraphWithStatus(JobStatus.FINISHED);
    }

    @Test
    public void testPutSuspendedJob() throws IOException {
        this.assertPutJobGraphWithStatus(JobStatus.SUSPENDED);
    }

    @Test
    public void testUnknownGet() throws IOException {
        try (MemoryExecutionGraphInfoStore executionGraphStore = this.createMemoryExecutionGraphInfoStore();){
            Assert.assertThat((Object)executionGraphStore.get(new JobID()), (Matcher)Matchers.nullValue());
        }
    }

    @Test
    public void testStoredJobsOverview() throws IOException {
        int numberExecutionGraphs = 10;
        Collection<ExecutionGraphInfo> executionGraphInfos = ExecutionGraphInfoStoreTestUtils.generateTerminalExecutionGraphInfos(10);
        List jobStatuses = executionGraphInfos.stream().map(ExecutionGraphInfo::getArchivedExecutionGraph).map(ArchivedExecutionGraph::getState).collect(Collectors.toList());
        JobsOverview expectedJobsOverview = JobsOverview.create(jobStatuses);
        try (MemoryExecutionGraphInfoStore executionGraphInfoStore = this.createMemoryExecutionGraphInfoStore();){
            for (ExecutionGraphInfo executionGraphInfo : executionGraphInfos) {
                executionGraphInfoStore.put(executionGraphInfo);
            }
            Assert.assertThat((Object)executionGraphInfoStore.getStoredJobsOverview(), (Matcher)Matchers.equalTo((Object)expectedJobsOverview));
        }
    }

    @Test
    public void testAvailableJobDetails() throws IOException {
        int numberExecutionGraphs = 10;
        Collection<ExecutionGraphInfo> executionGraphInfos = ExecutionGraphInfoStoreTestUtils.generateTerminalExecutionGraphInfos(10);
        Collection<JobDetails> jobDetails = ExecutionGraphInfoStoreTestUtils.generateJobDetails(executionGraphInfos);
        try (MemoryExecutionGraphInfoStore executionGraphInfoStore = this.createMemoryExecutionGraphInfoStore();){
            for (ExecutionGraphInfo executionGraphInfo : executionGraphInfos) {
                executionGraphInfoStore.put(executionGraphInfo);
            }
            Assert.assertThat((Object)executionGraphInfoStore.getAvailableJobDetails(), (Matcher)Matchers.containsInAnyOrder((Object[])jobDetails.toArray()));
        }
    }

    @Test
    public void testExecutionGraphExpiration() throws Exception {
        Time expirationTime = Time.milliseconds((long)1L);
        ManuallyTriggeredScheduledExecutor scheduledExecutor = new ManuallyTriggeredScheduledExecutor();
        ManualTicker manualTicker = new ManualTicker();
        try (MemoryExecutionGraphInfoStore executionGraphInfoStore = new MemoryExecutionGraphInfoStore(expirationTime, Integer.MAX_VALUE, (ScheduledExecutor)scheduledExecutor, (Ticker)manualTicker);){
            ExecutionGraphInfo executionGraphInfo = new ExecutionGraphInfo(new ArchivedExecutionGraphBuilder().setState(JobStatus.FINISHED).build());
            executionGraphInfoStore.put(executionGraphInfo);
            Assert.assertThat((Object)executionGraphInfoStore.size(), (Matcher)Matchers.equalTo((Object)1));
            manualTicker.advanceTime(expirationTime.toMilliseconds(), TimeUnit.MILLISECONDS);
            scheduledExecutor.triggerScheduledTasks();
            Assert.assertThat((Object)executionGraphInfoStore.size(), (Matcher)Matchers.equalTo((Object)0));
            Assert.assertThat((Object)executionGraphInfoStore.get(executionGraphInfo.getJobId()), (Matcher)Matchers.nullValue());
            Assert.assertThat((Object)executionGraphInfoStore.size(), (Matcher)Matchers.equalTo((Object)0));
        }
    }

    @Test
    public void testCloseCleansUp() throws IOException {
        try (MemoryExecutionGraphInfoStore executionGraphInfoStore = this.createMemoryExecutionGraphInfoStore();){
            Assert.assertThat((Object)executionGraphInfoStore.size(), (Matcher)Matchers.equalTo((Object)0));
            executionGraphInfoStore.put(new ExecutionGraphInfo(new ArchivedExecutionGraphBuilder().setState(JobStatus.FINISHED).build()));
            Assert.assertThat((Object)executionGraphInfoStore.size(), (Matcher)Matchers.equalTo((Object)1));
            executionGraphInfoStore.close();
            Assert.assertThat((Object)executionGraphInfoStore.size(), (Matcher)Matchers.equalTo((Object)0));
        }
    }

    @Test
    public void testMaximumCapacity() throws IOException {
        int maxCapacity = 10;
        int numberExecutionGraphs = 10;
        Collection<ExecutionGraphInfo> oldExecutionGraphInfos = ExecutionGraphInfoStoreTestUtils.generateTerminalExecutionGraphInfos(10);
        Collection<ExecutionGraphInfo> newExecutionGraphInfos = ExecutionGraphInfoStoreTestUtils.generateTerminalExecutionGraphInfos(10);
        Collection<JobDetails> jobDetails = ExecutionGraphInfoStoreTestUtils.generateJobDetails(newExecutionGraphInfos);
        try (MemoryExecutionGraphInfoStore executionGraphInfoStore = this.createMemoryExecutionGraphInfoStore(Time.hours((long)1L), 10);){
            for (ExecutionGraphInfo executionGraphInfo : oldExecutionGraphInfos) {
                executionGraphInfoStore.put(executionGraphInfo);
                Assert.assertTrue((executionGraphInfoStore.size() <= 10 ? 1 : 0) != 0);
            }
            for (ExecutionGraphInfo executionGraphInfo : newExecutionGraphInfos) {
                executionGraphInfoStore.put(executionGraphInfo);
                Assert.assertEquals((long)10L, (long)executionGraphInfoStore.size());
            }
            Assert.assertThat((Object)executionGraphInfoStore.getAvailableJobDetails(), (Matcher)Matchers.containsInAnyOrder((Object[])jobDetails.toArray()));
        }
    }

    private void assertPutJobGraphWithStatus(JobStatus jobStatus) throws IOException {
        ExecutionGraphInfo dummyExecutionGraphInfo = new ExecutionGraphInfo(new ArchivedExecutionGraphBuilder().setState(jobStatus).build());
        try (MemoryExecutionGraphInfoStore executionGraphStore = this.createMemoryExecutionGraphInfoStore();){
            Assert.assertThat((Object)executionGraphStore.size(), (Matcher)Matchers.equalTo((Object)0));
            executionGraphStore.put(dummyExecutionGraphInfo);
            Assert.assertThat((Object)executionGraphStore.size(), (Matcher)Matchers.equalTo((Object)1));
            Assert.assertThat((Object)executionGraphStore.get(dummyExecutionGraphInfo.getJobId()), (Matcher)new ExecutionGraphInfoStoreTestUtils.PartialExecutionGraphInfoMatcher(dummyExecutionGraphInfo));
        }
    }

    private MemoryExecutionGraphInfoStore createMemoryExecutionGraphInfoStore() {
        return new MemoryExecutionGraphInfoStore();
    }

    private MemoryExecutionGraphInfoStore createMemoryExecutionGraphInfoStore(Time expirationTime, int maximumCapacity) {
        return new MemoryExecutionGraphInfoStore(expirationTime, maximumCapacity, (ScheduledExecutor)new ScheduledExecutorServiceAdapter((ScheduledExecutorService)EXECUTOR_RESOURCE.getExecutor()), Ticker.systemTicker());
    }
}

