/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.metadata;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.checkpoint.FinishedOperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.FullyFinishedOperatorState;
import org.apache.flink.runtime.checkpoint.MasterState;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.StateHandleDummyUtil;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.checkpoint.filemerging.LogicalFile;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.state.CheckpointedStateScope;
import org.apache.flink.runtime.state.DiscardRecordedStateObject;
import org.apache.flink.runtime.state.IncrementalKeyedStateHandle;
import org.apache.flink.runtime.state.IncrementalRemoteKeyedStateHandle;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyGroupRangeOffsets;
import org.apache.flink.runtime.state.KeyGroupsSavepointStateHandle;
import org.apache.flink.runtime.state.KeyGroupsStateHandle;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.OperatorStreamStateHandle;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.TestingRelativeFileStateHandle;
import org.apache.flink.runtime.state.TestingStreamStateHandle;
import org.apache.flink.runtime.state.filemerging.DirectoryStreamStateHandle;
import org.apache.flink.runtime.state.filemerging.EmptyFileMergingOperatorStreamStateHandle;
import org.apache.flink.runtime.state.filemerging.FileMergingOperatorStreamStateHandle;
import org.apache.flink.runtime.state.filemerging.SegmentFileStateHandle;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.apache.flink.util.StringUtils;
import org.assertj.core.api.Assertions;

public class CheckpointTestUtils {
    public static Collection<OperatorState> createOperatorStates(Random random, @Nullable String basePath, int numAllRunningTaskStates, int numPartlyFinishedTaskStates, int numFullyFinishedTaskStates, int numSubtasksPerTask) {
        OperatorState taskState;
        int stateIdx;
        ArrayList<OperatorState> taskStates = new ArrayList<OperatorState>(numAllRunningTaskStates + numPartlyFinishedTaskStates + numFullyFinishedTaskStates);
        for (stateIdx = 0; stateIdx < numAllRunningTaskStates; ++stateIdx) {
            taskState = new OperatorState(new OperatorID(), numSubtasksPerTask, 128);
            CheckpointTestUtils.randomlySetCoordinatorState(taskState, random);
            CheckpointTestUtils.randomlySetSubtaskState(taskState, IntStream.range(0, numSubtasksPerTask).toArray(), random, basePath);
            taskStates.add(taskState);
        }
        for (stateIdx = 0; stateIdx < numPartlyFinishedTaskStates; ++stateIdx) {
            taskState = new OperatorState(new OperatorID(), numSubtasksPerTask, 128);
            CheckpointTestUtils.randomlySetCoordinatorState(taskState, random);
            CheckpointTestUtils.randomlySetSubtaskState(taskState, IntStream.range(0, numSubtasksPerTask / 2).toArray(), random, basePath);
            IntStream.range(numSubtasksPerTask / 2, numSubtasksPerTask).forEach(index -> taskState.putState(index, (OperatorSubtaskState)FinishedOperatorSubtaskState.INSTANCE));
            taskStates.add(taskState);
        }
        for (stateIdx = 0; stateIdx < numFullyFinishedTaskStates; ++stateIdx) {
            taskStates.add((OperatorState)new FullyFinishedOperatorState(new OperatorID(), numSubtasksPerTask, 128));
        }
        return taskStates;
    }

    private static void randomlySetCoordinatorState(OperatorState taskState, Random random) {
        boolean hasCoordinatorState = random.nextBoolean();
        if (hasCoordinatorState) {
            ByteStreamStateHandle stateHandle = CheckpointTestUtils.createDummyByteStreamStreamStateHandle(random);
            taskState.setCoordinatorState(stateHandle);
        }
    }

    private static void randomlySetSubtaskState(OperatorState taskState, int[] subtasksToSet, Random random, String basePath) {
        boolean hasOperatorStateBackend = random.nextBoolean();
        boolean hasOperatorStateStream = random.nextBoolean();
        boolean hasKeyedBackend = random.nextInt(4) != 0;
        boolean hasKeyedStream = random.nextInt(4) != 0;
        boolean isIncremental = random.nextInt(3) == 0;
        for (int subtaskIdx : subtasksToSet) {
            Object stateHandle;
            OperatorSubtaskState.Builder state = OperatorSubtaskState.builder();
            if (hasOperatorStateBackend) {
                state.setManagedOperatorState((OperatorStateHandle)CheckpointTestUtils.createDummyOperatorStreamStateHandle(random));
            }
            if (hasOperatorStateStream) {
                state.setRawOperatorState((OperatorStateHandle)CheckpointTestUtils.createDummyOperatorStreamStateHandle(random));
            }
            if (hasKeyedBackend) {
                stateHandle = CheckpointTestUtils.isSavepoint(basePath) ? CheckpointTestUtils.createDummyKeyGroupSavepointStateHandle(random, basePath) : (isIncremental ? CheckpointTestUtils.createDummyIncrementalKeyedStateHandle(random) : CheckpointTestUtils.createDummyKeyGroupStateHandle(random, null));
                state.setRawKeyedState((KeyedStateHandle)stateHandle);
            }
            if (hasKeyedStream) {
                stateHandle = CheckpointTestUtils.isSavepoint(basePath) ? CheckpointTestUtils.createDummyKeyGroupSavepointStateHandle(random, basePath) : CheckpointTestUtils.createDummyKeyGroupStateHandle(random, null);
                state.setManagedKeyedState((KeyedStateHandle)stateHandle);
            }
            state.setInputChannelState(random.nextBoolean() && !CheckpointTestUtils.isSavepoint(basePath) ? StateObjectCollection.singleton((StateObject)StateHandleDummyUtil.createNewInputChannelStateHandle(random.nextInt(5), random)) : StateObjectCollection.empty());
            state.setResultSubpartitionState(random.nextBoolean() && !CheckpointTestUtils.isSavepoint(basePath) ? StateObjectCollection.singleton((StateObject)StateHandleDummyUtil.createNewResultSubpartitionStateHandle(random.nextInt(5), random)) : StateObjectCollection.empty());
            taskState.putState(subtaskIdx, state.build());
        }
    }

    private static OperatorStreamStateHandle createDummyOperatorStreamStateHandle(Random rnd) {
        HashMap<String, OperatorStateHandle.StateMetaInfo> offsetsMap = new HashMap<String, OperatorStateHandle.StateMetaInfo>();
        offsetsMap.put("A", new OperatorStateHandle.StateMetaInfo(new long[]{0L, 10L, 20L}, OperatorStateHandle.Mode.SPLIT_DISTRIBUTE));
        offsetsMap.put("B", new OperatorStateHandle.StateMetaInfo(new long[]{30L, 40L, 50L}, OperatorStateHandle.Mode.SPLIT_DISTRIBUTE));
        offsetsMap.put("C", new OperatorStateHandle.StateMetaInfo(new long[]{60L, 70L, 80L}, OperatorStateHandle.Mode.UNION));
        boolean enableFileMerging = rnd.nextBoolean();
        if (enableFileMerging) {
            DirectoryStreamStateHandle taskOwnedDirHandle = DirectoryStreamStateHandle.forPathWithZeroSize((java.nio.file.Path)new File(String.valueOf(CheckpointTestUtils.createRandomUUID(rnd))).toPath());
            DirectoryStreamStateHandle sharedDirHandle = DirectoryStreamStateHandle.forPathWithZeroSize((java.nio.file.Path)new File(String.valueOf(CheckpointTestUtils.createRandomUUID(rnd))).toPath());
            return rnd.nextBoolean() ? new FileMergingOperatorStreamStateHandle(taskOwnedDirHandle, sharedDirHandle, offsetsMap, CheckpointTestUtils.createDummySegmentFileStateHandle(rnd, false)) : EmptyFileMergingOperatorStreamStateHandle.create((DirectoryStreamStateHandle)taskOwnedDirHandle, (DirectoryStreamStateHandle)sharedDirHandle);
        }
        ByteStreamStateHandle operatorStateStream = new ByteStreamStateHandle("b", "Beautiful".getBytes(ConfigConstants.DEFAULT_CHARSET));
        return new OperatorStreamStateHandle(offsetsMap, (StreamStateHandle)operatorStateStream);
    }

    private static boolean isSavepoint(String basePath) {
        return basePath != null;
    }

    public static Collection<MasterState> createRandomMasterStates(Random random, int num) {
        ArrayList<MasterState> states = new ArrayList<MasterState>(num);
        for (int i = 0; i < num; ++i) {
            int version = random.nextInt(10);
            String name = StringUtils.getRandomString((Random)random, (int)5, (int)500);
            byte[] bytes = new byte[random.nextInt(5000) + 1];
            random.nextBytes(bytes);
            states.add(new MasterState(name, bytes, version));
        }
        return states;
    }

    public static void assertMasterStateEquality(MasterState a, MasterState b) {
        Assertions.assertThat((int)b.version()).isEqualTo(a.version());
        Assertions.assertThat((String)b.name()).isEqualTo(a.name());
        Assertions.assertThat((byte[])b.bytes()).isEqualTo((Object)a.bytes());
    }

    private CheckpointTestUtils() {
    }

    public static IncrementalRemoteKeyedStateHandle createDummyIncrementalKeyedStateHandle(Random rnd) {
        return CheckpointTestUtils.createDummyIncrementalKeyedStateHandle(42L, rnd);
    }

    public static IncrementalRemoteKeyedStateHandle createDummyIncrementalKeyedStateHandle(long checkpointId, Random rnd) {
        return new IncrementalRemoteKeyedStateHandle(CheckpointTestUtils.createRandomUUID(rnd), new KeyGroupRange(1, 1), checkpointId, CheckpointTestUtils.createRandomHandleAndLocalPathList(rnd), CheckpointTestUtils.createRandomHandleAndLocalPathList(rnd), CheckpointTestUtils.createDummyStreamStateHandle(rnd, null));
    }

    public static List<IncrementalKeyedStateHandle.HandleAndLocalPath> createRandomHandleAndLocalPathList(Random rnd) {
        boolean enableFileMerging = rnd.nextBoolean();
        int size = rnd.nextInt(4);
        ArrayList<IncrementalKeyedStateHandle.HandleAndLocalPath> result = new ArrayList<IncrementalKeyedStateHandle.HandleAndLocalPath>(size);
        for (int i = 0; i < size; ++i) {
            String localPath = CheckpointTestUtils.createRandomUUID(rnd).toString();
            StreamStateHandle stateHandle = enableFileMerging ? CheckpointTestUtils.createDummySegmentFileStateHandle(rnd) : CheckpointTestUtils.createDummyStreamStateHandle(rnd, null);
            result.add(IncrementalKeyedStateHandle.HandleAndLocalPath.of((StreamStateHandle)stateHandle, (String)localPath));
        }
        return result;
    }

    public static KeyGroupsStateHandle createDummyKeyGroupSavepointStateHandle(Random rnd, String basePath) {
        return new KeyGroupsSavepointStateHandle(new KeyGroupRangeOffsets(1, 1, new long[]{rnd.nextInt(1024)}), CheckpointTestUtils.createDummyStreamStateHandle(rnd, basePath));
    }

    public static KeyGroupsStateHandle createDummyKeyGroupStateHandle(Random rnd, String basePath) {
        return new KeyGroupsStateHandle(new KeyGroupRangeOffsets(1, 1, new long[]{rnd.nextInt(1024)}), CheckpointTestUtils.createDummyStreamStateHandle(rnd, basePath));
    }

    public static ByteStreamStateHandle createDummyByteStreamStreamStateHandle(Random rnd) {
        return (ByteStreamStateHandle)CheckpointTestUtils.createDummyStreamStateHandle(rnd, null);
    }

    public static StreamStateHandle createDummyStreamStateHandle(Random rnd, @Nullable String basePath) {
        if (!CheckpointTestUtils.isSavepoint(basePath)) {
            String stateId = String.valueOf(CheckpointTestUtils.createRandomUUID(rnd));
            byte[] stateContent = stateId.getBytes(StandardCharsets.UTF_8);
            return new TestingStreamStateHandle(stateId, stateContent);
        }
        long stateSize = rnd.nextLong();
        if (stateSize <= 0L) {
            stateSize = -stateSize;
        }
        String relativePath = String.valueOf(CheckpointTestUtils.createRandomUUID(rnd));
        Path statePath = new Path(basePath, relativePath);
        return new TestingRelativeFileStateHandle(statePath, relativePath, stateSize);
    }

    private static StreamStateHandle createDummySegmentFileStateHandle(Random rnd) {
        return CheckpointTestUtils.createDummySegmentFileStateHandle(rnd, rnd.nextBoolean());
    }

    private static StreamStateHandle createDummySegmentFileStateHandle(Random rnd, boolean isEmpty) {
        return isEmpty ? TestingSegmentFileStateHandle.EMPTY_INSTANCE : new TestingSegmentFileStateHandle(new Path(String.valueOf(CheckpointTestUtils.createRandomUUID(rnd))), 0L, 1L, CheckpointedStateScope.SHARED);
    }

    private static UUID createRandomUUID(Random rnd) {
        return new UUID(rnd.nextLong(), rnd.nextLong());
    }

    private static class TestingSegmentFileStateHandle
    extends SegmentFileStateHandle
    implements DiscardRecordedStateObject {
        private static final long serialVersionUID = 1L;
        private static final TestingSegmentFileStateHandle EMPTY_INSTANCE = new TestingSegmentFileStateHandle(new Path("empty"), 0L, 0L, CheckpointedStateScope.EXCLUSIVE);
        private boolean disposed;

        public TestingSegmentFileStateHandle(Path filePath, long startPos, long stateSize, CheckpointedStateScope scope) {
            super(filePath, startPos, stateSize, scope, LogicalFile.LogicalFileId.generateRandomId());
        }

        public void collectSizeStats(StateObject.StateObjectSizeStatsCollector collector) {
            collector.add(StateObject.StateObjectLocation.LOCAL_MEMORY, this.getStateSize());
        }

        public void discardState() {
            super.discardState();
            this.disposed = true;
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }
    }
}

