/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.filemerging;

import java.io.IOException;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.runtime.checkpoint.filemerging.FileMergingSnapshotManager;
import org.apache.flink.runtime.checkpoint.filemerging.FileMergingSnapshotManagerBase;
import org.apache.flink.runtime.checkpoint.filemerging.FileMergingSnapshotManagerTestBase;
import org.apache.flink.runtime.checkpoint.filemerging.FileMergingType;
import org.apache.flink.runtime.checkpoint.filemerging.PhysicalFile;
import org.apache.flink.runtime.state.CheckpointedStateScope;
import org.apache.flink.runtime.state.filemerging.SegmentFileStateHandle;
import org.apache.flink.runtime.state.filesystem.FileMergingCheckpointStateOutputStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class WithinCheckpointFileMergingSnapshotManagerTest
extends FileMergingSnapshotManagerTestBase {
    @Override
    FileMergingType getFileMergingType() {
        return FileMergingType.MERGE_WITHIN_CHECKPOINT;
    }

    @Test
    void testCreateAndReuseFiles() throws IOException {
        try (FileMergingSnapshotManagerBase fmsm = (FileMergingSnapshotManagerBase)this.createFileMergingSnapshotManager(this.checkpointBaseDir);){
            fmsm.registerSubtaskForSharedStates(this.subtaskKey1);
            fmsm.registerSubtaskForSharedStates(this.subtaskKey2);
            PhysicalFile file1 = fmsm.getOrCreatePhysicalFileForCheckpoint(this.subtaskKey1, 0L, CheckpointedStateScope.SHARED);
            Assertions.assertThat((Object)file1.getFilePath().getParent()).isEqualTo((Object)fmsm.getManagedDir(this.subtaskKey1, CheckpointedStateScope.SHARED));
            PhysicalFile file2 = fmsm.getOrCreatePhysicalFileForCheckpoint(this.subtaskKey1, 0L, CheckpointedStateScope.SHARED);
            Assertions.assertThat((Object)file2.getFilePath().getParent()).isEqualTo((Object)fmsm.getManagedDir(this.subtaskKey1, CheckpointedStateScope.SHARED));
            Assertions.assertThat((Object)file2).isNotEqualTo((Object)file1);
            fmsm.returnPhysicalFileForNextReuse(this.subtaskKey1, 0L, file1);
            PhysicalFile file3 = fmsm.getOrCreatePhysicalFileForCheckpoint(this.subtaskKey2, 0L, CheckpointedStateScope.SHARED);
            Assertions.assertThat((Object)file3.getFilePath().getParent()).isEqualTo((Object)fmsm.getManagedDir(this.subtaskKey2, CheckpointedStateScope.SHARED));
            Assertions.assertThat((Object)file3).isNotEqualTo((Object)file1);
            PhysicalFile file4 = fmsm.getOrCreatePhysicalFileForCheckpoint(this.subtaskKey1, 1L, CheckpointedStateScope.SHARED);
            Assertions.assertThat((Object)file4.getFilePath().getParent()).isEqualTo((Object)fmsm.getManagedDir(this.subtaskKey1, CheckpointedStateScope.SHARED));
            Assertions.assertThat((Object)file4).isNotEqualTo((Object)file1);
            PhysicalFile file5 = fmsm.getOrCreatePhysicalFileForCheckpoint(this.subtaskKey1, 0L, CheckpointedStateScope.SHARED);
            Assertions.assertThat((Object)file5.getFilePath().getParent()).isEqualTo((Object)fmsm.getManagedDir(this.subtaskKey1, CheckpointedStateScope.SHARED));
            Assertions.assertThat((Object)file5).isEqualTo((Object)file1);
            file5.incSize(fmsm.maxPhysicalFileSize);
            fmsm.returnPhysicalFileForNextReuse(this.subtaskKey1, 0L, file5);
            PhysicalFile file6 = fmsm.getOrCreatePhysicalFileForCheckpoint(this.subtaskKey1, 0L, CheckpointedStateScope.SHARED);
            Assertions.assertThat((Object)file6.getFilePath().getParent()).isEqualTo((Object)fmsm.getManagedDir(this.subtaskKey1, CheckpointedStateScope.SHARED));
            Assertions.assertThat((Object)file6).isNotEqualTo((Object)file5);
            PhysicalFile file7 = fmsm.getOrCreatePhysicalFileForCheckpoint(this.subtaskKey1, 0L, CheckpointedStateScope.EXCLUSIVE);
            Assertions.assertThat((Object)file7.getFilePath().getParent()).isEqualTo((Object)fmsm.getManagedDir(this.subtaskKey1, CheckpointedStateScope.EXCLUSIVE));
            PhysicalFile file8 = fmsm.getOrCreatePhysicalFileForCheckpoint(this.subtaskKey1, 0L, CheckpointedStateScope.EXCLUSIVE);
            Assertions.assertThat((Object)file8.getFilePath().getParent()).isEqualTo((Object)fmsm.getManagedDir(this.subtaskKey1, CheckpointedStateScope.EXCLUSIVE));
            Assertions.assertThat((Object)file8).isNotEqualTo((Object)file6);
            fmsm.returnPhysicalFileForNextReuse(this.subtaskKey1, 0L, file7);
            PhysicalFile file9 = fmsm.getOrCreatePhysicalFileForCheckpoint(this.subtaskKey1, 1L, CheckpointedStateScope.EXCLUSIVE);
            Assertions.assertThat((Object)file9.getFilePath().getParent()).isEqualTo((Object)fmsm.getManagedDir(this.subtaskKey1, CheckpointedStateScope.EXCLUSIVE));
            Assertions.assertThat((Object)file9).isNotEqualTo((Object)file7);
            PhysicalFile file10 = fmsm.getOrCreatePhysicalFileForCheckpoint(this.subtaskKey2, 0L, CheckpointedStateScope.EXCLUSIVE);
            Assertions.assertThat((Object)file10.getFilePath().getParent()).isEqualTo((Object)fmsm.getManagedDir(this.subtaskKey2, CheckpointedStateScope.EXCLUSIVE));
            Assertions.assertThat((Object)file10).isEqualTo((Object)file7);
            file10.incSize(fmsm.maxPhysicalFileSize);
            fmsm.returnPhysicalFileForNextReuse(this.subtaskKey1, 0L, file10);
            PhysicalFile file11 = fmsm.getOrCreatePhysicalFileForCheckpoint(this.subtaskKey1, 0L, CheckpointedStateScope.SHARED);
            Assertions.assertThat((Object)file11.getFilePath().getParent()).isEqualTo((Object)fmsm.getManagedDir(this.subtaskKey1, CheckpointedStateScope.SHARED));
            Assertions.assertThat((Object)file11).isNotEqualTo((Object)file10);
            Assertions.assertThat((Object)fmsm.getManagedDir(this.subtaskKey2, CheckpointedStateScope.EXCLUSIVE)).isEqualTo((Object)fmsm.getManagedDir(this.subtaskKey1, CheckpointedStateScope.EXCLUSIVE));
        }
    }

    @Test
    public void testCheckpointNotification() throws Exception {
        try (FileMergingSnapshotManager fmsm = this.createFileMergingSnapshotManager(this.checkpointBaseDir);
             CloseableRegistry closeableRegistry = new CloseableRegistry();){
            FileMergingCheckpointStateOutputStream cp1Stream = this.writeCheckpointAndGetStream(1L, fmsm, closeableRegistry);
            SegmentFileStateHandle cp1StateHandle = cp1Stream.closeAndGetHandle();
            fmsm.notifyCheckpointComplete(this.subtaskKey1, 1L);
            this.assertFileInManagedDir(fmsm, cp1StateHandle);
            FileMergingCheckpointStateOutputStream cp2Stream = this.writeCheckpointAndGetStream(2L, fmsm, closeableRegistry);
            SegmentFileStateHandle cp2StateHandle = cp2Stream.closeAndGetHandle();
            fmsm.notifyCheckpointComplete(this.subtaskKey1, 2L);
            this.assertFileInManagedDir(fmsm, cp2StateHandle);
            Assertions.assertThat((boolean)this.fileExists(cp1StateHandle)).isTrue();
            fmsm.notifyCheckpointSubsumed(this.subtaskKey1, 1L);
            Assertions.assertThat((boolean)this.fileExists(cp1StateHandle)).isFalse();
            FileMergingCheckpointStateOutputStream cp3Stream = this.writeCheckpointAndGetStream(3L, fmsm, closeableRegistry);
            SegmentFileStateHandle cp3StateHandle = cp3Stream.closeAndGetHandle();
            this.assertFileInManagedDir(fmsm, cp3StateHandle);
            fmsm.notifyCheckpointAborted(this.subtaskKey1, 3L);
            Assertions.assertThat((boolean)this.fileExists(cp3StateHandle)).isFalse();
        }
    }
}

