/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing;

import java.util.ArrayList;
import org.apache.flink.runtime.asyncprocessing.ReferenceCounted;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;

class ReferenceCountedTest {
    ReferenceCountedTest() {
    }

    @Test
    void testRefCountReachedZero() {
        TestReferenceCounted referenceCounted = new TestReferenceCounted();
        referenceCounted.retain();
        AssertionsForClassTypes.assertThat((int)referenceCounted.getReferenceCount()).isEqualTo(1);
        referenceCounted.release();
        AssertionsForClassTypes.assertThat((int)referenceCounted.getReferenceCount()).isEqualTo(0);
        AssertionsForClassTypes.assertThat((boolean)referenceCounted.reachedZero).isTrue();
    }

    @Test
    void testConcurrency() throws InterruptedException {
        Thread thread2;
        int i;
        TestReferenceCounted referenceCounted = new TestReferenceCounted();
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (i = 0; i < 5; ++i) {
            thread2 = new Thread(() -> ((TestReferenceCounted)referenceCounted).retain());
            thread2.start();
            threads.add(thread2);
        }
        for (i = 0; i < 5; ++i) {
            thread2 = new Thread(() -> ((TestReferenceCounted)referenceCounted).release());
            thread2.start();
            threads.add(thread2);
        }
        for (Thread thread2 : threads) {
            thread2.join();
        }
        AssertionsForClassTypes.assertThat((int)referenceCounted.getReferenceCount()).isEqualTo(0);
    }

    private static class TestReferenceCounted
    extends ReferenceCounted {
        private boolean reachedZero = false;

        public TestReferenceCounted() {
            super(0);
        }

        protected void referenceCountReachedZero() {
            this.reachedZero = true;
        }
    }
}

