/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils;

import java.time.Duration;
import java.util.HashMap;
import org.apache.curator.test.InstanceSpec;
import org.apache.curator.test.TestingServer;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.configuration.RpcOptions;
import org.apache.flink.configuration.StateBackendOptions;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperTestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperTestUtils.class);

    public static TestingServer createAndStartZookeeperTestingServer() throws Exception {
        return new TestingServer(ZooKeeperTestUtils.getZookeeperInstanceSpecWithIncreasedSessionTimeout(), true);
    }

    private static InstanceSpec getZookeeperInstanceSpecWithIncreasedSessionTimeout() {
        InstanceSpec instanceSpec = InstanceSpec.newInstanceSpec();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("maxSessionTimeout", "60000");
        boolean deleteDataDirectoryOnClose = true;
        return new InstanceSpec(instanceSpec.getDataDirectory(), instanceSpec.getPort(), instanceSpec.getElectionPort(), instanceSpec.getQuorumPort(), true, instanceSpec.getServerId(), instanceSpec.getTickTime(), instanceSpec.getMaxClientCnxns(), properties, instanceSpec.getHostname());
    }

    public static Configuration createZooKeeperHAConfig(String zooKeeperQuorum, String fsStateHandlePath) {
        return ZooKeeperTestUtils.configureZooKeeperHA(new Configuration(), zooKeeperQuorum, fsStateHandlePath);
    }

    public static Configuration configureZooKeeperHA(Configuration config, String zooKeeperQuorum, String fsStateHandlePath) {
        Preconditions.checkNotNull((Object)config, (String)"Configuration");
        Preconditions.checkNotNull((Object)zooKeeperQuorum, (String)"ZooKeeper quorum");
        Preconditions.checkNotNull((Object)fsStateHandlePath, (String)"File state handle backend path");
        config.set(HighAvailabilityOptions.HA_MODE, (Object)"ZOOKEEPER");
        config.set(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, (Object)zooKeeperQuorum);
        int connTimeout = 5000;
        if (ZooKeeperTestUtils.runsOnCIInfrastructure()) {
            LOG.info("Detected CI environment: Configuring connection and session timeout of 30 seconds");
            connTimeout = 30000;
        }
        config.set(HighAvailabilityOptions.ZOOKEEPER_CONNECTION_TIMEOUT, (Object)connTimeout);
        config.set(HighAvailabilityOptions.ZOOKEEPER_SESSION_TIMEOUT, (Object)connTimeout);
        config.set(StateBackendOptions.STATE_BACKEND, (Object)"FILESYSTEM");
        config.set(CheckpointingOptions.CHECKPOINTS_DIRECTORY, (Object)(fsStateHandlePath + "/checkpoints"));
        config.set(HighAvailabilityOptions.HA_STORAGE_PATH, (Object)(fsStateHandlePath + "/recovery"));
        config.set(RpcOptions.ASK_TIMEOUT_DURATION, (Object)Duration.ofSeconds(100L));
        return config;
    }

    public static boolean runsOnCIInfrastructure() {
        return System.getenv().containsKey("CI") || System.getenv().containsKey("TF_BUILD");
    }
}

