/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobResourceRequirements;
import org.apache.flink.runtime.jobmanager.JobGraphStore;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.function.BiConsumerWithException;
import org.apache.flink.util.function.BiFunctionWithException;
import org.apache.flink.util.function.FunctionWithException;
import org.apache.flink.util.function.ThrowingConsumer;
import org.apache.flink.util.function.ThrowingRunnable;

public class TestingJobGraphStore
implements JobGraphStore {
    private final Map<JobID, JobGraph> storedJobs = new HashMap<JobID, JobGraph>();
    private final ThrowingConsumer<JobGraphStore.JobGraphListener, ? extends Exception> startConsumer;
    private final ThrowingRunnable<? extends Exception> stopRunnable;
    private final FunctionWithException<Collection<JobID>, Collection<JobID>, ? extends Exception> jobIdsFunction;
    private final BiFunctionWithException<JobID, Map<JobID, JobGraph>, JobGraph, ? extends Exception> recoverJobGraphFunction;
    private final ThrowingConsumer<JobGraph, ? extends Exception> putJobGraphConsumer;
    private final BiConsumerWithException<JobGraph, JobResourceRequirements, ? extends Exception> putJobResourceRequirementsConsumer;
    private final BiFunction<JobID, Executor, CompletableFuture<Void>> globalCleanupFunction;
    private final BiFunction<JobID, Executor, CompletableFuture<Void>> localCleanupFunction;
    private boolean started;

    private TestingJobGraphStore(ThrowingConsumer<JobGraphStore.JobGraphListener, ? extends Exception> startConsumer, ThrowingRunnable<? extends Exception> stopRunnable, FunctionWithException<Collection<JobID>, Collection<JobID>, ? extends Exception> jobIdsFunction, BiFunctionWithException<JobID, Map<JobID, JobGraph>, JobGraph, ? extends Exception> recoverJobGraphFunction, ThrowingConsumer<JobGraph, ? extends Exception> putJobGraphConsumer, BiConsumerWithException<JobGraph, JobResourceRequirements, ? extends Exception> putJobResourceRequirementsConsumer, BiFunction<JobID, Executor, CompletableFuture<Void>> globalCleanupFunction, BiFunction<JobID, Executor, CompletableFuture<Void>> localCleanupFunction, Collection<JobGraph> initialJobGraphs) {
        this.startConsumer = startConsumer;
        this.stopRunnable = stopRunnable;
        this.jobIdsFunction = jobIdsFunction;
        this.recoverJobGraphFunction = recoverJobGraphFunction;
        this.putJobGraphConsumer = putJobGraphConsumer;
        this.putJobResourceRequirementsConsumer = putJobResourceRequirementsConsumer;
        this.globalCleanupFunction = globalCleanupFunction;
        this.localCleanupFunction = localCleanupFunction;
        for (JobGraph initialJobGraph : initialJobGraphs) {
            this.storedJobs.put(initialJobGraph.getJobID(), initialJobGraph);
        }
    }

    public synchronized void start(@Nullable JobGraphStore.JobGraphListener jobGraphListener) throws Exception {
        this.startConsumer.accept((Object)jobGraphListener);
        this.started = true;
    }

    public synchronized void stop() throws Exception {
        this.stopRunnable.run();
        this.started = false;
    }

    public synchronized JobGraph recoverJobGraph(JobID jobId) throws Exception {
        this.verifyIsStarted();
        return (JobGraph)this.recoverJobGraphFunction.apply((Object)jobId, this.storedJobs);
    }

    public synchronized void putJobGraph(JobGraph jobGraph) throws Exception {
        this.verifyIsStarted();
        this.putJobGraphConsumer.accept((Object)jobGraph);
        this.storedJobs.put(jobGraph.getJobID(), jobGraph);
    }

    public void putJobResourceRequirements(JobID jobId, JobResourceRequirements jobResourceRequirements) throws Exception {
        this.verifyIsStarted();
        JobGraph jobGraph = (JobGraph)Preconditions.checkNotNull((Object)this.storedJobs.get(jobId), (String)"Job [%s] not found.", (Object[])new Object[]{jobId});
        this.putJobResourceRequirementsConsumer.accept((Object)jobGraph, (Object)jobResourceRequirements);
    }

    public synchronized CompletableFuture<Void> globalCleanupAsync(JobID jobId, Executor executor) {
        this.verifyIsStarted();
        return this.globalCleanupFunction.apply(jobId, executor).thenRun(() -> this.storedJobs.remove(jobId));
    }

    public synchronized CompletableFuture<Void> localCleanupAsync(JobID jobId, Executor executor) {
        this.verifyIsStarted();
        return this.localCleanupFunction.apply(jobId, executor);
    }

    public synchronized Collection<JobID> getJobIds() throws Exception {
        this.verifyIsStarted();
        return (Collection)this.jobIdsFunction.apply(Collections.unmodifiableSet(new HashSet<JobID>(this.storedJobs.keySet())));
    }

    public synchronized boolean contains(JobID jobId) {
        return this.storedJobs.containsKey(jobId);
    }

    private void verifyIsStarted() {
        Preconditions.checkState((boolean)this.started, (Object)"Not running. Forgot to call start()?");
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private ThrowingConsumer<JobGraphStore.JobGraphListener, ? extends Exception> startConsumer = ignored -> {};
        private ThrowingRunnable<? extends Exception> stopRunnable = () -> {};
        private FunctionWithException<Collection<JobID>, Collection<JobID>, ? extends Exception> jobIdsFunction = jobIds -> jobIds;
        private BiFunctionWithException<JobID, Map<JobID, JobGraph>, JobGraph, ? extends Exception> recoverJobGraphFunction = (jobId, jobs) -> (JobGraph)jobs.get(jobId);
        private ThrowingConsumer<JobGraph, ? extends Exception> putJobGraphConsumer = ignored -> {};
        private BiConsumerWithException<JobGraph, JobResourceRequirements, ? extends Exception> putJobResourceRequirementsConsumer = (graph, requirements) -> {};
        private BiFunction<JobID, Executor, CompletableFuture<Void>> globalCleanupFunction = (ignoredJobId, ignoredExecutor) -> FutureUtils.completedVoidFuture();
        private BiFunction<JobID, Executor, CompletableFuture<Void>> localCleanupFunction = (ignoredJobId, ignoredExecutor) -> FutureUtils.completedVoidFuture();
        private Collection<JobGraph> initialJobGraphs = Collections.emptyList();
        private boolean startJobGraphStore = false;

        private Builder() {
        }

        public Builder setStartConsumer(ThrowingConsumer<JobGraphStore.JobGraphListener, ? extends Exception> startConsumer) {
            this.startConsumer = startConsumer;
            return this;
        }

        public Builder setStopRunnable(ThrowingRunnable<? extends Exception> stopRunnable) {
            this.stopRunnable = stopRunnable;
            return this;
        }

        public Builder setJobIdsFunction(FunctionWithException<Collection<JobID>, Collection<JobID>, ? extends Exception> jobIdsFunction) {
            this.jobIdsFunction = jobIdsFunction;
            return this;
        }

        public Builder setRecoverJobGraphFunction(BiFunctionWithException<JobID, Map<JobID, JobGraph>, JobGraph, ? extends Exception> recoverJobGraphFunction) {
            this.recoverJobGraphFunction = recoverJobGraphFunction;
            return this;
        }

        public Builder setPutJobGraphConsumer(ThrowingConsumer<JobGraph, ? extends Exception> putJobGraphConsumer) {
            this.putJobGraphConsumer = putJobGraphConsumer;
            return this;
        }

        public Builder setPutJobResourceRequirementsConsumer(BiConsumerWithException<JobGraph, JobResourceRequirements, ? extends Exception> putJobResourceRequirementsConsumer) {
            this.putJobResourceRequirementsConsumer = putJobResourceRequirementsConsumer;
            return this;
        }

        public Builder setGlobalCleanupFunction(BiFunction<JobID, Executor, CompletableFuture<Void>> globalCleanupFunction) {
            this.globalCleanupFunction = globalCleanupFunction;
            return this;
        }

        public Builder setLocalCleanupFunction(BiFunction<JobID, Executor, CompletableFuture<Void>> localCleanupFunction) {
            this.localCleanupFunction = localCleanupFunction;
            return this;
        }

        public Builder setInitialJobGraphs(Collection<JobGraph> initialJobGraphs) {
            this.initialJobGraphs = initialJobGraphs;
            return this;
        }

        public Builder withAutomaticStart() {
            this.startJobGraphStore = true;
            return this;
        }

        public TestingJobGraphStore build() {
            TestingJobGraphStore jobGraphStore = new TestingJobGraphStore(this.startConsumer, this.stopRunnable, this.jobIdsFunction, this.recoverJobGraphFunction, this.putJobGraphConsumer, this.putJobResourceRequirementsConsumer, this.globalCleanupFunction, this.localCleanupFunction, this.initialJobGraphs);
            if (this.startJobGraphStore) {
                try {
                    jobGraphStore.start(null);
                }
                catch (Exception e) {
                    ExceptionUtils.rethrow((Throwable)e);
                }
            }
            return jobGraphStore;
        }
    }
}

