/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor.slot;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.taskexecutor.SlotReport;
import org.apache.flink.runtime.taskexecutor.SlotStatus;
import org.apache.flink.runtime.taskexecutor.slot.SlotActions;
import org.apache.flink.runtime.taskexecutor.slot.SlotNotActiveException;
import org.apache.flink.runtime.taskexecutor.slot.SlotNotFoundException;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlot;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotPayload;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotTable;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotTableImpl;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotUtils;
import org.apache.flink.runtime.taskexecutor.slot.TestingSlotActions;
import org.apache.flink.runtime.taskexecutor.slot.TestingSlotActionsBuilder;
import org.apache.flink.runtime.taskexecutor.slot.TestingTaskSlotPayload;
import org.apache.flink.runtime.taskexecutor.slot.TestingTimerService;
import org.apache.flink.runtime.taskexecutor.slot.TestingTimerServiceBuilder;
import org.apache.flink.runtime.taskexecutor.slot.TimerService;
import org.apache.flink.shaded.guava31.com.google.common.collect.Sets;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.testutils.executor.TestExecutorExtension;
import org.apache.flink.util.function.TriFunctionWithException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.RegisterExtension;

class TaskSlotTableImplTest {
    @RegisterExtension
    private static final TestExecutorExtension<ScheduledExecutorService> EXECUTOR_EXTENSION = TestingUtils.defaultExecutorExtension();
    private static final Duration SLOT_TIMEOUT = Duration.ofSeconds(100L);

    TaskSlotTableImplTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testTryMarkSlotActive() throws Exception {
        TaskSlotTableImpl<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableAndStart(3);
        try {
            JobID jobId1 = new JobID();
            AllocationID allocationId1 = new AllocationID();
            taskSlotTable.allocateSlot(0, jobId1, allocationId1, SLOT_TIMEOUT);
            AllocationID allocationId2 = new AllocationID();
            taskSlotTable.allocateSlot(1, jobId1, allocationId2, SLOT_TIMEOUT);
            AllocationID allocationId3 = new AllocationID();
            JobID jobId2 = new JobID();
            taskSlotTable.allocateSlot(2, jobId2, allocationId3, SLOT_TIMEOUT);
            taskSlotTable.markSlotActive(allocationId1);
            Assertions.assertThat((boolean)taskSlotTable.isAllocated(0, jobId1, allocationId1)).isTrue();
            Assertions.assertThat((boolean)taskSlotTable.isAllocated(1, jobId1, allocationId2)).isTrue();
            Assertions.assertThat((boolean)taskSlotTable.isAllocated(2, jobId2, allocationId3)).isTrue();
            Assertions.assertThat((Collection)taskSlotTable.getActiveTaskSlotAllocationIdsPerJob(jobId1)).isEqualTo((Object)Sets.newHashSet((Object[])new AllocationID[]{allocationId1}));
            Assertions.assertThat((boolean)taskSlotTable.tryMarkSlotActive(jobId1, allocationId1)).isTrue();
            Assertions.assertThat((boolean)taskSlotTable.tryMarkSlotActive(jobId1, allocationId2)).isTrue();
            Assertions.assertThat((boolean)taskSlotTable.tryMarkSlotActive(jobId1, allocationId3)).isFalse();
            Assertions.assertThat((Collection)taskSlotTable.getActiveTaskSlotAllocationIdsPerJob(jobId1)).isEqualTo(new HashSet<AllocationID>(Arrays.asList(allocationId2, allocationId1)));
        }
        finally {
            taskSlotTable.close();
            Assertions.assertThat((boolean)taskSlotTable.isClosed()).isTrue();
        }
    }

    @Test
    void testRetrievingAllActiveSlots() throws Exception {
        try (TaskSlotTableImpl<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableAndStart(3);){
            JobID jobId1 = new JobID();
            AllocationID allocationId1 = new AllocationID();
            taskSlotTable.allocateSlot(0, jobId1, allocationId1, SLOT_TIMEOUT);
            AllocationID allocationId2 = new AllocationID();
            taskSlotTable.allocateSlot(1, jobId1, allocationId2, SLOT_TIMEOUT);
            AllocationID allocationId3 = new AllocationID();
            JobID jobId2 = new JobID();
            taskSlotTable.allocateSlot(2, jobId2, allocationId3, SLOT_TIMEOUT);
            taskSlotTable.markSlotActive(allocationId1);
            taskSlotTable.markSlotActive(allocationId3);
            Assertions.assertThat((Collection)taskSlotTable.getActiveTaskSlotAllocationIds()).isEqualTo((Object)Sets.newHashSet((Object[])new AllocationID[]{allocationId1, allocationId3}));
        }
    }

    @Test
    void testInconsistentStaticSlotAllocation() throws Exception {
        try (TaskSlotTableImpl<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableAndStart(2);){
            JobID jobId = new JobID();
            AllocationID allocationId1 = new AllocationID();
            AllocationID allocationId2 = new AllocationID();
            Assertions.assertThat((boolean)taskSlotTable.allocateSlot(0, jobId, allocationId1, SLOT_TIMEOUT)).isTrue();
            Assertions.assertThat((boolean)taskSlotTable.allocateSlot(1, jobId, allocationId1, SLOT_TIMEOUT)).isFalse();
            Assertions.assertThat((boolean)taskSlotTable.allocateSlot(0, jobId, allocationId2, SLOT_TIMEOUT)).isFalse();
            Assertions.assertThat((boolean)taskSlotTable.isAllocated(0, jobId, allocationId1)).isTrue();
            Assertions.assertThat((boolean)taskSlotTable.isSlotFree(1)).isTrue();
            Iterator allocatedSlots = taskSlotTable.getAllocatedSlots(jobId);
            Assertions.assertThat((int)((TaskSlot)allocatedSlots.next()).getIndex()).isZero();
            Assertions.assertThat((boolean)allocatedSlots.hasNext()).isFalse();
        }
    }

    @Test
    void testInconsistentDynamicSlotAllocation() throws Exception {
        try (TaskSlotTableImpl<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableAndStart(1);){
            JobID jobId1 = new JobID();
            JobID jobId2 = new JobID();
            AllocationID allocationId = new AllocationID();
            Assertions.assertThat((boolean)taskSlotTable.allocateSlot(-1, jobId1, allocationId, SLOT_TIMEOUT)).isTrue();
            Assertions.assertThat((boolean)taskSlotTable.allocateSlot(-1, jobId2, allocationId, SLOT_TIMEOUT)).isFalse();
            Assertions.assertThat((boolean)taskSlotTable.isAllocated(1, jobId1, allocationId)).isTrue();
            Iterator allocatedSlots = taskSlotTable.getAllocatedSlots(jobId1);
            Assertions.assertThat((Comparable)((TaskSlot)allocatedSlots.next()).getAllocationId()).isEqualTo((Object)allocationId);
            Assertions.assertThat((boolean)allocatedSlots.hasNext()).isFalse();
        }
    }

    @Test
    void testDuplicateStaticSlotAllocation() throws Exception {
        try (TaskSlotTableImpl<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableAndStart(2);){
            JobID jobId = new JobID();
            AllocationID allocationId = new AllocationID();
            Assertions.assertThat((boolean)taskSlotTable.allocateSlot(0, jobId, allocationId, ResourceProfile.UNKNOWN, SLOT_TIMEOUT)).isTrue();
            Assertions.assertThat((boolean)taskSlotTable.allocateSlot(0, jobId, allocationId, ResourceProfile.UNKNOWN, SLOT_TIMEOUT)).isTrue();
            Assertions.assertThat((boolean)taskSlotTable.isAllocated(0, jobId, allocationId)).isTrue();
            Assertions.assertThat((boolean)taskSlotTable.isSlotFree(1)).isTrue();
            Iterator allocatedSlots = taskSlotTable.getAllocatedSlots(jobId);
            Assertions.assertThat((int)((TaskSlot)allocatedSlots.next()).getIndex()).isZero();
            Assertions.assertThat((boolean)allocatedSlots.hasNext()).isFalse();
        }
    }

    @Test
    void testDuplicateDynamicSlotAllocation() throws Exception {
        try (TaskSlotTableImpl<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableAndStart(1);){
            JobID jobId = new JobID();
            AllocationID allocationId = new AllocationID();
            Assertions.assertThat((boolean)taskSlotTable.allocateSlot(-1, jobId, allocationId, SLOT_TIMEOUT)).isTrue();
            Iterator allocatedSlots = taskSlotTable.getAllocatedSlots(jobId);
            TaskSlot taskSlot1 = (TaskSlot)allocatedSlots.next();
            Assertions.assertThat((boolean)taskSlotTable.allocateSlot(-1, jobId, allocationId, SLOT_TIMEOUT)).isTrue();
            allocatedSlots = taskSlotTable.getAllocatedSlots(jobId);
            TaskSlot taskSlot2 = (TaskSlot)allocatedSlots.next();
            Assertions.assertThat((boolean)taskSlotTable.isAllocated(1, jobId, allocationId)).isTrue();
            Assertions.assertThat((Object)taskSlot2).isEqualTo((Object)taskSlot1);
            Assertions.assertThat((boolean)allocatedSlots.hasNext()).isFalse();
        }
    }

    @Test
    void testFreeSlot() throws Exception {
        try (TaskSlotTableImpl<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableAndStart(2);){
            JobID jobId = new JobID();
            AllocationID allocationId1 = new AllocationID();
            AllocationID allocationId2 = new AllocationID();
            Assertions.assertThat((boolean)taskSlotTable.allocateSlot(0, jobId, allocationId1, SLOT_TIMEOUT)).isTrue();
            Assertions.assertThat((boolean)taskSlotTable.allocateSlot(1, jobId, allocationId2, SLOT_TIMEOUT)).isTrue();
            Assertions.assertThat((int)taskSlotTable.freeSlot(allocationId2)).isOne();
            Iterator allocatedSlots = taskSlotTable.getAllocatedSlots(jobId);
            Assertions.assertThat((int)((TaskSlot)allocatedSlots.next()).getIndex()).isZero();
            Assertions.assertThat((boolean)allocatedSlots.hasNext()).isFalse();
            Assertions.assertThat((boolean)taskSlotTable.isAllocated(1, jobId, allocationId1)).isFalse();
            Assertions.assertThat((boolean)taskSlotTable.isAllocated(1, jobId, allocationId2)).isFalse();
            Assertions.assertThat((boolean)taskSlotTable.isSlotFree(1)).isTrue();
        }
    }

    @Test
    void testSlotAllocationWithDynamicSlotId() throws Exception {
        try (TaskSlotTableImpl<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableAndStart(2);){
            JobID jobId = new JobID();
            AllocationID allocationId = new AllocationID();
            Assertions.assertThat((boolean)taskSlotTable.allocateSlot(-1, jobId, allocationId, SLOT_TIMEOUT)).isTrue();
            Iterator allocatedSlots = taskSlotTable.getAllocatedSlots(jobId);
            Assertions.assertThat((int)((TaskSlot)allocatedSlots.next()).getIndex()).isEqualTo(2);
            Assertions.assertThat((boolean)allocatedSlots.hasNext()).isFalse();
            Assertions.assertThat((boolean)taskSlotTable.isAllocated(2, jobId, allocationId)).isTrue();
        }
    }

    @Test
    void testSlotAllocationWithConcreteResourceProfile() throws Exception {
        try (TaskSlotTableImpl<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableAndStart(2);){
            JobID jobId = new JobID();
            AllocationID allocationId = new AllocationID();
            ResourceProfile resourceProfile = TaskSlotUtils.DEFAULT_RESOURCE_PROFILE.merge(ResourceProfile.newBuilder().setCpuCores(0.1).build());
            Assertions.assertThat((boolean)taskSlotTable.allocateSlot(-1, jobId, allocationId, resourceProfile, SLOT_TIMEOUT)).isTrue();
            Iterator allocatedSlots = taskSlotTable.getAllocatedSlots(jobId);
            TaskSlot allocatedSlot = (TaskSlot)allocatedSlots.next();
            Assertions.assertThat((int)allocatedSlot.getIndex()).isEqualTo(2);
            Assertions.assertThat((Object)allocatedSlot.getResourceProfile()).isEqualTo((Object)resourceProfile);
            Assertions.assertThat((boolean)allocatedSlots.hasNext()).isFalse();
        }
    }

    @Test
    void testSlotAllocationWithUnknownResourceProfile() throws Exception {
        try (TaskSlotTableImpl<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableAndStart(2);){
            JobID jobId = new JobID();
            AllocationID allocationId = new AllocationID();
            Assertions.assertThat((boolean)taskSlotTable.allocateSlot(-1, jobId, allocationId, ResourceProfile.UNKNOWN, SLOT_TIMEOUT)).isTrue();
            Iterator allocatedSlots = taskSlotTable.getAllocatedSlots(jobId);
            TaskSlot allocatedSlot = (TaskSlot)allocatedSlots.next();
            Assertions.assertThat((int)allocatedSlot.getIndex()).isEqualTo(2);
            Assertions.assertThat((Object)allocatedSlot.getResourceProfile()).isEqualTo((Object)TaskSlotUtils.DEFAULT_RESOURCE_PROFILE);
            Assertions.assertThat((boolean)allocatedSlots.hasNext()).isFalse();
        }
    }

    @Test
    void testSlotAllocationWithResourceProfileFailure() throws Exception {
        try (TaskSlotTableImpl<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableAndStart(2);){
            JobID jobId = new JobID();
            AllocationID allocationId = new AllocationID();
            ResourceProfile resourceProfile = TaskSlotUtils.DEFAULT_RESOURCE_PROFILE;
            resourceProfile = resourceProfile.merge(resourceProfile).merge(resourceProfile);
            Assertions.assertThat((boolean)taskSlotTable.allocateSlot(-1, jobId, allocationId, resourceProfile, SLOT_TIMEOUT)).isFalse();
            Iterator allocatedSlots = taskSlotTable.getAllocatedSlots(jobId);
            Assertions.assertThat((boolean)allocatedSlots.hasNext()).isFalse();
        }
    }

    @Test
    void testGenerateSlotReport() throws Exception {
        try (TaskSlotTableImpl<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableAndStart(3);){
            JobID jobId = new JobID();
            AllocationID allocationId1 = new AllocationID();
            AllocationID allocationId2 = new AllocationID();
            AllocationID allocationId3 = new AllocationID();
            Assertions.assertThat((boolean)taskSlotTable.allocateSlot(0, jobId, allocationId1, SLOT_TIMEOUT)).isTrue();
            Assertions.assertThat((boolean)taskSlotTable.allocateSlot(-1, jobId, allocationId2, SLOT_TIMEOUT)).isTrue();
            Assertions.assertThat((boolean)taskSlotTable.allocateSlot(-1, jobId, allocationId3, SLOT_TIMEOUT)).isTrue();
            Assertions.assertThat((int)taskSlotTable.freeSlot(allocationId2)).isEqualTo(3);
            ResourceID resourceId = ResourceID.generate();
            SlotReport slotReport = taskSlotTable.createSlotReport(resourceId);
            ArrayList slotStatuses = new ArrayList();
            slotReport.iterator().forEachRemaining(slotStatuses::add);
            Assertions.assertThat(slotStatuses).hasSize(4);
            Assertions.assertThat(slotStatuses).containsExactlyInAnyOrder((Object[])new SlotStatus[]{new SlotStatus(new SlotID(resourceId, 0), TaskSlotUtils.DEFAULT_RESOURCE_PROFILE, jobId, allocationId1), new SlotStatus(new SlotID(resourceId, 1), TaskSlotUtils.DEFAULT_RESOURCE_PROFILE, null, null), new SlotStatus(new SlotID(resourceId, 2), TaskSlotUtils.DEFAULT_RESOURCE_PROFILE, null, null), new SlotStatus(new SlotID(resourceId, 4), TaskSlotUtils.DEFAULT_RESOURCE_PROFILE, jobId, allocationId3)});
        }
    }

    @Test
    void testAllocateSlot() throws Exception {
        JobID jobId = new JobID();
        AllocationID allocationId = new AllocationID();
        try (TaskSlotTable<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableWithAllocatedSlot(jobId, allocationId, new TestingSlotActionsBuilder().build());){
            Iterator allocatedSlots = taskSlotTable.getAllocatedSlots(jobId);
            TaskSlot nextSlot = (TaskSlot)allocatedSlots.next();
            Assertions.assertThat((int)nextSlot.getIndex()).isZero();
            Assertions.assertThat((Comparable)nextSlot.getAllocationId()).isEqualTo((Object)allocationId);
            Assertions.assertThat((Comparable)nextSlot.getJobId()).isEqualTo((Object)jobId);
            Assertions.assertThat((boolean)allocatedSlots.hasNext()).isFalse();
        }
    }

    @Test
    void testAddTask() throws Exception {
        JobID jobId = new JobID();
        ExecutionAttemptID executionAttemptId = ExecutionGraphTestUtils.createExecutionAttemptId();
        AllocationID allocationId = new AllocationID();
        TestingTaskSlotPayload task = new TestingTaskSlotPayload(jobId, executionAttemptId, allocationId).terminate();
        try (TaskSlotTable<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableWithStartedTask(task);){
            Iterator tasks = taskSlotTable.getTasks(jobId);
            TaskSlotPayload nextTask = (TaskSlotPayload)tasks.next();
            Assertions.assertThat((Object)nextTask.getExecutionId()).isEqualTo((Object)executionAttemptId);
            Assertions.assertThat((Comparable)nextTask.getAllocationId()).isEqualTo((Object)allocationId);
            Assertions.assertThat((boolean)tasks.hasNext()).isFalse();
        }
    }

    @Test
    @Timeout(value=10L)
    void testRemoveTaskCallsFreeSlotAction() throws Exception {
        JobID jobId = new JobID();
        ExecutionAttemptID executionAttemptId = ExecutionGraphTestUtils.createExecutionAttemptId();
        AllocationID allocationId = new AllocationID();
        CompletableFuture freeSlotFuture = new CompletableFuture();
        TestingSlotActions slotActions = new TestingSlotActions(freeSlotFuture::complete, (aid, uid) -> {});
        TestingTaskSlotPayload task = new TestingTaskSlotPayload(jobId, executionAttemptId, allocationId).terminate();
        try (TaskSlotTable<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableWithStartedTask(task, slotActions);){
            taskSlotTable.freeSlot(allocationId);
            taskSlotTable.removeTask(executionAttemptId);
            FlinkAssertions.assertThatFuture(freeSlotFuture).eventuallySucceeds().isEqualTo((Object)allocationId);
        }
    }

    @Test
    @Timeout(value=10L)
    void testFreeSlotInterruptsSubmittedTask() throws Exception {
        TestingTaskSlotPayload task = new TestingTaskSlotPayload();
        try (TaskSlotTable<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableWithStartedTask(task);){
            Assertions.assertThat((int)taskSlotTable.freeSlot(task.getAllocationId())).isEqualTo(-1);
            task.waitForFailure();
            task.terminate();
        }
    }

    @Test
    @Timeout(value=10L)
    void testTableIsClosedOnlyWhenAllTasksTerminated() throws Exception {
        TestingTaskSlotPayload task = new TestingTaskSlotPayload();
        TaskSlotTable<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableWithStartedTask(task);
        Assertions.assertThat((int)taskSlotTable.freeSlot(task.getAllocationId())).isEqualTo(-1);
        CompletableFuture closingFuture = taskSlotTable.closeAsync();
        Assertions.assertThat((CompletableFuture)closingFuture).isNotDone();
        task.terminate();
        closingFuture.get();
    }

    @Test
    void testAllocatedSlotTimeout() throws Exception {
        CompletableFuture timeoutFuture = new CompletableFuture();
        TestingSlotActions testingSlotActions = new TestingSlotActionsBuilder().setTimeoutSlotConsumer((allocationID, uuid) -> timeoutFuture.complete(allocationID)).build();
        try (TaskSlotTableImpl<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableAndStart(1, testingSlotActions);){
            AllocationID allocationId = new AllocationID();
            Assertions.assertThat((boolean)taskSlotTable.allocateSlot(0, new JobID(), allocationId, Duration.ofMillis(1L))).isTrue();
            FlinkAssertions.assertThatFuture(timeoutFuture).eventuallySucceeds().isEqualTo((Object)allocationId);
        }
    }

    @Test
    void testMarkSlotActiveDeactivatesSlotTimeout() throws Exception {
        this.runDeactivateSlotTimeoutTest((TriFunctionWithException<TaskSlotTable<TaskSlotPayload>, JobID, AllocationID, Boolean, SlotNotFoundException>)((TriFunctionWithException)(taskSlotTable, jobId, allocationId) -> taskSlotTable.markSlotActive(allocationId)));
    }

    @Test
    void testTryMarkSlotActiveDeactivatesSlotTimeout() throws Exception {
        this.runDeactivateSlotTimeoutTest((TriFunctionWithException<TaskSlotTable<TaskSlotPayload>, JobID, AllocationID, Boolean, SlotNotFoundException>)((TriFunctionWithException)TaskSlotTable::tryMarkSlotActive));
    }

    private void runDeactivateSlotTimeoutTest(TriFunctionWithException<TaskSlotTable<TaskSlotPayload>, JobID, AllocationID, Boolean, SlotNotFoundException> taskSlotTableAction) throws Exception {
        CompletableFuture timeoutCancellationFuture = new CompletableFuture();
        TestingTimerService<AllocationID> testingTimerService = new TestingTimerServiceBuilder<AllocationID>().setUnregisterTimeoutConsumer(timeoutCancellationFuture::complete).createTestingTimerService();
        try (TaskSlotTableImpl<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableAndStart(1, testingTimerService);){
            AllocationID allocationId = new AllocationID();
            long timeout = 50L;
            JobID jobId = new JobID();
            Assertions.assertThat((boolean)taskSlotTable.allocateSlot(0, jobId, allocationId, Duration.ofMillis(50L))).isTrue();
            Assertions.assertThat((Boolean)((Boolean)taskSlotTableAction.apply(taskSlotTable, (Object)jobId, (Object)allocationId))).isTrue();
            timeoutCancellationFuture.get();
        }
    }

    private static TaskSlotTable<TaskSlotPayload> createTaskSlotTableWithStartedTask(TaskSlotPayload task) throws SlotNotFoundException, SlotNotActiveException {
        return TaskSlotTableImplTest.createTaskSlotTableWithStartedTask(task, new TestingSlotActionsBuilder().build());
    }

    private static TaskSlotTable<TaskSlotPayload> createTaskSlotTableWithStartedTask(TaskSlotPayload task, SlotActions slotActions) throws SlotNotFoundException, SlotNotActiveException {
        TaskSlotTable<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableWithAllocatedSlot(task.getJobID(), task.getAllocationId(), slotActions);
        taskSlotTable.markSlotActive(task.getAllocationId());
        taskSlotTable.addTask(task);
        return taskSlotTable;
    }

    private static TaskSlotTable<TaskSlotPayload> createTaskSlotTableWithAllocatedSlot(JobID jobId, AllocationID allocationId, SlotActions slotActions) {
        TaskSlotTableImpl<TaskSlotPayload> taskSlotTable = TaskSlotTableImplTest.createTaskSlotTableAndStart(1, slotActions);
        Assertions.assertThat((boolean)taskSlotTable.allocateSlot(0, jobId, allocationId, SLOT_TIMEOUT)).isTrue();
        return taskSlotTable;
    }

    private static TaskSlotTableImpl<TaskSlotPayload> createTaskSlotTableAndStart(int numberOfSlots) {
        return TaskSlotTableImplTest.createTaskSlotTableAndStart(numberOfSlots, new TestingSlotActionsBuilder().build());
    }

    private static TaskSlotTableImpl<TaskSlotPayload> createTaskSlotTableAndStart(int numberOfSlots, SlotActions slotActions) {
        TaskSlotTableImpl taskSlotTable = TaskSlotUtils.createTaskSlotTable(numberOfSlots, (ScheduledExecutorService)EXECUTOR_EXTENSION.getExecutor());
        taskSlotTable.start(slotActions, ComponentMainThreadExecutorServiceAdapter.forMainThread());
        return taskSlotTable;
    }

    private static TaskSlotTableImpl<TaskSlotPayload> createTaskSlotTableAndStart(int numberOfSlots, TimerService<AllocationID> timerService) {
        TaskSlotTableImpl taskSlotTable = TaskSlotUtils.createTaskSlotTable(numberOfSlots, timerService, (ScheduledExecutorService)EXECUTOR_EXTENSION.getExecutor());
        taskSlotTable.start((SlotActions)new TestingSlotActionsBuilder().build(), ComponentMainThreadExecutorServiceAdapter.forMainThread());
        return taskSlotTable;
    }
}

