/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security.modules;

import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.core.testutils.ManuallyTriggeredScheduledExecutorService;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.modules.HadoopModule;
import org.apache.flink.runtime.security.modules.SecurityModule;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class HadoopModuleTest {
    HadoopModuleTest() {
    }

    @Test
    public void startTGTRenewalShouldScheduleRenewalWithKeytab() throws IOException {
        ManuallyTriggeredScheduledExecutorService executorService = new ManuallyTriggeredScheduledExecutorService();
        UserGroupInformation userGroupInformation = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        Configuration flinkConf = new Configuration();
        SecurityConfiguration securityConf = new SecurityConfiguration(flinkConf);
        org.apache.hadoop.conf.Configuration hadoopConf = new org.apache.hadoop.conf.Configuration();
        HadoopModule hadoopModule = new HadoopModule(securityConf, hadoopConf);
        hadoopModule.startTGTRenewal((ScheduledExecutorService)executorService, userGroupInformation);
        executorService.triggerPeriodicScheduledTasks();
        hadoopModule.stopTGTRenewal();
        ((UserGroupInformation)Mockito.verify((Object)userGroupInformation, (VerificationMode)Mockito.times((int)1))).checkTGTAndReloginFromKeytab();
    }

    @Test
    public void hadoopProxyUserSetWithDelegationTokensEnabledShouldThrow() {
        try (MockedStatic ugi = Mockito.mockStatic(UserGroupInformation.class);){
            UserGroupInformation userGroupInformation = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
            ugi.when(UserGroupInformation::isSecurityEnabled).thenReturn((Object)true);
            ugi.when(UserGroupInformation::getCurrentUser).thenReturn((Object)userGroupInformation);
            ugi.when(UserGroupInformation::getLoginUser).thenReturn((Object)userGroupInformation);
            Mockito.when((Object)userGroupInformation.getAuthenticationMethod()).thenReturn((Object)UserGroupInformation.AuthenticationMethod.PROXY);
            Configuration flinkConf = new Configuration();
            flinkConf.set(SecurityOptions.DELEGATION_TOKENS_ENABLED, (Object)true);
            SecurityConfiguration securityConf = new SecurityConfiguration(flinkConf);
            org.apache.hadoop.conf.Configuration hadoopConf = new org.apache.hadoop.conf.Configuration();
            HadoopModule hadoopModule = new HadoopModule(securityConf, hadoopConf);
            Exception exception = (Exception)Assertions.assertThrows(SecurityModule.SecurityInstallException.class, () -> ((HadoopModule)hadoopModule).install());
            Assertions.assertTrue((boolean)(exception.getCause() instanceof UnsupportedOperationException));
        }
    }
}

