/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.rest.messages.AggregatedTaskDetailsInfo;
import org.apache.flink.runtime.rest.messages.RestResponseMarshallingTestBase;
import org.apache.flink.runtime.rest.messages.job.SubtaskExecutionAttemptDetailsInfo;
import org.apache.flink.runtime.rest.messages.job.metrics.IOMetricsInfo;
import org.apache.flink.testutils.junit.extensions.parameterized.NoOpTestExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={NoOpTestExtension.class})
class AggregatedTaskDetailsInfoTest
extends RestResponseMarshallingTestBase<AggregatedTaskDetailsInfo> {
    AggregatedTaskDetailsInfoTest() {
    }

    @Override
    protected Class<AggregatedTaskDetailsInfo> getTestResponseClass() {
        return AggregatedTaskDetailsInfo.class;
    }

    @Override
    protected AggregatedTaskDetailsInfo getTestResponseInstance() throws Exception {
        Random random = new Random();
        IOMetricsInfo ioMetricsInfo = new IOMetricsInfo(Math.abs(random.nextLong()), random.nextBoolean(), Math.abs(random.nextLong()), random.nextBoolean(), Math.abs(random.nextLong()), random.nextBoolean(), Math.abs(random.nextLong()), random.nextBoolean(), Math.abs(random.nextLong()), Math.abs(random.nextLong()), Math.abs(random.nextDouble()));
        HashMap<ExecutionState, Long> statusDuration = new HashMap<ExecutionState, Long>();
        statusDuration.put(ExecutionState.CREATED, 10L);
        statusDuration.put(ExecutionState.SCHEDULED, 20L);
        statusDuration.put(ExecutionState.DEPLOYING, 30L);
        statusDuration.put(ExecutionState.INITIALIZING, 40L);
        statusDuration.put(ExecutionState.RUNNING, 50L);
        return AggregatedTaskDetailsInfo.create(Collections.singletonList(new SubtaskExecutionAttemptDetailsInfo(Math.abs(random.nextInt()), ExecutionState.values()[random.nextInt(ExecutionState.values().length)], Math.abs(random.nextInt()), "localhost", "localhost:" + random.nextInt(65536), Math.abs(random.nextLong()), Math.abs(random.nextLong()), Math.abs(random.nextLong()), ioMetricsInfo, "taskmanagerId", statusDuration, null)));
    }

    @Test
    void testMetricsStatistics() {
        AggregatedTaskDetailsInfo.MetricsStatistics metricsStatistics = new AggregatedTaskDetailsInfo.MetricsStatistics("test");
        for (int i = 0; i < 100; ++i) {
            metricsStatistics.addValue((long)i);
        }
        Assertions.assertThat((long)metricsStatistics.getMin()).isZero();
        Assertions.assertThat((long)metricsStatistics.getMax()).isEqualTo(99L);
        Assertions.assertThat((long)metricsStatistics.getPercentile(50)).isEqualTo(49L);
        Assertions.assertThat((long)metricsStatistics.getPercentile(25)).isEqualTo(24L);
        Assertions.assertThat((long)metricsStatistics.getPercentile(75)).isEqualTo(74L);
        Assertions.assertThat((long)metricsStatistics.getPercentile(95)).isEqualTo(94L);
        Assertions.assertThat((long)metricsStatistics.getSum()).isEqualTo(4950L);
        Assertions.assertThat((long)metricsStatistics.getAvg()).isEqualTo(49L);
    }
}

