/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.time.Duration;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceAllocator;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskExecutorManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.TestingResourceAllocatorBuilder;
import org.apache.flink.util.concurrent.Executors;
import org.apache.flink.util.concurrent.ScheduledExecutor;

public class TaskExecutorManagerBuilder {
    private WorkerResourceSpec defaultWorkerResourceSpec = new WorkerResourceSpec.Builder().setCpuCores(4.0).build();
    private int numSlotsPerWorker = 1;
    private int maxSlotNum = 1;
    private boolean waitResultConsumedBeforeRelease = true;
    private int redundantTaskManagerNum = 0;
    private Time taskManagerTimeout = Time.seconds((long)5L);
    private Duration declareNeededResourceDelay = Duration.ofMillis(0L);
    private final ScheduledExecutor scheduledExecutor;
    private Executor mainThreadExecutor = Executors.directExecutor();
    private ResourceAllocator newResourceAllocator = new TestingResourceAllocatorBuilder().build();

    public TaskExecutorManagerBuilder(ScheduledExecutor scheduledExecutor) {
        this.scheduledExecutor = scheduledExecutor;
    }

    public TaskExecutorManagerBuilder setDefaultWorkerResourceSpec(WorkerResourceSpec defaultWorkerResourceSpec) {
        this.defaultWorkerResourceSpec = defaultWorkerResourceSpec;
        return this;
    }

    public TaskExecutorManagerBuilder setNumSlotsPerWorker(int numSlotsPerWorker) {
        this.numSlotsPerWorker = numSlotsPerWorker;
        return this;
    }

    public TaskExecutorManagerBuilder setMaxNumSlots(int maxSlotNum) {
        this.maxSlotNum = maxSlotNum;
        return this;
    }

    public TaskExecutorManagerBuilder setWaitResultConsumedBeforeRelease(boolean waitResultConsumedBeforeRelease) {
        this.waitResultConsumedBeforeRelease = waitResultConsumedBeforeRelease;
        return this;
    }

    public TaskExecutorManagerBuilder setRedundantTaskManagerNum(int redundantTaskManagerNum) {
        this.redundantTaskManagerNum = redundantTaskManagerNum;
        return this;
    }

    public TaskExecutorManagerBuilder setTaskManagerTimeout(Time taskManagerTimeout) {
        this.taskManagerTimeout = taskManagerTimeout;
        return this;
    }

    public TaskExecutorManagerBuilder setMainThreadExecutor(Executor mainThreadExecutor) {
        this.mainThreadExecutor = mainThreadExecutor;
        return this;
    }

    public TaskExecutorManagerBuilder setResourceAllocator(ResourceAllocator newResourceAllocator) {
        this.newResourceAllocator = newResourceAllocator;
        return this;
    }

    public TaskExecutorManagerBuilder setDeclareNeededResourceDelay(Duration declareNeededResourceDelay) {
        this.declareNeededResourceDelay = declareNeededResourceDelay;
        return this;
    }

    public TaskExecutorManager createTaskExecutorManager() {
        return new TaskExecutorManager(this.defaultWorkerResourceSpec, this.numSlotsPerWorker, this.maxSlotNum, this.waitResultConsumedBeforeRelease, this.redundantTaskManagerNum, this.taskManagerTimeout, this.declareNeededResourceDelay, this.scheduledExecutor, this.mainThreadExecutor, this.newResourceAllocator);
    }
}

