/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.query;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.queryablestate.KvStateID;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.query.KvStateLocation;
import org.apache.flink.runtime.query.KvStateLocationRegistry;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class KvStateLocationRegistryTest {
    KvStateLocationRegistryTest() {
    }

    @Test
    void testRegisterAndLookup() throws Exception {
        int keyGroupIndex;
        int i;
        String[] registrationNames = new String[]{"TAsIrGnc7MULwVupNKZ0", "086133IrGn0Ii2853237"};
        ExecutionJobVertex[] vertices = new ExecutionJobVertex[]{this.createJobVertex(32), this.createJobVertex(13)};
        KvStateID[][] ids = new KvStateID[vertices.length][];
        for (int i2 = 0; i2 < ids.length; ++i2) {
            ids[i2] = new KvStateID[vertices[i2].getMaxParallelism()];
            for (int j = 0; j < vertices[i2].getMaxParallelism(); ++j) {
                ids[i2][j] = new KvStateID();
            }
        }
        InetSocketAddress server = new InetSocketAddress(InetAddress.getLocalHost(), 12032);
        Map<JobVertexID, ExecutionJobVertex> vertexMap = this.createVertexMap(vertices);
        KvStateLocationRegistry registry = new KvStateLocationRegistry(new JobID(), vertexMap);
        for (i = 0; i < vertices.length; ++i) {
            int numKeyGroups = vertices[i].getMaxParallelism();
            for (int keyGroupIndex2 = 0; keyGroupIndex2 < numKeyGroups; ++keyGroupIndex2) {
                registry.notifyKvStateRegistered(vertices[i].getJobVertexId(), new KeyGroupRange(keyGroupIndex2, keyGroupIndex2), registrationNames[i], ids[i][keyGroupIndex2], server);
            }
        }
        for (i = 0; i < vertices.length; ++i) {
            KvStateLocation location = registry.getKvStateLocation(registrationNames[i]);
            Assertions.assertThat((Object)location).isNotNull();
            int maxParallelism = vertices[i].getMaxParallelism();
            for (keyGroupIndex = 0; keyGroupIndex < maxParallelism; ++keyGroupIndex) {
                Assertions.assertThat((Comparable)location.getKvStateID(keyGroupIndex)).isEqualTo((Object)ids[i][keyGroupIndex]);
                Assertions.assertThat((Object)location.getKvStateServerAddress(keyGroupIndex)).isEqualTo((Object)server);
            }
        }
        for (i = 0; i < vertices.length; ++i) {
            int numKeyGroups = vertices[i].getMaxParallelism();
            JobVertexID jobVertexId = vertices[i].getJobVertexId();
            for (keyGroupIndex = 0; keyGroupIndex < numKeyGroups; ++keyGroupIndex) {
                registry.notifyKvStateUnregistered(jobVertexId, new KeyGroupRange(keyGroupIndex, keyGroupIndex), registrationNames[i]);
            }
        }
        for (i = 0; i < registrationNames.length; ++i) {
            Assertions.assertThat((Object)registry.getKvStateLocation(registrationNames[i])).isNull();
        }
    }

    @Test
    void testRegisterDuplicateName() throws Exception {
        ExecutionJobVertex[] vertices = new ExecutionJobVertex[]{this.createJobVertex(32), this.createJobVertex(13)};
        Map<JobVertexID, ExecutionJobVertex> vertexMap = this.createVertexMap(vertices);
        String registrationName = "duplicated-name";
        KvStateLocationRegistry registry = new KvStateLocationRegistry(new JobID(), vertexMap);
        registry.notifyKvStateRegistered(vertices[0].getJobVertexId(), new KeyGroupRange(0, 0), registrationName, new KvStateID(), new InetSocketAddress(InetAddress.getLocalHost(), 12328));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> registry.notifyKvStateRegistered(vertices[1].getJobVertexId(), new KeyGroupRange(0, 0), registrationName, new KvStateID(), new InetSocketAddress(InetAddress.getLocalHost(), 12032))).withFailMessage("Did not throw expected Exception after duplicated name", new Object[0])).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testUnregisterBeforeRegister() throws Exception {
        ExecutionJobVertex vertex = this.createJobVertex(4);
        Map<JobVertexID, ExecutionJobVertex> vertexMap = this.createVertexMap(vertex);
        KvStateLocationRegistry registry = new KvStateLocationRegistry(new JobID(), vertexMap);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> registry.notifyKvStateUnregistered(vertex.getJobVertexId(), new KeyGroupRange(0, 0), "any-name")).withFailMessage("Did not throw expected Exception, because of missing registration", new Object[0])).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testUnregisterFailures() throws Exception {
        String name = "IrGnc73237TAs";
        ExecutionJobVertex[] vertices = new ExecutionJobVertex[]{this.createJobVertex(32), this.createJobVertex(13)};
        HashMap<JobVertexID, ExecutionJobVertex> vertexMap = new HashMap<JobVertexID, ExecutionJobVertex>();
        for (ExecutionJobVertex vertex : vertices) {
            vertexMap.put(vertex.getJobVertexId(), vertex);
        }
        KvStateLocationRegistry registry = new KvStateLocationRegistry(new JobID(), vertexMap);
        registry.notifyKvStateRegistered(vertices[0].getJobVertexId(), new KeyGroupRange(0, 0), name, new KvStateID(), (InetSocketAddress)Mockito.mock(InetSocketAddress.class));
        int notRegisteredKeyGroupIndex = 2;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> registry.notifyKvStateUnregistered(vertices[0].getJobVertexId(), new KeyGroupRange(notRegisteredKeyGroupIndex, notRegisteredKeyGroupIndex), name)).withFailMessage("Did not throw expected Exception", new Object[0])).isInstanceOf(IllegalArgumentException.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> registry.notifyKvStateUnregistered(vertices[1].getJobVertexId(), new KeyGroupRange(0, 0), name)).withFailMessage("Did not throw expected Exception", new Object[0])).isInstanceOf(IllegalArgumentException.class);
    }

    private ExecutionJobVertex createJobVertex(int maxParallelism) {
        JobVertexID id = new JobVertexID();
        ExecutionJobVertex vertex = (ExecutionJobVertex)Mockito.mock(ExecutionJobVertex.class);
        Mockito.when((Object)vertex.getJobVertexId()).thenReturn((Object)id);
        Mockito.when((Object)vertex.getMaxParallelism()).thenReturn((Object)maxParallelism);
        return vertex;
    }

    private Map<JobVertexID, ExecutionJobVertex> createVertexMap(ExecutionJobVertex ... vertices) {
        HashMap<JobVertexID, ExecutionJobVertex> vertexMap = new HashMap<JobVertexID, ExecutionJobVertex>();
        for (ExecutionJobVertex vertex : vertices) {
            vertexMap.put(vertex.getJobVertexId(), vertex);
        }
        return vertexMap;
    }
}

