/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.Collections;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.filter.MetricFilter;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;
import org.apache.flink.runtime.metrics.groups.FrontMetricGroup;
import org.apache.flink.runtime.metrics.groups.ProcessMetricGroup;
import org.apache.flink.runtime.metrics.groups.ReporterScopedSettings;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.runtime.metrics.scope.ScopeFormats;
import org.apache.flink.runtime.metrics.util.TestingMetricRegistry;
import org.apache.flink.shaded.guava31.com.google.common.collect.ImmutableMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class FrontMetricGroupTest {
    FrontMetricGroupTest() {
    }

    @Test
    void testDelimiterReplacement() {
        int delimiter = 42;
        String hostName = "some*host";
        String metricName = "hello*world";
        Configuration config = new Configuration();
        config.set(MetricOptions.SCOPE_NAMING_JM, (Object)ScopeFormat.SCOPE_HOST);
        FrontMetricGroup frontMetricGroup = new FrontMetricGroup(new ReporterScopedSettings(0, '*', MetricFilter.NO_OP_FILTER, Collections.emptySet(), Collections.emptyMap()), (AbstractMetricGroup)new ProcessMetricGroup((MetricRegistry)TestingMetricRegistry.builder().setScopeFormats(ScopeFormats.fromConfig((Configuration)config)).build(), "some*host"));
        Assertions.assertThat((String)frontMetricGroup.getMetricIdentifier("hello*world")).isEqualTo("some*host".replace('*', '_') + '*' + "hello*world".replace('*', '_'));
        Assertions.assertThat((Map)frontMetricGroup.getAllVariables()).containsEntry((Object)ScopeFormat.SCOPE_HOST, (Object)"some*host");
    }

    @Test
    void testDelimiterReplacementWithAlternative() {
        int delimiter = 95;
        String hostName = "some_host";
        String metricName = "hello_world";
        Configuration config = new Configuration();
        config.set(MetricOptions.SCOPE_NAMING_JM, (Object)ScopeFormat.SCOPE_HOST);
        FrontMetricGroup frontMetricGroup = new FrontMetricGroup(new ReporterScopedSettings(0, '_', MetricFilter.NO_OP_FILTER, Collections.emptySet(), Collections.emptyMap()), (AbstractMetricGroup)new ProcessMetricGroup((MetricRegistry)TestingMetricRegistry.builder().setScopeFormats(ScopeFormats.fromConfig((Configuration)config)).build(), "some_host"));
        Assertions.assertThat((String)frontMetricGroup.getMetricIdentifier("hello_world")).isEqualTo("some_host".replace('_', '-') + '_' + "hello_world".replace('_', '-'));
        Assertions.assertThat((Map)frontMetricGroup.getAllVariables()).containsEntry((Object)ScopeFormat.SCOPE_HOST, (Object)"some_host");
    }

    @Test
    void testGetAllVariablesWithAdditionalVariables() {
        FrontMetricGroup frontMetricGroup = new FrontMetricGroup(new ReporterScopedSettings(0, '.', MetricFilter.NO_OP_FILTER, Collections.emptySet(), (Map)ImmutableMap.of((Object)ScopeFormat.asVariable((String)"foo"), (Object)"bar")), (AbstractMetricGroup)new ProcessMetricGroup((MetricRegistry)TestingMetricRegistry.builder().build(), "host"));
        Assertions.assertThat((Map)frontMetricGroup.getAllVariables()).containsEntry((Object)ScopeFormat.asVariable((String)"foo"), (Object)"bar");
    }
}

