/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.messages.webmonitor;

import java.io.IOException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.messages.webmonitor.JobDetails;
import org.apache.flink.runtime.rest.util.RestMapperUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class JobDetailsTest {
    private static final String COMPATIBLE_JOB_DETAILS = "{  \"jid\" : \"7a7c3291accebd10b6be8d4f8c8d8dfc\",  \"name\" : \"foobar\",  \"state\" : \"RUNNING\",  \"start-time\" : 1,  \"end-time\" : 10,  \"duration\" : 9,  \"last-modification\" : 8,  \"tasks\" : {    \"total\" : 42,    \"created\" : 1,    \"scheduled\" : 3,    \"deploying\" : 3,    \"running\" : 4,    \"finished\" : 7,    \"canceling\" : 4,    \"canceled\" : 2,    \"failed\" : 7,    \"reconciling\" : 3  }}";
    private static final String UNKNOWN_FIELD_JOB_DETAILS = "{  \"jid\" : \"7a7c3291accebd10b6be8d4f8c8d8dfc\",  \"intentionally_unknown_which_must_be_skipped\" : 0,  \"name\" : \"foobar\",  \"state\" : \"RUNNING\",  \"start-time\" : 1,  \"end-time\" : 10,  \"duration\" : 9,  \"last-modification\" : 8,  \"tasks\" : {    \"total\" : 42,    \"created\" : 1,    \"scheduled\" : 3,    \"deploying\" : 3,    \"running\" : 4,    \"finished\" : 7,    \"canceling\" : 4,    \"canceled\" : 2,    \"failed\" : 7,    \"reconciling\" : 3  }}";
    private ObjectMapper objectMapper;
    private ObjectMapper flexibleObjectMapper;
    final JobDetails expected = new JobDetails(JobID.fromHexString((String)"7a7c3291accebd10b6be8d4f8c8d8dfc"), "foobar", 1L, 10L, 9L, JobStatus.RUNNING, 8L, new int[]{1, 3, 3, 4, 7, 4, 2, 7, 3, 0}, 42);

    JobDetailsTest() {
    }

    @BeforeEach
    public void beforeEach() {
        this.objectMapper = RestMapperUtils.getStrictObjectMapper();
        this.flexibleObjectMapper = RestMapperUtils.getFlexibleObjectMapper();
    }

    @Test
    void testJobDetailsMarshalling() throws JsonProcessingException {
        JsonNode marshalled = this.objectMapper.valueToTree((Object)this.expected);
        JobDetails unmarshalled = (JobDetails)this.objectMapper.treeToValue((TreeNode)marshalled, JobDetails.class);
        Assertions.assertThat((Object)unmarshalled).isEqualTo((Object)this.expected);
    }

    @Test
    void testJobDetailsCompatibleUnmarshalling() throws IOException {
        JobDetails unmarshalled = (JobDetails)this.objectMapper.readValue(COMPATIBLE_JOB_DETAILS, JobDetails.class);
        Assertions.assertThat((Object)unmarshalled).isEqualTo((Object)this.expected);
    }

    @Test
    void testJobDetailsCompatibleUnmarshallingSkipUnknown() throws IOException {
        JobDetails unmarshalled = (JobDetails)this.flexibleObjectMapper.readValue(UNKNOWN_FIELD_JOB_DETAILS, JobDetails.class);
        Assertions.assertThat((Object)unmarshalled).isEqualTo((Object)this.expected);
    }
}

