/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.time.Deadline;
import org.apache.flink.runtime.leaderelection.LeaderElectionDriver;
import org.apache.flink.runtime.leaderelection.LeaderElectionEvent;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderelection.LeaderInformationRegister;
import org.apache.flink.util.ExceptionUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;

public final class TestingLeaderElectionListener
implements LeaderElectionDriver.Listener {
    private final BlockingQueue<LeaderElectionEvent> leaderElectionEvents = new ArrayBlockingQueue<LeaderElectionEvent>(10);

    public void onGrantLeadership(UUID leaderSessionID) {
        this.put(new LeaderElectionEvent.IsLeaderEvent(leaderSessionID));
    }

    public void onRevokeLeadership() {
        this.put(new LeaderElectionEvent.NotLeaderEvent());
    }

    public void onLeaderInformationChange(String componentId, LeaderInformation leaderInformation) {
        this.put(new LeaderElectionEvent.LeaderInformationChangeEvent(componentId, leaderInformation));
    }

    public void onLeaderInformationChange(LeaderInformationRegister leaderInformationRegister) {
        this.put(new LeaderElectionEvent.AllLeaderInformationChangeEvent(leaderInformationRegister));
    }

    public void onError(Throwable t) {
        this.put(new LeaderElectionEvent.ErrorEvent(t));
    }

    private void put(LeaderElectionEvent leaderElectionEvent) {
        try {
            this.leaderElectionEvents.put(leaderElectionEvent);
        }
        catch (InterruptedException e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public <T> T assertNextEvent(Class<T> expectedEventClass) throws InterruptedException {
        LeaderElectionEvent leaderElectionEvent = this.leaderElectionEvents.take();
        ((ObjectAssert)Assertions.assertThat((Object)leaderElectionEvent).as("The next event didn't match the expected event type %s.", new Object[]{expectedEventClass.getSimpleName()})).isInstanceOf(expectedEventClass);
        return leaderElectionEvent.as(expectedEventClass);
    }

    public <T> T await(Class<T> clazz) throws InterruptedException {
        LeaderElectionEvent leaderElectionEvent;
        while (!clazz.isAssignableFrom((leaderElectionEvent = this.leaderElectionEvents.take()).getClass())) {
        }
        return clazz.cast(leaderElectionEvent);
    }

    public <T> Optional<T> await(Class<T> clazz, Duration timeout) throws InterruptedException {
        block2: {
            Optional<LeaderElectionEvent> optLeaderElectionEvent;
            LeaderElectionEvent leaderElectionEvent;
            Deadline deadline = Deadline.fromNow((Duration)timeout);
            do {
                Duration timeLeft;
                if ((timeLeft = deadline.timeLeft()).isNegative()) {
                    return Optional.empty();
                }
                optLeaderElectionEvent = Optional.ofNullable(this.leaderElectionEvents.poll(timeLeft.toMillis(), TimeUnit.MILLISECONDS));
                if (!optLeaderElectionEvent.isPresent()) break block2;
            } while (!clazz.isAssignableFrom((leaderElectionEvent = optLeaderElectionEvent.get()).getClass()));
            return Optional.of(clazz.cast(optLeaderElectionEvent));
        }
        return Optional.empty();
    }

    public Optional<LeaderElectionEvent.ErrorEvent> getNextErrorEvent() {
        while (!this.leaderElectionEvents.isEmpty()) {
            LeaderElectionEvent event = (LeaderElectionEvent)this.leaderElectionEvents.remove();
            if (!event.isErrorEvent()) continue;
            return Optional.of(event.as(LeaderElectionEvent.ErrorEvent.class));
        }
        return Optional.empty();
    }

    public void failIfErrorEventHappened() {
        this.getNextErrorEvent().ifPresent(error -> {
            throw new AssertionError("An error was reported that wasn't properly handled.", error.getError());
        });
    }
}

