/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.SubTaskInitializationMetrics;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.taskmanager.CheckpointResponder;

public class TestCheckpointResponder
implements CheckpointResponder {
    private final List<AcknowledgeReport> acknowledgeReports = new ArrayList<AcknowledgeReport>();
    private final List<DeclineReport> declineReports = new ArrayList<DeclineReport>();
    private OneShotLatch acknowledgeLatch;
    private OneShotLatch declinedLatch;

    public void acknowledgeCheckpoint(JobID jobID, ExecutionAttemptID executionAttemptID, long checkpointId, CheckpointMetrics checkpointMetrics, TaskStateSnapshot subtaskState) {
        AcknowledgeReport acknowledgeReport = new AcknowledgeReport(jobID, executionAttemptID, checkpointId, checkpointMetrics, subtaskState);
        this.acknowledgeReports.add(acknowledgeReport);
        if (this.acknowledgeLatch != null) {
            this.acknowledgeLatch.trigger();
        }
    }

    public void reportCheckpointMetrics(JobID jobID, ExecutionAttemptID executionAttemptID, long checkpointId, CheckpointMetrics checkpointMetrics) {
    }

    public void reportInitializationMetrics(JobID jobId, SubTaskInitializationMetrics initializationMetrics) {
    }

    public void declineCheckpoint(JobID jobID, ExecutionAttemptID executionAttemptID, long checkpointId, CheckpointException checkpointException) {
        DeclineReport declineReport = new DeclineReport(jobID, executionAttemptID, checkpointId, checkpointException);
        this.declineReports.add(declineReport);
        if (this.declinedLatch != null) {
            this.declinedLatch.trigger();
        }
    }

    public List<AcknowledgeReport> getAcknowledgeReports() {
        return this.acknowledgeReports;
    }

    public List<DeclineReport> getDeclineReports() {
        return this.declineReports;
    }

    public OneShotLatch getAcknowledgeLatch() {
        return this.acknowledgeLatch;
    }

    public void setAcknowledgeLatch(OneShotLatch acknowledgeLatch) {
        this.acknowledgeLatch = acknowledgeLatch;
    }

    public OneShotLatch getDeclinedLatch() {
        return this.declinedLatch;
    }

    public void setDeclinedLatch(OneShotLatch declinedLatch) {
        this.declinedLatch = declinedLatch;
    }

    public void clear() {
        this.acknowledgeReports.clear();
        this.declineReports.clear();
    }

    public static class DeclineReport
    extends AbstractReport {
        public final CheckpointException cause;

        public DeclineReport(JobID jobID, ExecutionAttemptID executionAttemptID, long checkpointId, CheckpointException cause) {
            super(jobID, executionAttemptID, checkpointId);
            this.cause = cause;
        }

        public CheckpointException getCause() {
            return this.cause;
        }
    }

    public static class AcknowledgeReport
    extends AbstractReport {
        private final CheckpointMetrics checkpointMetrics;
        private final TaskStateSnapshot subtaskState;

        public AcknowledgeReport(JobID jobID, ExecutionAttemptID executionAttemptID, long checkpointId, CheckpointMetrics checkpointMetrics, TaskStateSnapshot subtaskState) {
            super(jobID, executionAttemptID, checkpointId);
            this.checkpointMetrics = checkpointMetrics;
            this.subtaskState = subtaskState;
        }

        public CheckpointMetrics getCheckpointMetrics() {
            return this.checkpointMetrics;
        }

        public TaskStateSnapshot getSubtaskState() {
            return this.subtaskState;
        }
    }

    public static abstract class AbstractReport {
        private final JobID jobID;
        private final ExecutionAttemptID executionAttemptID;
        private final long checkpointId;

        AbstractReport(JobID jobID, ExecutionAttemptID executionAttemptID, long checkpointId) {
            this.jobID = jobID;
            this.executionAttemptID = executionAttemptID;
            this.checkpointId = checkpointId;
        }

        public JobID getJobID() {
            return this.jobID;
        }

        public ExecutionAttemptID getExecutionAttemptID() {
            return this.executionAttemptID;
        }

        public long getCheckpointId() {
            return this.checkpointId;
        }
    }
}

