/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.util.function.Consumer;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.concurrent.ManuallyTriggeredComponentMainThreadExecutor;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.scheduler.adaptive.State;
import org.apache.flink.runtime.scheduler.adaptive.StateValidator;
import org.apache.flink.runtime.scheduler.adaptive.StateWithExecutionGraph;
import org.apache.flink.runtime.scheduler.exceptionhistory.RootExceptionHistoryEntry;
import org.apache.flink.util.Preconditions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

class MockStateWithExecutionGraphContext
implements StateWithExecutionGraph.Context,
AutoCloseable {
    private final StateValidator<ArchivedExecutionGraph> finishedStateValidator = new StateValidator("Finished");
    private final ManuallyTriggeredComponentMainThreadExecutor executor = new ManuallyTriggeredComponentMainThreadExecutor(Thread.currentThread());
    protected boolean hadStateTransition = false;

    MockStateWithExecutionGraphContext() {
    }

    public void setExpectFinished(Consumer<ArchivedExecutionGraph> asserter) {
        this.finishedStateValidator.expectInput(asserter);
    }

    public void runIfState(State expectedState, Runnable action) {
        if (!this.hadStateTransition) {
            action.run();
        }
    }

    public boolean isState(State expectedState) {
        throw new UnsupportedOperationException("Not covered by this test at the moment");
    }

    public void goToFinished(ArchivedExecutionGraph archivedExecutionGraph) {
        this.finishedStateValidator.validateInput(archivedExecutionGraph);
        this.hadStateTransition = true;
    }

    public ComponentMainThreadExecutor getMainThreadExecutor() {
        return this.executor;
    }

    public void archiveFailure(RootExceptionHistoryEntry failure) {
    }

    @Override
    public void close() throws Exception {
        this.triggerExecutors();
        Preconditions.checkState((boolean)this.executor.shutdownNow().isEmpty());
        this.finishedStateValidator.close();
    }

    protected final void triggerExecutors() {
        this.executor.triggerAllNonPeriodicTasks();
    }

    protected final void assertNoStateTransition() {
        Assert.assertThat((Object)this.hadStateTransition, (Matcher)CoreMatchers.is((Object)false));
    }
}

