/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.flink.api.common.accumulators.IntCounter;
import org.apache.flink.api.common.accumulators.LongCounter;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.ArchivedExecution;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerConfiguration;
import org.apache.flink.runtime.rest.handler.job.SubtaskExecutionAttemptAccumulatorsHandler;
import org.apache.flink.runtime.rest.handler.legacy.DefaultExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.job.SubtaskAttemptMessageParameters;
import org.apache.flink.runtime.rest.messages.job.SubtaskExecutionAttemptAccumulatorsHeaders;
import org.apache.flink.runtime.rest.messages.job.SubtaskExecutionAttemptAccumulatorsInfo;
import org.apache.flink.runtime.rest.messages.job.UserAccumulator;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.OptionalFailure;
import org.apache.flink.util.concurrent.Executors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class SubtaskExecutionAttemptAccumulatorsHandlerTest {
    SubtaskExecutionAttemptAccumulatorsHandlerTest() {
    }

    @Test
    void testHandleRequest() throws Exception {
        RestHandlerConfiguration restHandlerConfiguration = RestHandlerConfiguration.fromConfiguration((Configuration)new Configuration());
        SubtaskExecutionAttemptAccumulatorsHandler handler = new SubtaskExecutionAttemptAccumulatorsHandler(() -> null, Time.milliseconds((long)100L), Collections.emptyMap(), (MessageHeaders)SubtaskExecutionAttemptAccumulatorsHeaders.getInstance(), (ExecutionGraphCache)new DefaultExecutionGraphCache(restHandlerConfiguration.getTimeout(), Time.milliseconds((long)restHandlerConfiguration.getRefreshInterval())), Executors.directExecutor());
        HandlerRequest request = HandlerRequest.create((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new SubtaskAttemptMessageParameters());
        HashMap<String, OptionalFailure> userAccumulators = new HashMap<String, OptionalFailure>(3);
        userAccumulators.put("IntCounter", OptionalFailure.of((Object)new IntCounter(10)));
        userAccumulators.put("LongCounter", OptionalFailure.of((Object)new LongCounter(100L)));
        userAccumulators.put("Failure", OptionalFailure.ofFailure((Throwable)new FlinkRuntimeException("Test")));
        StringifiedAccumulatorResult[] accumulatorResults = StringifiedAccumulatorResult.stringifyAccumulatorResults(userAccumulators);
        boolean attemptNum = true;
        int subtaskIndex = 2;
        ArchivedExecution execution = new ArchivedExecution(accumulatorResults, null, ExecutionGraphTestUtils.createExecutionAttemptId(new JobVertexID(), 2, 1), ExecutionState.FINISHED, null, null, null, new long[ExecutionState.values().length], new long[ExecutionState.values().length]);
        SubtaskExecutionAttemptAccumulatorsInfo accumulatorsInfo = handler.handleRequest(request, (AccessExecution)execution);
        ArrayList<UserAccumulator> userAccumulatorList = new ArrayList<UserAccumulator>(userAccumulators.size());
        for (StringifiedAccumulatorResult accumulatorResult : accumulatorResults) {
            userAccumulatorList.add(new UserAccumulator(accumulatorResult.getName(), accumulatorResult.getType(), accumulatorResult.getValue()));
        }
        SubtaskExecutionAttemptAccumulatorsInfo expected = new SubtaskExecutionAttemptAccumulatorsInfo(2, 1, execution.getAttemptId().toString(), userAccumulatorList);
        Assertions.assertThat((Object)accumulatorsInfo).isEqualTo((Object)expected);
    }
}

