/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.hash;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.typeutils.GenericPairComparator;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.memory.MemoryManagerBuilder;
import org.apache.flink.runtime.operators.hash.NonReusingBuildFirstHashJoinIterator;
import org.apache.flink.runtime.operators.hash.NonReusingBuildSecondHashJoinIterator;
import org.apache.flink.runtime.operators.testutils.DiscardingOutputCollector;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.apache.flink.runtime.operators.testutils.TestData;
import org.apache.flink.runtime.operators.testutils.UniformIntPairGenerator;
import org.apache.flink.runtime.operators.testutils.UnionIterator;
import org.apache.flink.runtime.operators.testutils.types.IntPair;
import org.apache.flink.runtime.operators.testutils.types.IntPairSerializer;
import org.apache.flink.types.NullKeyFieldException;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class NonReusingHashJoinIteratorITCase {
    private static final int MEMORY_SIZE = 16000000;
    private static final int INPUT_1_SIZE = 20000;
    private static final int INPUT_2_SIZE = 1000;
    private static final long SEED1 = 561349061987311L;
    private static final long SEED2 = 231434613412342L;
    private final AbstractInvokable parentTask = new DummyInvokable();
    private IOManager ioManager;
    private MemoryManager memoryManager;
    private TypeSerializer<Tuple2<Integer, String>> recordSerializer;
    private TypeComparator<Tuple2<Integer, String>> record1Comparator;
    private TypeComparator<Tuple2<Integer, String>> record2Comparator;
    private TypePairComparator<Tuple2<Integer, String>, Tuple2<Integer, String>> recordPairComparator;
    private TypeSerializer<IntPair> pairSerializer;
    private TypeComparator<IntPair> pairComparator;
    private TypePairComparator<IntPair, Tuple2<Integer, String>> pairRecordPairComparator;
    private TypePairComparator<Tuple2<Integer, String>, IntPair> recordPairPairComparator;

    NonReusingHashJoinIteratorITCase() {
    }

    @BeforeEach
    void beforeTest() {
        this.recordSerializer = TestData.getIntStringTupleSerializer();
        this.record1Comparator = TestData.getIntStringTupleComparator();
        this.record2Comparator = TestData.getIntStringTupleComparator();
        this.recordPairComparator = new GenericPairComparator(this.record1Comparator, this.record2Comparator);
        this.pairSerializer = new IntPairSerializer();
        this.pairComparator = new TestData.IntPairComparator();
        this.pairRecordPairComparator = new IntPairTuplePairComparator();
        this.recordPairPairComparator = new TupleIntPairPairComparator();
        this.memoryManager = MemoryManagerBuilder.newBuilder().setMemorySize(16000000L).build();
        this.ioManager = new IOManagerAsync();
    }

    @AfterEach
    void afterTest() throws Exception {
        if (this.ioManager != null) {
            this.ioManager.close();
            this.ioManager = null;
        }
        if (this.memoryManager != null) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.memoryManager.verifyEmpty()).withFailMessage("Memory Leak: not all segments have been returned to the memory manager.", new Object[0])).isTrue();
            this.memoryManager.shutdown();
            this.memoryManager = null;
        }
    }

    @Test
    void testBuildFirst() {
        try {
            TestData.TupleGenerator generator1 = new TestData.TupleGenerator(561349061987311L, 500, 4096, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
            TestData.TupleGenerator generator2 = new TestData.TupleGenerator(231434613412342L, 500, 2048, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
            TestData.TupleGeneratorIterator input1 = new TestData.TupleGeneratorIterator(generator1, 20000);
            TestData.TupleGeneratorIterator input2 = new TestData.TupleGeneratorIterator(generator2, 1000);
            Map<Integer, Collection<TupleMatch>> expectedMatchesMap = NonReusingHashJoinIteratorITCase.joinTuples(NonReusingHashJoinIteratorITCase.collectTupleData(input1), NonReusingHashJoinIteratorITCase.collectTupleData(input2));
            TupleMatchRemovingJoin matcher = new TupleMatchRemovingJoin(expectedMatchesMap);
            DiscardingOutputCollector collector = new DiscardingOutputCollector();
            generator1.reset();
            generator2.reset();
            input1.reset();
            input2.reset();
            NonReusingBuildFirstHashJoinIterator iterator = new NonReusingBuildFirstHashJoinIterator((MutableObjectIterator)input1, (MutableObjectIterator)input2, this.recordSerializer, this.record1Comparator, this.recordSerializer, this.record2Comparator, this.recordPairComparator, this.memoryManager, this.ioManager, this.parentTask, 1.0, false, false, true);
            iterator.open();
            while (iterator.callWithNextKey((FlatJoinFunction)matcher, collector)) {
            }
            iterator.close();
            for (Map.Entry<Integer, Collection<TupleMatch>> entry : expectedMatchesMap.entrySet()) {
                ((AbstractCollectionAssert)Assertions.assertThat(entry.getValue()).withFailMessage("Collection for key %d is not empty", new Object[]{entry.getKey()})).isEmpty();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("An exception occurred during the test: " + e.getMessage()));
        }
    }

    @Test
    void testBuildFirstWithHighNumberOfCommonKeys() {
        int INPUT_1_SIZE = 200;
        int INPUT_2_SIZE = 100;
        int INPUT_1_DUPLICATES = 10;
        int INPUT_2_DUPLICATES = 2000;
        int DUPLICATE_KEY = 13;
        try {
            TestData.TupleGenerator generator1 = new TestData.TupleGenerator(561349061987311L, 500, 4096, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
            TestData.TupleGenerator generator2 = new TestData.TupleGenerator(231434613412342L, 500, 2048, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
            TestData.TupleGeneratorIterator gen1Iter = new TestData.TupleGeneratorIterator(generator1, 200);
            TestData.TupleGeneratorIterator gen2Iter = new TestData.TupleGeneratorIterator(generator2, 100);
            TestData.TupleConstantValueIterator const1Iter = new TestData.TupleConstantValueIterator(13, "LEFT String for Duplicate Keys", 10);
            TestData.TupleConstantValueIterator const2Iter = new TestData.TupleConstantValueIterator(13, "RIGHT String for Duplicate Keys", 2000);
            ArrayList<MutableObjectIterator<Object>> inList1 = new ArrayList<MutableObjectIterator<Object>>();
            inList1.add(gen1Iter);
            inList1.add(const1Iter);
            ArrayList<MutableObjectIterator<Object>> inList2 = new ArrayList<MutableObjectIterator<Object>>();
            inList2.add(gen2Iter);
            inList2.add(const2Iter);
            UnionIterator<Object> input1 = new UnionIterator<Tuple2<Integer, String>>(inList1);
            UnionIterator<Object> input2 = new UnionIterator<Tuple2<Integer, String>>(inList2);
            Map<Integer, Collection<TupleMatch>> expectedMatchesMap = NonReusingHashJoinIteratorITCase.joinTuples(NonReusingHashJoinIteratorITCase.collectTupleData(input1), NonReusingHashJoinIteratorITCase.collectTupleData(input2));
            generator1.reset();
            generator2.reset();
            const1Iter.reset();
            const2Iter.reset();
            gen1Iter.reset();
            gen2Iter.reset();
            inList1.clear();
            inList1.add(gen1Iter);
            inList1.add(const1Iter);
            inList2.clear();
            inList2.add(gen2Iter);
            inList2.add(const2Iter);
            input1 = new UnionIterator(inList1);
            input2 = new UnionIterator(inList2);
            TupleMatchRemovingJoin matcher = new TupleMatchRemovingJoin(expectedMatchesMap);
            DiscardingOutputCollector collector = new DiscardingOutputCollector();
            NonReusingBuildFirstHashJoinIterator iterator = new NonReusingBuildFirstHashJoinIterator(input1, input2, this.recordSerializer, this.record1Comparator, this.recordSerializer, this.record2Comparator, this.recordPairComparator, this.memoryManager, this.ioManager, this.parentTask, 1.0, false, false, true);
            iterator.open();
            while (iterator.callWithNextKey((FlatJoinFunction)matcher, collector)) {
            }
            iterator.close();
            for (Map.Entry<Integer, Collection<TupleMatch>> entry : expectedMatchesMap.entrySet()) {
                ((AbstractCollectionAssert)Assertions.assertThat(entry.getValue()).withFailMessage("Collection for key %d is not empty", new Object[]{entry.getKey()})).isEmpty();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("An exception occurred during the test: " + e.getMessage()));
        }
    }

    @Test
    void testBuildSecond() {
        try {
            TestData.TupleGenerator generator1 = new TestData.TupleGenerator(561349061987311L, 500, 4096, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
            TestData.TupleGenerator generator2 = new TestData.TupleGenerator(231434613412342L, 500, 2048, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
            TestData.TupleGeneratorIterator input1 = new TestData.TupleGeneratorIterator(generator1, 20000);
            TestData.TupleGeneratorIterator input2 = new TestData.TupleGeneratorIterator(generator2, 1000);
            Map<Integer, Collection<TupleMatch>> expectedMatchesMap = NonReusingHashJoinIteratorITCase.joinTuples(NonReusingHashJoinIteratorITCase.collectTupleData(input1), NonReusingHashJoinIteratorITCase.collectTupleData(input2));
            TupleMatchRemovingJoin matcher = new TupleMatchRemovingJoin(expectedMatchesMap);
            DiscardingOutputCollector collector = new DiscardingOutputCollector();
            generator1.reset();
            generator2.reset();
            input1.reset();
            input2.reset();
            NonReusingBuildSecondHashJoinIterator iterator = new NonReusingBuildSecondHashJoinIterator((MutableObjectIterator)input1, (MutableObjectIterator)input2, this.recordSerializer, this.record1Comparator, this.recordSerializer, this.record2Comparator, this.recordPairComparator, this.memoryManager, this.ioManager, this.parentTask, 1.0, false, false, true);
            iterator.open();
            while (iterator.callWithNextKey((FlatJoinFunction)matcher, collector)) {
            }
            iterator.close();
            for (Map.Entry<Integer, Collection<TupleMatch>> entry : expectedMatchesMap.entrySet()) {
                ((AbstractCollectionAssert)Assertions.assertThat(entry.getValue()).withFailMessage("Collection for key %d is not empty", new Object[]{entry.getKey()})).isEmpty();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("An exception occurred during the test: " + e.getMessage()));
        }
    }

    @Test
    void testBuildSecondWithHighNumberOfCommonKeys() {
        int INPUT_1_SIZE = 200;
        int INPUT_2_SIZE = 100;
        int INPUT_1_DUPLICATES = 10;
        int INPUT_2_DUPLICATES = 2000;
        int DUPLICATE_KEY = 13;
        try {
            TestData.TupleGenerator generator1 = new TestData.TupleGenerator(561349061987311L, 500, 4096, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
            TestData.TupleGenerator generator2 = new TestData.TupleGenerator(231434613412342L, 500, 2048, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
            TestData.TupleGeneratorIterator gen1Iter = new TestData.TupleGeneratorIterator(generator1, 200);
            TestData.TupleGeneratorIterator gen2Iter = new TestData.TupleGeneratorIterator(generator2, 100);
            TestData.TupleConstantValueIterator const1Iter = new TestData.TupleConstantValueIterator(13, "LEFT String for Duplicate Keys", 10);
            TestData.TupleConstantValueIterator const2Iter = new TestData.TupleConstantValueIterator(13, "RIGHT String for Duplicate Keys", 2000);
            ArrayList<MutableObjectIterator<Object>> inList1 = new ArrayList<MutableObjectIterator<Object>>();
            inList1.add(gen1Iter);
            inList1.add(const1Iter);
            ArrayList<MutableObjectIterator<Object>> inList2 = new ArrayList<MutableObjectIterator<Object>>();
            inList2.add(gen2Iter);
            inList2.add(const2Iter);
            UnionIterator<Object> input1 = new UnionIterator<Tuple2<Integer, String>>(inList1);
            UnionIterator<Object> input2 = new UnionIterator<Tuple2<Integer, String>>(inList2);
            Map<Integer, Collection<TupleMatch>> expectedMatchesMap = NonReusingHashJoinIteratorITCase.joinTuples(NonReusingHashJoinIteratorITCase.collectTupleData(input1), NonReusingHashJoinIteratorITCase.collectTupleData(input2));
            generator1.reset();
            generator2.reset();
            const1Iter.reset();
            const2Iter.reset();
            gen1Iter.reset();
            gen2Iter.reset();
            inList1.clear();
            inList1.add(gen1Iter);
            inList1.add(const1Iter);
            inList2.clear();
            inList2.add(gen2Iter);
            inList2.add(const2Iter);
            input1 = new UnionIterator(inList1);
            input2 = new UnionIterator(inList2);
            TupleMatchRemovingJoin matcher = new TupleMatchRemovingJoin(expectedMatchesMap);
            DiscardingOutputCollector collector = new DiscardingOutputCollector();
            NonReusingBuildSecondHashJoinIterator iterator = new NonReusingBuildSecondHashJoinIterator(input1, input2, this.recordSerializer, this.record1Comparator, this.recordSerializer, this.record2Comparator, this.recordPairComparator, this.memoryManager, this.ioManager, this.parentTask, 1.0, false, false, true);
            iterator.open();
            while (iterator.callWithNextKey((FlatJoinFunction)matcher, collector)) {
            }
            iterator.close();
            for (Map.Entry<Integer, Collection<TupleMatch>> entry : expectedMatchesMap.entrySet()) {
                ((AbstractCollectionAssert)Assertions.assertThat(entry.getValue()).withFailMessage("Collection for key %d is not empty", new Object[]{entry.getKey()})).isEmpty();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("An exception occurred during the test: " + e.getMessage()));
        }
    }

    @Test
    void testBuildFirstWithMixedDataTypes() {
        try {
            UniformIntPairGenerator input1 = new UniformIntPairGenerator(500, 40, false);
            TestData.TupleGenerator generator2 = new TestData.TupleGenerator(231434613412342L, 500, 2048, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
            TestData.TupleGeneratorIterator input2 = new TestData.TupleGeneratorIterator(generator2, 1000);
            Map<Integer, Collection<TupleIntPairMatch>> expectedMatchesMap = NonReusingHashJoinIteratorITCase.joinIntPairs(NonReusingHashJoinIteratorITCase.collectIntPairData(input1), NonReusingHashJoinIteratorITCase.collectTupleData(input2));
            TupleIntPairMatchRemovingMatcher matcher = new TupleIntPairMatchRemovingMatcher(expectedMatchesMap);
            DiscardingOutputCollector collector = new DiscardingOutputCollector();
            input1 = new UniformIntPairGenerator(500, 40, false);
            generator2.reset();
            input2.reset();
            NonReusingBuildSecondHashJoinIterator iterator = new NonReusingBuildSecondHashJoinIterator((MutableObjectIterator)input1, (MutableObjectIterator)input2, this.pairSerializer, this.pairComparator, this.recordSerializer, this.record2Comparator, this.pairRecordPairComparator, this.memoryManager, this.ioManager, this.parentTask, 1.0, false, false, true);
            iterator.open();
            while (iterator.callWithNextKey((FlatJoinFunction)matcher, collector)) {
            }
            iterator.close();
            for (Map.Entry<Integer, Collection<TupleIntPairMatch>> entry : expectedMatchesMap.entrySet()) {
                ((AbstractCollectionAssert)Assertions.assertThat(entry.getValue()).withFailMessage("Collection for key %d is not empty", new Object[]{entry.getKey()})).isEmpty();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("An exception occurred during the test: " + e.getMessage()));
        }
    }

    @Test
    void testBuildSecondWithMixedDataTypes() {
        try {
            UniformIntPairGenerator input1 = new UniformIntPairGenerator(500, 40, false);
            TestData.TupleGenerator generator2 = new TestData.TupleGenerator(231434613412342L, 500, 2048, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
            TestData.TupleGeneratorIterator input2 = new TestData.TupleGeneratorIterator(generator2, 1000);
            Map<Integer, Collection<TupleIntPairMatch>> expectedMatchesMap = NonReusingHashJoinIteratorITCase.joinIntPairs(NonReusingHashJoinIteratorITCase.collectIntPairData(input1), NonReusingHashJoinIteratorITCase.collectTupleData(input2));
            TupleIntPairMatchRemovingMatcher matcher = new TupleIntPairMatchRemovingMatcher(expectedMatchesMap);
            DiscardingOutputCollector collector = new DiscardingOutputCollector();
            input1 = new UniformIntPairGenerator(500, 40, false);
            generator2.reset();
            input2.reset();
            NonReusingBuildFirstHashJoinIterator iterator = new NonReusingBuildFirstHashJoinIterator((MutableObjectIterator)input1, (MutableObjectIterator)input2, this.pairSerializer, this.pairComparator, this.recordSerializer, this.record2Comparator, this.recordPairPairComparator, this.memoryManager, this.ioManager, this.parentTask, 1.0, false, false, true);
            iterator.open();
            while (iterator.callWithNextKey((FlatJoinFunction)matcher, collector)) {
            }
            iterator.close();
            for (Map.Entry<Integer, Collection<TupleIntPairMatch>> entry : expectedMatchesMap.entrySet()) {
                ((AbstractCollectionAssert)Assertions.assertThat(entry.getValue()).withFailMessage("Collection for key %d is not empty", new Object[]{entry.getKey()})).isEmpty();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("An exception occurred during the test: " + e.getMessage()));
        }
    }

    @Test
    void testBuildFirstAndProbeSideOuterJoin() {
        try {
            TestData.TupleGenerator generator1 = new TestData.TupleGenerator(561349061987311L, 500, 4096, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
            TestData.TupleGenerator generator2 = new TestData.TupleGenerator(231434613412342L, 1000, 2048, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
            TestData.TupleGeneratorIterator input1 = new TestData.TupleGeneratorIterator(generator1, 20000);
            TestData.TupleGeneratorIterator input2 = new TestData.TupleGeneratorIterator(generator2, 1000);
            Map<Integer, Collection<TupleMatch>> expectedMatchesMap = NonReusingHashJoinIteratorITCase.rightOuterJoinTuples(NonReusingHashJoinIteratorITCase.collectTupleData(input1), NonReusingHashJoinIteratorITCase.collectTupleData(input2));
            TupleMatchRemovingJoin matcher = new TupleMatchRemovingJoin(expectedMatchesMap);
            DiscardingOutputCollector collector = new DiscardingOutputCollector();
            generator1.reset();
            generator2.reset();
            input1.reset();
            input2.reset();
            NonReusingBuildFirstHashJoinIterator iterator = new NonReusingBuildFirstHashJoinIterator((MutableObjectIterator)input1, (MutableObjectIterator)input2, this.recordSerializer, this.record1Comparator, this.recordSerializer, this.record2Comparator, this.recordPairComparator, this.memoryManager, this.ioManager, this.parentTask, 1.0, true, false, false);
            iterator.open();
            while (iterator.callWithNextKey((FlatJoinFunction)matcher, collector)) {
            }
            iterator.close();
            for (Map.Entry<Integer, Collection<TupleMatch>> entry : expectedMatchesMap.entrySet()) {
                ((AbstractCollectionAssert)Assertions.assertThat(entry.getValue()).withFailMessage("Collection for key %d is not empty", new Object[]{entry.getKey()})).isEmpty();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("An exception occurred during the test: " + e.getMessage()));
        }
    }

    @Test
    void testBuildFirstAndBuildSideOuterJoin() {
        try {
            TestData.TupleGenerator generator1 = new TestData.TupleGenerator(561349061987311L, 500, 4096, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
            TestData.TupleGenerator generator2 = new TestData.TupleGenerator(231434613412342L, 1000, 2048, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
            TestData.TupleGeneratorIterator input1 = new TestData.TupleGeneratorIterator(generator1, 20000);
            TestData.TupleGeneratorIterator input2 = new TestData.TupleGeneratorIterator(generator2, 1000);
            Map<Integer, Collection<TupleMatch>> expectedMatchesMap = NonReusingHashJoinIteratorITCase.leftOuterJoinTuples(NonReusingHashJoinIteratorITCase.collectTupleData(input1), NonReusingHashJoinIteratorITCase.collectTupleData(input2));
            TupleMatchRemovingJoin matcher = new TupleMatchRemovingJoin(expectedMatchesMap);
            DiscardingOutputCollector collector = new DiscardingOutputCollector();
            generator1.reset();
            generator2.reset();
            input1.reset();
            input2.reset();
            NonReusingBuildFirstHashJoinIterator iterator = new NonReusingBuildFirstHashJoinIterator((MutableObjectIterator)input1, (MutableObjectIterator)input2, this.recordSerializer, this.record1Comparator, this.recordSerializer, this.record2Comparator, this.recordPairComparator, this.memoryManager, this.ioManager, this.parentTask, 1.0, false, true, false);
            iterator.open();
            while (iterator.callWithNextKey((FlatJoinFunction)matcher, collector)) {
            }
            iterator.close();
            for (Map.Entry<Integer, Collection<TupleMatch>> entry : expectedMatchesMap.entrySet()) {
                ((AbstractCollectionAssert)Assertions.assertThat(entry.getValue()).withFailMessage("Collection for key %d is not empty", new Object[]{entry.getKey()})).isEmpty();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("An exception occurred during the test: " + e.getMessage()));
        }
    }

    @Test
    void testBuildFirstAndFullOuterJoin() {
        try {
            TestData.TupleGenerator generator1 = new TestData.TupleGenerator(561349061987311L, 500, 4096, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
            TestData.TupleGenerator generator2 = new TestData.TupleGenerator(231434613412342L, 1000, 2048, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
            TestData.TupleGeneratorIterator input1 = new TestData.TupleGeneratorIterator(generator1, 20000);
            TestData.TupleGeneratorIterator input2 = new TestData.TupleGeneratorIterator(generator2, 1000);
            Map<Integer, Collection<TupleMatch>> expectedMatchesMap = NonReusingHashJoinIteratorITCase.fullOuterJoinTuples(NonReusingHashJoinIteratorITCase.collectTupleData(input1), NonReusingHashJoinIteratorITCase.collectTupleData(input2));
            TupleMatchRemovingJoin matcher = new TupleMatchRemovingJoin(expectedMatchesMap);
            DiscardingOutputCollector collector = new DiscardingOutputCollector();
            generator1.reset();
            generator2.reset();
            input1.reset();
            input2.reset();
            NonReusingBuildFirstHashJoinIterator iterator = new NonReusingBuildFirstHashJoinIterator((MutableObjectIterator)input1, (MutableObjectIterator)input2, this.recordSerializer, this.record1Comparator, this.recordSerializer, this.record2Comparator, this.recordPairComparator, this.memoryManager, this.ioManager, this.parentTask, 1.0, true, true, false);
            iterator.open();
            while (iterator.callWithNextKey((FlatJoinFunction)matcher, collector)) {
            }
            iterator.close();
            for (Map.Entry<Integer, Collection<TupleMatch>> entry : expectedMatchesMap.entrySet()) {
                ((AbstractCollectionAssert)Assertions.assertThat(entry.getValue()).withFailMessage("Collection for key %d is not empty", new Object[]{entry.getKey()})).isEmpty();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("An exception occurred during the test: " + e.getMessage()));
        }
    }

    @Test
    void testBuildSecondAndProbeSideOuterJoin() {
        try {
            TestData.TupleGenerator generator1 = new TestData.TupleGenerator(561349061987311L, 1000, 4096, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
            TestData.TupleGenerator generator2 = new TestData.TupleGenerator(231434613412342L, 500, 2048, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
            TestData.TupleGeneratorIterator input1 = new TestData.TupleGeneratorIterator(generator1, 20000);
            TestData.TupleGeneratorIterator input2 = new TestData.TupleGeneratorIterator(generator2, 1000);
            Map<Integer, Collection<TupleMatch>> expectedMatchesMap = NonReusingHashJoinIteratorITCase.leftOuterJoinTuples(NonReusingHashJoinIteratorITCase.collectTupleData(input1), NonReusingHashJoinIteratorITCase.collectTupleData(input2));
            TupleMatchRemovingJoin matcher = new TupleMatchRemovingJoin(expectedMatchesMap);
            DiscardingOutputCollector collector = new DiscardingOutputCollector();
            generator1.reset();
            generator2.reset();
            input1.reset();
            input2.reset();
            NonReusingBuildSecondHashJoinIterator iterator = new NonReusingBuildSecondHashJoinIterator((MutableObjectIterator)input1, (MutableObjectIterator)input2, this.recordSerializer, this.record1Comparator, this.recordSerializer, this.record2Comparator, this.recordPairComparator, this.memoryManager, this.ioManager, this.parentTask, 1.0, true, false, false);
            iterator.open();
            while (iterator.callWithNextKey((FlatJoinFunction)matcher, collector)) {
            }
            iterator.close();
            for (Map.Entry<Integer, Collection<TupleMatch>> entry : expectedMatchesMap.entrySet()) {
                ((AbstractCollectionAssert)Assertions.assertThat(entry.getValue()).withFailMessage("Collection for key %d is not empty", new Object[]{entry.getKey()})).isEmpty();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("An exception occurred during the test: " + e.getMessage()));
        }
    }

    @Test
    void testBuildSecondAndBuildSideOuterJoin() {
        try {
            TestData.TupleGenerator generator1 = new TestData.TupleGenerator(561349061987311L, 1000, 4096, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
            TestData.TupleGenerator generator2 = new TestData.TupleGenerator(231434613412342L, 500, 2048, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
            TestData.TupleGeneratorIterator input1 = new TestData.TupleGeneratorIterator(generator1, 20000);
            TestData.TupleGeneratorIterator input2 = new TestData.TupleGeneratorIterator(generator2, 1000);
            Map<Integer, Collection<TupleMatch>> expectedMatchesMap = NonReusingHashJoinIteratorITCase.rightOuterJoinTuples(NonReusingHashJoinIteratorITCase.collectTupleData(input1), NonReusingHashJoinIteratorITCase.collectTupleData(input2));
            TupleMatchRemovingJoin matcher = new TupleMatchRemovingJoin(expectedMatchesMap);
            DiscardingOutputCollector collector = new DiscardingOutputCollector();
            generator1.reset();
            generator2.reset();
            input1.reset();
            input2.reset();
            NonReusingBuildSecondHashJoinIterator iterator = new NonReusingBuildSecondHashJoinIterator((MutableObjectIterator)input1, (MutableObjectIterator)input2, this.recordSerializer, this.record1Comparator, this.recordSerializer, this.record2Comparator, this.recordPairComparator, this.memoryManager, this.ioManager, this.parentTask, 1.0, false, true, false);
            iterator.open();
            while (iterator.callWithNextKey((FlatJoinFunction)matcher, collector)) {
            }
            iterator.close();
            for (Map.Entry<Integer, Collection<TupleMatch>> entry : expectedMatchesMap.entrySet()) {
                ((AbstractCollectionAssert)Assertions.assertThat(entry.getValue()).withFailMessage("Collection for key %d is not empty", new Object[]{entry.getKey()})).isEmpty();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("An exception occurred during the test: " + e.getMessage()));
        }
    }

    @Test
    void testBuildSecondAndFullOuterJoin() {
        try {
            TestData.TupleGenerator generator1 = new TestData.TupleGenerator(561349061987311L, 1000, 4096, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
            TestData.TupleGenerator generator2 = new TestData.TupleGenerator(231434613412342L, 500, 2048, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
            TestData.TupleGeneratorIterator input1 = new TestData.TupleGeneratorIterator(generator1, 20000);
            TestData.TupleGeneratorIterator input2 = new TestData.TupleGeneratorIterator(generator2, 1000);
            Map<Integer, Collection<TupleMatch>> expectedMatchesMap = NonReusingHashJoinIteratorITCase.fullOuterJoinTuples(NonReusingHashJoinIteratorITCase.collectTupleData(input1), NonReusingHashJoinIteratorITCase.collectTupleData(input2));
            TupleMatchRemovingJoin matcher = new TupleMatchRemovingJoin(expectedMatchesMap);
            DiscardingOutputCollector collector = new DiscardingOutputCollector();
            generator1.reset();
            generator2.reset();
            input1.reset();
            input2.reset();
            NonReusingBuildSecondHashJoinIterator iterator = new NonReusingBuildSecondHashJoinIterator((MutableObjectIterator)input1, (MutableObjectIterator)input2, this.recordSerializer, this.record1Comparator, this.recordSerializer, this.record2Comparator, this.recordPairComparator, this.memoryManager, this.ioManager, this.parentTask, 1.0, true, true, false);
            iterator.open();
            while (iterator.callWithNextKey((FlatJoinFunction)matcher, collector)) {
            }
            iterator.close();
            for (Map.Entry<Integer, Collection<TupleMatch>> entry : expectedMatchesMap.entrySet()) {
                ((AbstractCollectionAssert)Assertions.assertThat(entry.getValue()).withFailMessage("Collection for key %d is not empty", new Object[]{entry.getKey()})).isEmpty();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)("An exception occurred during the test: " + e.getMessage()));
        }
    }

    public static Map<Integer, Collection<TupleMatch>> joinTuples(Map<Integer, Collection<String>> leftMap, Map<Integer, Collection<String>> rightMap) {
        HashMap<Integer, Collection<TupleMatch>> map = new HashMap<Integer, Collection<TupleMatch>>();
        for (Integer key : leftMap.keySet()) {
            Collection<String> leftValues = leftMap.get(key);
            Collection<String> rightValues = rightMap.get(key);
            if (rightValues == null) continue;
            if (!map.containsKey(key)) {
                map.put(key, new ArrayList());
            }
            Collection matchedValues = (Collection)map.get(key);
            for (String leftValue : leftValues) {
                for (String rightValue : rightValues) {
                    matchedValues.add(new TupleMatch(leftValue, rightValue));
                }
            }
        }
        return map;
    }

    public static Map<Integer, Collection<TupleMatch>> leftOuterJoinTuples(Map<Integer, Collection<String>> leftMap, Map<Integer, Collection<String>> rightMap) {
        HashMap<Integer, Collection<TupleMatch>> map = new HashMap<Integer, Collection<TupleMatch>>();
        for (Integer key : leftMap.keySet()) {
            Collection<String> leftValues = leftMap.get(key);
            Collection<String> rightValues = rightMap.get(key);
            if (!map.containsKey(key)) {
                map.put(key, new ArrayList());
            }
            Collection matchedValues = (Collection)map.get(key);
            for (String leftValue : leftValues) {
                if (rightValues != null) {
                    for (String rightValue : rightValues) {
                        matchedValues.add(new TupleMatch(leftValue, rightValue));
                    }
                    continue;
                }
                matchedValues.add(new TupleMatch(leftValue, null));
            }
        }
        return map;
    }

    public static Map<Integer, Collection<TupleMatch>> rightOuterJoinTuples(Map<Integer, Collection<String>> leftMap, Map<Integer, Collection<String>> rightMap) {
        HashMap<Integer, Collection<TupleMatch>> map = new HashMap<Integer, Collection<TupleMatch>>();
        for (Integer key : rightMap.keySet()) {
            Collection<String> leftValues = leftMap.get(key);
            Collection<String> rightValues = rightMap.get(key);
            if (!map.containsKey(key)) {
                map.put(key, new ArrayList());
            }
            Collection matchedValues = (Collection)map.get(key);
            for (String rightValue : rightValues) {
                if (leftValues != null) {
                    for (String leftValue : leftValues) {
                        matchedValues.add(new TupleMatch(leftValue, rightValue));
                    }
                    continue;
                }
                matchedValues.add(new TupleMatch(null, rightValue));
            }
        }
        return map;
    }

    public static Map<Integer, Collection<TupleMatch>> fullOuterJoinTuples(Map<Integer, Collection<String>> leftMap, Map<Integer, Collection<String>> rightMap) {
        Collection matchedValues;
        Collection<String> rightValues;
        Collection<String> leftValues;
        HashMap<Integer, Collection<TupleMatch>> map = new HashMap<Integer, Collection<TupleMatch>>();
        for (Integer key : rightMap.keySet()) {
            leftValues = leftMap.get(key);
            rightValues = rightMap.get(key);
            if (!map.containsKey(key)) {
                map.put(key, new ArrayList());
            }
            matchedValues = (Collection)map.get(key);
            for (String rightValue : rightValues) {
                if (leftValues != null) {
                    for (String leftValue : leftValues) {
                        matchedValues.add(new TupleMatch(leftValue, rightValue));
                    }
                    continue;
                }
                matchedValues.add(new TupleMatch(null, rightValue));
            }
        }
        for (Integer key : leftMap.keySet()) {
            leftValues = leftMap.get(key);
            rightValues = rightMap.get(key);
            if (rightValues != null) continue;
            if (!map.containsKey(key)) {
                map.put(key, new ArrayList());
            }
            matchedValues = (Collection)map.get(key);
            for (String leftValue : leftValues) {
                matchedValues.add(new TupleMatch(leftValue, null));
            }
        }
        return map;
    }

    public static Map<Integer, Collection<TupleIntPairMatch>> joinIntPairs(Map<Integer, Collection<Integer>> leftMap, Map<Integer, Collection<String>> rightMap) {
        HashMap<Integer, Collection<TupleIntPairMatch>> map = new HashMap<Integer, Collection<TupleIntPairMatch>>();
        for (Integer i : leftMap.keySet()) {
            Collection<Integer> leftValues = leftMap.get(i);
            Collection<String> rightValues = rightMap.get(i);
            if (rightValues == null) continue;
            if (!map.containsKey(i)) {
                map.put(i, new ArrayList());
            }
            Collection matchedValues = (Collection)map.get(i);
            for (Integer v : leftValues) {
                for (String val : rightValues) {
                    matchedValues.add(new TupleIntPairMatch(v, val));
                }
            }
        }
        return map;
    }

    public static Map<Integer, Collection<String>> collectTupleData(MutableObjectIterator<Tuple2<Integer, String>> iter) throws Exception {
        HashMap<Integer, Collection<String>> map = new HashMap<Integer, Collection<String>>();
        Tuple2 pair = new Tuple2();
        while ((pair = (Tuple2)iter.next((Object)pair)) != null) {
            Integer key = (Integer)pair.f0;
            if (!map.containsKey(key)) {
                map.put(key, new ArrayList());
            }
            Collection values = (Collection)map.get(key);
            values.add(pair.f1);
        }
        return map;
    }

    public static Map<Integer, Collection<Integer>> collectIntPairData(MutableObjectIterator<IntPair> iter) throws Exception {
        HashMap<Integer, Collection<Integer>> map = new HashMap<Integer, Collection<Integer>>();
        IntPair pair = new IntPair();
        while ((pair = (IntPair)iter.next((Object)pair)) != null) {
            int key = pair.getKey();
            int value = pair.getValue();
            if (!map.containsKey(key)) {
                map.put(key, new ArrayList());
            }
            Collection values = (Collection)map.get(key);
            values.add(value);
        }
        return map;
    }

    static final class TupleIntPairPairComparator
    extends TypePairComparator<Tuple2<Integer, String>, IntPair> {
        private int reference;

        TupleIntPairPairComparator() {
        }

        public void setReference(Tuple2<Integer, String> reference) {
            this.reference = (Integer)reference.f0;
        }

        public boolean equalToReference(IntPair candidate) {
            return this.reference == candidate.getKey();
        }

        public int compareToReference(IntPair candidate) {
            return candidate.getKey() - this.reference;
        }
    }

    static final class IntPairTuplePairComparator
    extends TypePairComparator<IntPair, Tuple2<Integer, String>> {
        private int reference;

        IntPairTuplePairComparator() {
        }

        public void setReference(IntPair reference) {
            this.reference = reference.getKey();
        }

        public boolean equalToReference(Tuple2<Integer, String> candidate) {
            try {
                return (Integer)candidate.f0 == this.reference;
            }
            catch (NullPointerException npex) {
                throw new NullKeyFieldException();
            }
        }

        public int compareToReference(Tuple2<Integer, String> candidate) {
            try {
                return (Integer)candidate.f0 - this.reference;
            }
            catch (NullPointerException npex) {
                throw new NullKeyFieldException();
            }
        }
    }

    static final class TupleIntPairMatchRemovingMatcher
    implements FlatJoinFunction<IntPair, Tuple2<Integer, String>, Tuple2<Integer, String>> {
        private final Map<Integer, Collection<TupleIntPairMatch>> toRemoveFrom;

        protected TupleIntPairMatchRemovingMatcher(Map<Integer, Collection<TupleIntPairMatch>> map) {
            this.toRemoveFrom = map;
        }

        public void join(IntPair rec1, Tuple2<Integer, String> rec2, Collector<Tuple2<Integer, String>> out) throws Exception {
            int k = rec1.getKey();
            int v = rec1.getValue();
            Integer key = (Integer)rec2.f0;
            String value = (String)rec2.f1;
            ((AbstractIntegerAssert)Assertions.assertThat((Integer)key).withFailMessage("Key does not match for matching IntPair Tuple combination.", new Object[0])).isEqualTo(k);
            Collection<TupleIntPairMatch> matches = this.toRemoveFrom.get(key);
            ((AbstractCollectionAssert)Assertions.assertThat(matches).withFailMessage("Match %d - %d:%s is unexpected.", new Object[]{k, v, value})).isNotNull();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)matches.remove(new TupleIntPairMatch(v, value))).withFailMessage("Produced match was not contained: %d - %d:%s", new Object[]{key, v, value})).isTrue();
            if (matches.isEmpty()) {
                this.toRemoveFrom.remove(key);
            }
        }
    }

    static final class TupleMatchRemovingJoin
    implements FlatJoinFunction<Tuple2<Integer, String>, Tuple2<Integer, String>, Tuple2<Integer, String>> {
        private final Map<Integer, Collection<TupleMatch>> toRemoveFrom;

        protected TupleMatchRemovingJoin(Map<Integer, Collection<TupleMatch>> map) {
            this.toRemoveFrom = map;
        }

        public void join(Tuple2<Integer, String> rec1, Tuple2<Integer, String> rec2, Collector<Tuple2<Integer, String>> out) throws Exception {
            int key = rec1 != null ? (Integer)rec1.f0 : (Integer)rec2.f0;
            String value1 = rec1 != null ? (String)rec1.f1 : null;
            String value2 = rec2 != null ? (String)rec2.f1 : null;
            Collection<TupleMatch> matches = this.toRemoveFrom.get(key);
            ((AbstractCollectionAssert)Assertions.assertThat(matches).withFailMessage("Match %d - %s:%s is unexpected.", new Object[]{key, value1, value2})).isNotNull();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)matches.remove(new TupleMatch(value1, value2))).withFailMessage("Produced match was not contained: %d - %s:%s", new Object[]{key, value1, value2})).isTrue();
            if (matches.isEmpty()) {
                this.toRemoveFrom.remove(key);
            }
        }
    }

    static class TupleIntPairMatch {
        private final int left;
        private final String right;

        public TupleIntPairMatch(int left, String right) {
            this.left = left;
            this.right = right;
        }

        public boolean equals(Object obj) {
            TupleIntPairMatch o = (TupleIntPairMatch)obj;
            return this.left == o.left && this.right.equals(o.right);
        }

        public int hashCode() {
            return this.left ^ this.right.hashCode();
        }

        public String toString() {
            return this.left + ", " + this.right;
        }
    }

    public static class TupleMatch {
        private final String left;
        private final String right;

        public TupleMatch(String left, String right) {
            this.left = left;
            this.right = right;
        }

        public boolean equals(Object obj) {
            TupleMatch that = (TupleMatch)obj;
            return (this.right == null ? that.right == null : that.right != null && this.right.equals(that.right)) && (this.left == null ? that.left == null : that.left != null && this.left.equals(that.left));
        }

        public int hashCode() {
            int hc = this.left != null ? this.left.hashCode() : 23;
            return hc ^= this.right != null ? this.right.hashCode() : 41;
        }

        public String toString() {
            String s = this.left == null ? "<null>" : this.left;
            s = s + ", " + (this.right == null ? "<null>" : this.right);
            return s;
        }
    }
}

